Demo-3.cmd  

Demo for CirclePack showing some of its screen, canvases, features, etc.

[1]:=act 0;close -p1;close -p2;set_cycle 5000;infile_read smallhex.p;set_screen -c 0 -.1 -h 2.3;disp -w -c -t Typical hyperbolic circle packing.;

[2]:=disp -w -c -t Here are windows associated with this canvas.;open sm;open sp;

[3]:=close sm;close sp;disp -w -c -t Here are some additional windows.;open p;open h;

[4]:=close p;close h;disp -w -c -t See this `Help File'. press "Help" key for details on a specific button.; open ?;

[5]:=close ?;infile_read -p1 square5x5.p;disp -p1 -w -f;delay 1;infile_read -p2 misc.p;disp -w -c;disp -p2  -cf -t There are 3 canvases, each can have a pack to work with.;

[6]:=close -p1;close -p2;disp -w -c -t Now we see some display options.;

[7]:=copy 1;act 1;disp -w -c -nc -t Circles and their labels;

[8]:=disp -w -f -t The underlying complex;

[9]:=color -c rad;disp -w -cf -t Circles colored according to radius;

[10]:=color -f area;disp -w -ff -t Faces colored by area.;

[11]:=act 0;set_rad -.1 b;repack;fix;disp -w -c -t This is the `Andreev' or extremal packing with same complex.;

[12]:=h_to_e;h_to_e -p1; color -p1 -c -q 0;disp -w -c -u -t Pack 1 has been converted to euclidean geometry;disp -p1 -w -cf -t The color coding compares euclidean radii of pack 0 to pack 1.;

[13]:=act 0;disp -p1 -w;infile_read square5x5.p;set_screen -c 0 -.1 -h 2.3;disp -w -c -t Here is another packing.;

[14]:=copy 1;set_overlap -p1 .333 a;repack -p1;fix -p1;disp -p1 -w -c -t We have prescribed that the circles overlap.;

[15]:=set_screen -c -.8 -.8 -h 4.0;disp -w -c -t We can adjust the screen size and center, etc.;

[16]: =disp -p1 -w -c -t We have sent this picture to the printer (with luck).;print -p1;

[17]:=close -p1;act 0;infile_read Owl.p;set_screen -c 0.0 -.1 -h 2.6;disp -w -cf -cfbg 21 22 -t Additional info? See other `scripts' and `CP_help.info'. Enjoy.;

[n]:= script Demo-4.cmd;


--------------------------- data -----------------------------

square5x5.p
NODECOUNT:   41

ALPHA/BETA/GAMMA:   3  1  1

GEOMETRY:   hyperbolic

FLOWERS: 

1  4     6  4  2  32  29  

2  8     1  4  7  5  3  33  30  32  1  

3  8     2  5  8  16  14  40  31  33  2  

4  4     1  6  7  2  1  

5  4     2  7  8  3  2  

6  4     11  9  7  4  1  

7  8     4  6  9  12  10  8  5  2  4  

8  8     3  5  7  10  13  20  18  16  3  

9  4     6  11  12  7  6  

10  4     7  12  13  8  7  

11  2     12  9  6  

12  4     13  10  7  9  11  

13  4     22  20  8  10  12  

14  8     3  16  18  17  15  41  38  40  3  

15  4     39  41  14  17  19  

16  4     3  8  18  14  3  

17  4     14  18  19  15  14  

18  8     16  8  20  22  21  19  17  14  16  

19  4     15  17  18  21  23  

20  4     8  13  22  18  8  

21  4     18  22  23  19  18  

22  4     23  21  18  20  13  

23  2     19  21  22  

24  2     29  27  25  

25  4     24  27  30  28  26  

26  4     25  28  31  36  34  

27  4     24  29  30  25  24  

28  4     25  30  31  26  25  

29  4     1  32  30  27  24  

30  8     27  29  32  2  33  31  28  25  27  

31  8     26  28  30  33  3  40  38  36  26  

32  4     29  1  2  30  29  

33  4     30  2  3  31  30  

34  4     26  36  38  37  35  

35  2     34  37  39  

36  4     26  31  38  34  26  

37  4     34  38  39  35  34  

38  8     36  31  40  14  41  39  37  34  36  

39  4     35  37  38  41  15  

40  4     31  3  14  38  31  

41  4     38  14  15  39  38  

RADII: 
  0.245613   0.212859   0.203912   0.093927   0.085988 
  0.257906   0.222474   0.212839   0.103290   0.093928 
  0.306509   0.257903   0.245613   0.212842   0.245613 
  0.085986   0.093928   0.222470   0.257906   0.093928 
  0.103294   0.257903   0.306507   0.306963   0.257906 
  0.245613   0.103343   0.093934   0.258065   0.222514 
  0.212855   0.093944   0.085994   0.258065   0.306963 
  0.093946   0.103343   0.222506   0.257902   0.085989 
  0.093932 

CENTERS:
  0.000000  0.411670    0.000023  0.205421    -0.000000  0.000000  
  -0.101808  0.305374    -0.101767  0.101800    -0.205864  0.411514  
  -0.205424  0.205494    -0.205411  0.000048    -0.305270  0.305340  
  -0.305333  0.101898    -0.412191  0.412268    -0.411446  0.205982  
  -0.411654  0.000113    -0.000078  -0.205412    -0.000183  -0.411657  
  -0.101814  -0.101751    -0.101949  -0.305316    -0.205524  -0.205388  
  -0.206049  -0.411414    -0.305397  -0.101739    -0.305407  -0.305195  
  -0.411542  -0.205790    -0.412336  -0.412115    0.412377  0.412419  
  0.411511  0.206014    0.411803  0.000172    0.305341  0.305394  
  0.305381  0.101834    0.205918  0.411606    0.205488  0.205464  
  0.205430  0.000001    0.101867  0.305372    0.101794  0.101777  
  0.411888  -0.205713    0.412564  -0.412163    0.305615  -0.101733  
  0.305218  -0.305466    0.205493  -0.205458    0.205678  -0.411626  
  0.101801  -0.101778    0.101692  -0.305420  

END

square9x9.p
NODECOUNT:   145

ALPHA/BETA/GAMMA:   24  97  112

GEOMETRY:   euclidean

FLOWERS: 

1  8     25  27  6  4  2  131  116  114  25  

2  8     1  4  7  5  3  130  133  131  1  

3  4     132  130  2  5  8  

4  4     1  6  7  2  1  

5  4     2  7  8  3  2  

6  8     11  9  7  4  1  27  29  31  11  

7  8     4  6  9  12  10  8  5  2  4  

8  4     3  5  7  10  13  

9  4     6  11  12  7  6  

10  4     7  12  13  8  7  

11  8     16  14  12  9  6  31  33  35  16  

12  8     13  10  7  9  11  14  17  15  13  

13  4     8  10  12  15  18  

14  4     11  16  17  12  11  

15  4     12  17  18  13  12  

16  8     21  19  17  14  11  35  37  39  21  

17  8     14  16  19  22  20  18  15  12  14  

18  4     13  15  17  20  23  

19  4     16  21  22  17  16  

20  4     17  22  23  18  17  

21  4     22  19  16  39  41  

22  4     23  20  17  19  21  

23  2     18  20  22  

24  8     43  45  28  26  25  115  100  98  43  

25  8     24  26  29  27  1  114  117  115  24  

26  4     24  28  29  25  24  

27  4     25  29  6  1  25  

28  8     32  30  29  26  24  45  47  49  32  

29  8     26  28  30  33  31  6  27  25  26  

30  4     28  32  33  29  28  

31  4     29  33  11  6  29  

32  8     36  34  33  30  28  49  51  53  36  

33  8     11  31  29  30  32  34  37  35  11  

34  4     32  36  37  33  32  

35  4     33  37  16  11  33  

36  8     40  38  37  34  32  53  55  57  40  

37  8     34  36  38  41  39  16  35  33  34  

38  4     36  40  41  37  36  

39  4     37  41  21  16  37  

40  4     41  38  36  57  59  

41  4     21  39  37  38  40  

42  8     61  63  46  44  43  99  80  78  61  

43  8     42  44  47  45  24  98  101  99  42  

44  4     42  46  47  43  42  

45  4     43  47  28  24  43  

46  8     50  48  47  44  42  63  65  67  50  

47  8     44  46  48  51  49  28  45  43  44  

48  4     46  50  51  47  46  

49  4     47  51  32  28  47  

50  8     54  52  51  48  46  67  69  71  54  

51  8     32  49  47  48  50  52  55  53  32  

52  4     50  54  55  51  50  

53  4     51  55  36  32  51  

54  8     58  56  55  52  50  71  73  75  58  

55  8     52  54  56  59  57  36  53  51  52  

56  4     54  58  59  55  54  

57  4     55  59  40  36  55  

58  4     59  56  54  75  77  

59  4     40  57  55  56  58  

60  4     64  62  61  79  82  

61  8     60  62  65  63  42  78  81  79  60  

62  4     60  64  65  61  60  

63  4     61  65  46  42  61  

64  4     68  66  65  62  60  

65  8     62  64  66  69  67  46  63  61  62  

66  4     64  68  69  65  64  

67  4     65  69  50  46  65  

68  4     72  70  69  66  64  

69  8     50  67  65  66  68  70  73  71  50  

70  4     68  72  73  69  68  

71  4     69  73  54  50  69  

72  4     76  74  73  70  68  

73  8     70  72  74  77  75  54  71  69  70  

74  4     72  76  77  73  72  

75  4     73  77  58  54  73  

76  2     77  74  72  

77  4     58  75  73  74  76  

78  4     42  80  81  61  42  

79  4     61  81  82  60  61  

80  8     85  83  81  78  42  99  101  103  85  

81  8     78  80  83  86  84  82  79  61  78  

82  4     60  79  81  84  87  

83  4     80  85  86  81  80  

84  4     81  86  87  82  81  

85  8     90  88  86  83  80  103  105  107  90  

86  8     87  84  81  83  85  88  91  89  87  

87  4     82  84  86  89  92  

88  4     85  90  91  86  85  

89  4     86  91  92  87  86  

90  8     95  93  91  88  85  107  109  111  95  

91  8     88  90  93  96  94  92  89  86  88  

92  4     87  89  91  94  97  

93  4     90  95  96  91  90  

94  4     91  96  97  92  91  

95  4     96  93  90  111  113  

96  4     97  94  91  93  95  

97  2     92  94  96  

98  4     24  100  101  43  24  

99  4     43  101  80  42  43  

100  8     104  102  101  98  24  115  117  119  104  

101  8     98  100  102  105  103  80  99  43  98  

102  4     100  104  105  101  100  

103  4     101  105  85  80  101  

104  8     108  106  105  102  100  119  121  123  108  

105  8     85  103  101  102  104  106  109  107  85  

106  4     104  108  109  105  104  

107  4     105  109  90  85  105  

108  8     112  110  109  106  104  123  125  127  112  

109  8     106  108  110  113  111  90  107  105  106  

110  4     108  112  113  109  108  

111  4     109  113  95  90  109  

112  4     113  110  108  127  129  

113  4     95  111  109  110  112  

114  4     1  116  117  25  1  

115  4     25  117  100  24  25  

116  8     120  118  117  114  1  131  133  135  120  

117  8     114  116  118  121  119  100  115  25  114  

118  4     116  120  121  117  116  

119  4     117  121  104  100  117  

120  8     124  122  121  118  116  135  137  139  124  

121  8     104  119  117  118  120  122  125  123  104  

122  4     120  124  125  121  120  

123  4     121  125  108  104  121  

124  8     128  126  125  122  120  139  141  143  128  

125  8     122  124  126  129  127  108  123  121  122  

126  4     124  128  129  125  124  

127  4     125  129  112  108  125  

128  4     129  126  124  143  145  

129  4     112  127  125  126  128  

130  4     3  132  133  2  3  

131  4     2  133  116  1  2  

132  4     136  134  133  130  3  

133  8     130  132  134  137  135  116  131  2  130  

134  4     132  136  137  133  132  

135  4     133  137  120  116  133  

136  4     140  138  137  134  132  

137  8     120  135  133  134  136  138  141  139  120  

138  4     136  140  141  137  136  

139  4     137  141  124  120  137  

140  4     144  142  141  138  136  

141  8     138  140  142  145  143  124  139  137  138  

142  4     140  144  145  141  140  

143  4     141  145  128  124  141  

144  2     145  142  140  

145  4     128  143  141  142  144  

RADII: 
  0.099999   0.099999   0.100000   0.041421   0.041421 
  0.099999   0.099999   0.100000   0.041421   0.041421 
  0.099999   0.100000   0.100000   0.041421   0.041421 
  0.100000   0.100000   0.100000   0.041421   0.041421 
  0.100000   0.100000   0.100000   0.099998   0.099998 
  0.041421   0.041421   0.099998   0.099998   0.041421 
  0.041421   0.099999   0.099999   0.041421   0.041421 
  0.099999   0.099999   0.041421   0.041421   0.100000 
  0.100000   0.099999   0.099998   0.041421   0.041421 
  0.099999   0.099998   0.041421   0.041421   0.099999 
  0.099999   0.041421   0.041421   0.100000   0.099999 
  0.041421   0.041421   0.100000   0.100000   0.100000 
  0.099999   0.041421   0.041421   0.100000   0.099999 
  0.041421   0.041421   0.100000   0.100000   0.041421 
  0.041421   0.100000   0.100000   0.041421   0.041421 
  0.100000   0.100000   0.041421   0.041421   0.099999 
  0.099999   0.100000   0.041421   0.041421   0.099999 
  0.100000   0.100000   0.041421   0.041421   0.100000 
  0.100000   0.100000   0.041421   0.041421   0.100000 
  0.100000   0.100000   0.041421   0.041421   0.099998 
  0.099998   0.041421   0.041421   0.099999   0.099999 
  0.041421   0.041421   0.099999   0.099999   0.041421 
  0.041421   0.100000   0.100000   0.041421   0.041421 
  0.099999   0.099998   0.041421   0.041421   0.099999 
  0.099999   0.041421   0.041421   0.100000   0.099999 
  0.041421   0.041421   0.100000   0.100000   0.041421 
  0.041421   0.100000   0.099999   0.041421   0.041421 
  0.100000   0.100000   0.041421   0.041421   0.100000 
  0.100000   0.041421   0.041421   0.100000   0.100000 


CENTERS:
  0.399993  -0.000000    0.599986  -0.000007    0.799987  -0.000011  
  0.499983  -0.100002    0.699981  -0.100011    0.399978  -0.199995  
  0.599976  -0.200008    0.799980  -0.200011    0.499971  -0.300001  
  0.699970  -0.300013    0.399965  -0.399993    0.599964  -0.400006  
  0.799972  -0.400011    0.499957  -0.499999    0.699957  -0.500013  
  0.399951  -0.599992    0.599950  -0.600006    0.799959  -0.600011  
  0.499944  -0.699999    0.699943  -0.700012    0.399937  -0.799991  
  0.599937  -0.800005    0.799945  -0.800011    0.000000  -0.000000  
  0.199996  0.000000    0.099998  -0.099998    0.299995  -0.099998  
  -0.000000  -0.199996    0.199996  -0.199996    0.099998  -0.299995  
  0.299995  -0.299995    -0.000001  -0.399993    0.199997  -0.399994  
  0.099997  -0.499992    0.299996  -0.499992    -0.000002  -0.599991  
  0.199997  -0.599992    0.099997  -0.699991    0.299996  -0.699991  
  -0.000004  -0.799991    0.199996  -0.799991    -0.399993  -0.000001  
  -0.199996  -0.000001    -0.299994  -0.100000    -0.099997  -0.099999  
  -0.399992  -0.199999    -0.199995  -0.199998    -0.299993  -0.299997  
  -0.099999  -0.299994    -0.399991  -0.399997    -0.199999  -0.399992  
  -0.299995  -0.499994    -0.100001  -0.499991    -0.399995  -0.599993  
  -0.199996  -0.599993    -0.299996  -0.699993    -0.100003  -0.699990  
  -0.399996  -0.799992    -0.200004  -0.799989    -0.799989  0.000001  
  -0.599990  -0.000000    -0.699990  -0.099999    -0.499991  -0.100000  
  -0.799990  -0.199999    -0.599991  -0.199999    -0.699990  -0.299998  
  -0.499991  -0.299998    -0.799990  -0.399999    -0.599990  -0.399998  
  -0.699992  -0.499987    -0.499993  -0.499991    -0.799994  -0.599985  
  -0.599994  -0.599989    -0.699995  -0.699990    -0.499995  -0.699992  
  -0.799996  -0.799989    -0.599996  -0.799991    -0.499992  0.099997  
  -0.699990  0.099998    -0.399993  0.199996    -0.599991  0.199996  
  -0.799987  0.200001    -0.499993  0.299994    -0.699990  0.299996  
  -0.399994  0.399994    -0.599991  0.399995    -0.799985  0.400001  
  -0.499994  0.499992    -0.699992  0.499992    -0.399996  0.599993  
  -0.599995  0.599991    -0.799983  0.600001    -0.499996  0.699991  
  -0.699996  0.699990    -0.399997  0.799992    -0.599997  0.799991  
  -0.799984  0.800001    -0.099998  0.099998    -0.299995  0.099997  
  -0.000001  0.199996    -0.199997  0.199995    -0.099999  0.299994  
  -0.299997  0.299993    -0.000001  0.399993    -0.199998  0.399993  
  -0.100000  0.499992    -0.299998  0.499991    -0.000001  0.599991  
  -0.199999  0.599991    -0.100000  0.699991    -0.299999  0.699990  
  0.000000  0.799991    -0.200000  0.799991    0.299994  0.099998  
  0.099998  0.099998    0.399993  0.199997    0.199996  0.199997  
  0.299995  0.299994    0.099998  0.299995    0.399995  0.399992  
  0.199997  0.399993    0.299997  0.499990    0.099998  0.499992  
  0.399997  0.599988    0.199998  0.599990    0.299999  0.699989  
  0.099999  0.699990    0.400000  0.799987    0.200000  0.799990  
  0.699988  0.099990    0.499992  0.099998    0.799991  0.199989  
  0.599991  0.199992    0.699992  0.299990    0.499993  0.299992  
  0.799993  0.399989    0.599993  0.399991    0.699995  0.499984  
  0.499995  0.499987    0.799996  0.599982    0.599997  0.599986  
  0.699998  0.699983    0.499998  0.699986    0.800000  0.799981  
  0.600000  0.799984  

END

smallhex.p
NODECOUNT:   37

ALPHA/BETA/GAMMA:   1  3  9

GEOMETRY:   hyperbolic

FLOWERS: 

1  6     13  11  12  10  19  18  13  

2  6     3  7  11  13  21  22  3  

3  3     4  7  2  22  

4  2     5  7  3  

5  3     14  6  7  4  

6  6     8  12  11  7  5  14  8  

7  6     11  2  3  4  5  6  11  

8  6     9  12  6  14  25  26  9  

9  6     20  10  12  8  26  27  20  

10  6     15  19  1  12  9  20  15  

11  6     2  7  6  12  1  13  2  

12  6     11  6  8  9  10  1  11  

13  6     21  2  11  1  18  24  21  

14  3     25  8  6  5  

15  6     36  16  19  10  20  29  36  

16  6     32  17  19  15  36  37  32  

17  6     23  18  19  16  32  33  23  

18  6     13  1  19  17  23  24  13  

19  6     1  10  15  16  17  18  1  

20  6     15  10  9  27  28  29  15  

21  6     22  2  13  24  30  31  22  

22  3     3  2  21  31  

23  6     24  18  17  33  34  35  24  

24  6     30  21  13  18  23  35  30  

25  2     26  8  14  

26  3     27  9  8  25  

27  3     28  20  9  26  

28  2     29  20  27  

29  3     36  15  20  28  

30  3     31  21  24  35  

31  2     22  21  30  

32  3     33  17  16  37  

33  3     34  23  17  32  

34  2     35  23  33  

35  3     30  24  23  34  

36  3     37  16  15  29  

37  2     32  16  36  

RADII: 
  0.219065   0.256547   0.333333   0.393047   0.333333 
  0.256547   0.272138   0.272138   0.256547   0.230257 
  0.230257   0.230257   0.230257   0.333333   0.256547 
  0.272138   0.256547   0.230257   0.230257   0.272138 
  0.272138   0.333333   0.272138   0.256547   0.393047 
  0.333333   0.333333   0.393047   0.333333   0.333333 
  0.393047   0.333333   0.333333   0.393047   0.333333 
  0.333333   0.393047 

CENTERS:
  0.000000  0.000000    0.331909  -0.191628    0.555490  -0.192427  
  0.668735  0.000000    0.555490  0.192427    0.331909  0.191628  
  0.442921  -0.000000    0.221460  0.383580    0.000000  0.383255  
  -0.110478  0.191353    0.220956  0.000000    0.110478  0.191353  
  0.110478  -0.191353    0.444392  0.384855    -0.331909  0.191628  
  -0.442921  -0.000000    -0.331909  -0.191628    -0.110478  -0.191353  
  -0.220956  0.000000    -0.221460  0.383580    0.221460  -0.383580  
  0.444392  -0.384855    -0.221460  -0.383580    0.000000  -0.383255  
  0.334367  0.579141    0.111098  0.577282    -0.111098  0.577282  
  -0.334367  0.579141    -0.444392  0.384855    0.111098  -0.577282  
  0.334367  -0.579141    -0.555490  -0.192427    -0.444392  -0.384855  
  -0.334367  -0.579141    -0.111098  -0.577282    -0.555490  0.192427  
  -0.668735  -0.000000  

ANGLESUMS: 
  6.283185    6.283185    2.761285    1.673849    2.761285  
  6.283185    6.283185    6.283185    6.283185    6.283185  
  6.283185    6.283185    6.283185    2.761285    6.283185  
  6.283185    6.283185    6.283185    6.283185    6.283185  
  6.283185    2.761285    6.283185    6.283185    1.673849  
  2.761285    2.761285    1.673849    2.761285    2.761285  
  1.673849    2.761285    2.761285    1.673849    2.761285  
  2.761285    1.673849  


END


Owl.p
NODECOUNT:   80

ALPHA/BETA/GAMMA:   7  80  44

GEOMETRY:   hyperbolic

FLOWERS: 

1  5     74  73  6  4  2  58  

2  8     1  4  7  5  3  56  57  58  1  

3  6     56  2  5  8  14  20  37  

4  4     1  6  7  2  1  

5  4     2  7  8  3  2  

6  7     73  71  11  9  7  4  1  73  

7  8     4  6  9  12  10  8  5  2  4  

8  10     18  17  16  15  14  3  5  7  10  13  18  

9  4     6  11  12  7  6  

10  4     7  12  13  8  7  

11  5     43  12  9  6  71  72  

12  8     43  42  41  13  10  7  9  11  43  

13  6     40  19  18  8  10  12  41  

14  5     22  20  3  8  15  22  

15  4     22  14  8  16  22  

16  6     23  22  15  8  17  21  23  

17  4     21  16  8  18  21  

18  5     21  17  8  13  19  21  

19  4     40  21  18  13  40  

20  4     3  14  22  37  3  

21  15     40  39  38  34  33  32  28  26  25  24  23  16  17  18  19  40  

22  15     20  14  15  16  23  24  25  26  27  29  30  31  35  36  37  20  

23  4     24  22  16  21  24  

24  4     25  22  23  21  25  

25  4     26  22  24  21  26  

26  5     28  27  22  25  21  28  

27  3     29  22  26  28  

28  3     27  26  21  32  

29  2     30  22  27  

30  2     31  22  29  

31  2     35  22  30  

32  2     28  21  33  

33  2     32  21  34  

34  2     33  21  38  

35  2     36  22  31  

36  2     37  22  35  

37  3     3  20  22  36  

38  2     34  21  39  

39  2     38  21  40  

40  3     39  21  19  13  

41  3     13  12  42  44  

42  7     47  46  45  44  41  12  43  47  

43  3     47  42  12  11  

44  2     41  42  45  

45  4     44  42  46  48  50  

46  5     49  48  45  42  47  49  

47  4     53  49  46  42  43  

48  6     52  51  50  45  46  49  52  

49  5     53  52  48  46  47  53  

50  2     45  48  51  

51  3     50  48  52  54  

52  6     55  54  51  48  49  53  55  

53  3     55  52  49  47  

54  2     51  52  55  

55  2     54  52  53  

56  3     59  57  2  3  

57  7     58  2  56  59  60  61  62  58  

58  3     1  2  57  62  

59  2     60  57  56  

60  4     64  63  61  57  59  

61  5     62  57  60  63  66  62  

62  4     58  57  61  66  67  

63  6     68  66  61  60  64  65  68  

64  2     65  63  60  

65  3     70  68  63  64  

66  5     68  67  62  61  63  68  

67  3     62  66  68  69  

68  6     70  69  67  66  63  65  70  

69  2     67  68  70  

70  2     69  68  65  

71  6     76  75  72  11  6  73  76  

72  2     11  71  75  

73  6     77  76  71  6  1  74  77  

74  2     77  73  1  

75  3     72  71  76  78  

76  7     80  79  78  75  71  73  77  80  

77  3     80  76  73  74  

78  2     75  76  79  

79  2     78  76  80  

80  2     79  76  77  

RADII: 
  0.301482   0.279505   0.167930   0.104521   0.089893 
  0.241230   0.234320   0.234564   0.104520   0.089893 
  0.301482   0.279510   0.167930   0.089318   0.066375 
  0.121706   0.066372   0.089315   0.063129   0.063129 
  0.478479   0.478478   0.057205   0.047294   0.060546 
  0.142992   0.239160   0.239160   0.470636   0.308330 
  0.223144   0.470636   0.308330   0.223144   0.186330 
  0.127833   0.127833   0.186330   0.127833   0.127833 
  0.171056   0.231602   0.293684   0.092580   0.136795 
  0.128497   0.325356   0.153644   0.160982   0.087092 
  0.222007   0.301029   0.476344   0.985325   0.801124 
  0.171056   0.231602   0.293684   0.092580   0.136795 
  0.128497   0.325356   0.153644   0.087092   0.222007 
  0.160982   0.476344   0.301029   0.801116   0.985325 
  0.227265   0.185584   0.227263   0.185584   0.228480 
  0.279148   0.228480   0.274722   0.159697   0.274722 


CENTERS:
  -0.248688  -0.254963    -0.251134  0.011671    -0.188164  0.211396  
  -0.119720  -0.117600    -0.109079  0.118011    -0.000017  -0.233393  
  0.000000  0.000000    0.000000  0.230238    0.119719  -0.117600  
  0.109079  0.118011    0.248739  -0.254769    0.251137  0.011670  
  0.188163  0.211397    -0.126021  0.310024    -0.069391  0.348796  
  -0.000015  0.390658    0.069386  0.348805    0.126019  0.310023  
  0.192695  0.314519    -0.192698  0.314518    0.189276  0.525791  
  -0.189284  0.525790    -0.000050  0.463722    -0.000061  0.503730  
  -0.000071  0.542867    -0.000090  0.610665    -0.061221  0.700069  
  0.060986  0.700104    -0.199134  0.772107    -0.330539  0.689044  
  -0.392819  0.582515    0.198848  0.772210    0.330293  0.689290  
  0.392690  0.582910    -0.402433  0.467439    -0.348727  0.375335  
  -0.273475  0.309045    0.402524  0.467944    0.349097  0.375782  
  0.273472  0.309048    0.337662  0.194757    0.459985  0.084030  
  0.458976  -0.122614    0.442948  0.208355    0.525554  0.202388  
  0.579330  0.132202    0.633906  0.000702    0.616594  0.210123  
  0.664991  0.136628    0.567073  0.261694    0.638340  0.308828  
  0.727742  0.227810    0.799212  0.092389    0.809247  0.400845  
  0.880968  0.237013    -0.337663  0.194753    -0.459983  0.084022  
  -0.458965  -0.122623    -0.442949  0.208348    -0.525556  0.202379  
  -0.579330  0.132191    -0.633902  0.000687    -0.616596  0.210112  
  -0.567076  0.261684    -0.638345  0.308816    -0.664991  0.136633  
  -0.799226  0.092456    -0.727720  0.227852    -0.880944  0.237097  
  -0.809184  0.400929    0.093586  -0.418761    0.250992  -0.451540  
  -0.093431  -0.418836    -0.250813  -0.451664    0.167616  -0.568671  
  0.000113  -0.581877    -0.167394  -0.568758    0.108751  -0.700542  
  0.000144  -0.708775    -0.108467  -0.700593  

END

misc.p
NODECOUNT:   103

ALPHA/BETA/GAMMA:   30  103  1

GEOMETRY:   hyperbolic

FLOWERS: 

1  8     89  92  25  27  6  4  2  65  64  

2  6     1  4  7  5  3  65  1  

3  6     62  65  2  5  8  88  62  

4  4     1  6  7  2  1  

5  4     2  7  8  3  2  

6  8     11  9  7  4  1  27  29  31  11  

7  8     4  6  9  12  10  8  5  2  4  

8  6     86  88  3  5  7  10  13  

9  4     6  11  12  7  6  

10  4     7  12  13  8  7  

11  8     16  14  12  9  6  31  33  35  16  

12  8     13  10  7  9  11  14  17  15  13  

13  4     8  10  12  15  18  

14  4     11  16  17  12  11  

15  4     12  17  18  13  12  

16  8     21  19  17  14  11  35  37  39  21  

17  8     14  16  19  22  20  18  15  12  14  

18  4     13  15  17  20  23  

19  4     16  21  22  17  16  

20  4     17  22  23  18  17  

21  7     22  19  16  39  41  40  103  22  

22  6     23  20  17  19  21  103  102  

23  2     18  20  22  

24  5     56  52  28  26  25  56  

25  7     56  24  26  29  27  1  92  56  

26  4     24  28  29  25  24  

27  4     25  29  6  1  25  

28  7     32  30  29  26  24  52  48  32  

29  8     26  28  30  33  31  6  27  25  26  

30  4     28  32  33  29  28  

31  4     29  33  11  6  29  

32  7     36  34  33  30  28  48  45  36  

33  8     11  31  29  30  32  34  37  35  11  

34  4     32  36  37  33  32  

35  4     33  37  16  11  33  

36  7     40  38  37  34  32  45  43  40  

37  8     34  36  38  41  39  16  35  33  34  

38  4     36  40  41  37  36  

39  4     37  41  21  16  37  

40  9     21  41  38  36  43  42  100  99  103  21  

41  5     21  39  37  38  40  21  

42  6     40  43  44  73  72  100  40  

43  6     36  45  46  44  42  40  36  

44  7     42  43  46  47  51  61  73  42  

45  6     32  48  49  46  43  36  32  

46  6     45  49  50  47  44  43  45  

47  4     44  46  50  51  44  

48  6     28  52  53  49  45  32  28  

49  6     48  53  54  50  46  45  48  

50  6     49  54  55  51  47  46  49  

51  5     44  47  50  55  61  44  

52  6     53  48  28  24  56  57  53  

53  6     54  49  48  52  57  58  54  

54  6     55  50  49  53  58  59  55  

55  6     51  50  54  59  60  61  51  

56  7     57  52  24  25  92  91  96  57  

57  5     58  53  52  56  96  95  

58  3     59  54  53  57  

59  3     60  55  54  58  

60  2     61  55  59  

61  5     70  73  44  51  55  60  

62  8     78  81  66  69  63  65  3  88  78  

63  4     64  65  62  69  64  

64  4     1  65  63  69  68  

65  6     1  2  3  62  63  64  1  

66  6     74  77  67  69  62  81  74  

67  4     68  69  66  77  68  

68  4     64  69  67  77  76  

69  6     64  63  62  66  67  68  64  

70  2     71  73  61  

71  2     72  73  70  

72  4     97  100  42  73  71  

73  6     42  44  61  70  71  72  42  

74  6     75  77  66  81  80  85  75  

75  4     76  77  74  85  84  

76  2     68  77  75  

77  6     68  67  66  74  75  76  68  

78  4     79  81  62  88  87  

79  2     80  81  78  

80  4     82  85  74  81  79  

81  6     74  66  62  78  79  80  74  

82  2     83  85  80  

83  2     84  85  82  

84  2     75  85  83  

85  6     75  74  80  82  83  84  75  

86  2     87  88  8  

87  2     78  88  86  

88  6     78  62  3  8  86  87  78  

89  2     90  92  1  

90  2     91  92  89  

91  4     93  96  56  92  90  

92  6     56  25  1  89  90  91  56  

93  2     94  96  91  

94  2     95  96  93  

95  2     57  96  94  

96  6     57  56  91  93  94  95  57  

97  2     98  100  72  

98  2     99  100  97  

99  4     101  103  40  100  98  

100  6     40  42  72  97  98  99  40  

101  2     102  103  99  

102  2     22  103  101  

103  6     22  21  40  99  101  102  22  

RADII: 
  0.314711   0.127095   0.151457   0.073029   0.070249 
  0.169500   0.174389   0.287682   0.067356   0.083846 
  0.146651   0.172321   0.223144   0.062822   0.078628 
  0.133170   0.167393   0.223144   0.061153   0.080206 
  0.133539   0.169872   0.248461   0.089928   0.164671 
  0.052617   0.075080   0.132278   0.145414   0.056065 
  0.060549   0.136458   0.133561   0.053786   0.053838 
  0.142607   0.114525   0.048002   0.042257   0.244486 
  0.060339   0.188534   0.167932   0.215143   0.144840 
  0.134535   0.061750   0.151573   0.158575   0.143710 
  0.131033   0.167905   0.201739   0.219250   0.278500 
  0.221194   0.356675   0.287682   0.430783   0.798508 
  0.798508   0.212765   0.062756   0.171886   0.146692 
  0.124813   0.053935   0.171886   0.111298   0.171886 
  0.171886   0.171886   0.210701   0.157112   0.171886 
  0.171886   0.128769   0.171886   0.171886   0.223144 
  0.167874   0.171886   0.171886   0.171886   0.171263 
  0.171886   0.287682   0.195925   0.171886   0.171886 
  0.171886   0.187804   0.171886   0.171886   0.171886 
  0.193008   0.171886   0.171886   0.171886   0.178779 
  0.171886   0.171886   0.168453 

CENTERS:
  0.384979  0.000000    0.384904  -0.185819    0.461894  -0.260279  
  0.307490  -0.150384    0.378603  -0.264810    0.200567  -0.119528  
  0.278557  -0.254357    0.387189  -0.397294    0.173876  -0.226868  
  0.253227  -0.359054    0.076155  -0.204444    0.149397  -0.331263  
  0.219956  -0.472454    0.048818  -0.298153    0.112026  -0.429419  
  -0.037164  -0.271627    0.016191  -0.393810    0.071517  -0.536122  
  -0.072545  -0.351491    -0.028821  -0.482920    -0.149709  -0.315037  
  -0.115612  -0.437681    -0.083550  -0.585732    0.087332  0.162861  
  0.198018  0.111151    0.094397  0.093740    0.207938  -0.002883  
  0.003033  0.093845    0.100321  -0.003995    0.000000  0.000000  
  0.090492  -0.105168    -0.095878  0.004099    -0.004739  -0.094411  
  -0.097197  -0.089892    -0.018215  -0.185202    -0.192423  -0.091888  
  -0.098263  -0.171746    -0.174956  -0.180441    -0.113804  -0.244174  
  -0.294395  -0.235622    -0.158467  -0.228062    -0.449778  -0.148832  
  -0.331870  -0.058447    -0.477707  0.005883    -0.227582  0.040612  
  -0.350508  0.073695    -0.427455  0.103265    -0.127738  0.141671  
  -0.268677  0.174807    -0.397794  0.180943    -0.494297  0.136036  
  -0.009769  0.238949    -0.167757  0.300381    -0.343257  0.315512  
  -0.518983  0.277073    0.163366  0.286251    -0.001856  0.466663  
  -0.245744  0.479640    -0.472668  0.487077    -0.725890  0.417095  
  -0.758541  0.107328    0.579819  -0.232024    0.559967  -0.146273  
  0.559839  -0.067074    0.486819  -0.154084    0.663549  -0.185033  
  0.661982  -0.137257    0.665449  -0.075438    0.614740  -0.139745  
  -0.693867  -0.113987    -0.651693  -0.193574    -0.554318  -0.222633  
  -0.584346  -0.102051    0.728575  -0.201639    0.772019  -0.150914  
  0.749206  -0.084674    0.708532  -0.139868    0.632684  -0.324234  
  0.708809  -0.323891    0.758776  -0.269470    0.679660  -0.256404  
  0.817502  -0.252993    0.839589  -0.214232    0.826084  -0.169912  
  0.790256  -0.209443    0.517410  -0.449584    0.625514  -0.430112  
  0.535278  -0.347459    0.466290  0.178847    0.431315  0.301209  
  0.313230  0.354222    0.324636  0.207650    0.337908  0.475370  
  0.268784  0.560785    0.159831  0.568137    0.211069  0.450307  
  -0.558560  -0.328081    -0.483547  -0.398059    -0.370737  -0.381303  
  -0.453281  -0.286096    -0.324459  -0.490213    -0.212429  -0.519447  
  -0.243814  -0.398243  

END







