/* eucl_math.c    euclidean geometry utility routines 
Ken Stephenson, 8/91 */

/* cc eucl_math.c -o eucl_math.o -c -g -lm */

#include <math.h>
#include "complex_math.h"
#include "eucl_math.h"

float
e_area(r1,r2,r3) /* return area given radii */
float r1,r2,r3;
{
	float s;
	
	s=(r1+r2+r3);
	return (sqrt(s*(s-r1-r2)*(s-r1-r3)*(s-r2-r3)));
} /* e_area */

int
e_compcenter(z1,z2,z3,e1,e2,e3,o1,o2,o3) /* given centers/radii 
of circles 1 and 2 and rad of 3, and cosines oj opposite zj, 
find eucl center of 3. (e3 is ptr only for compat reasons.) */ 
complex z1,z2,*z3;
float e1,e2,*e3,o1,o2,o3;
{
	float l1,l2,l3,s,cosang;
	complex v,w;
	extern float cAbs();
	
	l3=e1*e1+e2*e2+2*e1*e2*o3;
	l2=e1*e1+(*e3)*(*e3)+2*e1*(*e3)*o2;
	l1=e2*e2+(*e3)*(*e3)+2*e2*(*e3)*o1;
	cosang=(l2+l3-l1)/(2*sqrt(l2*l3));
	v.re=sqrt(l2)*cosang;
	v.im=sqrt(l2-v.re*v.re);
	w.re=z2.re-z1.re;
	w.im=z2.im-z1.im;
	s=cAbs(w);
	w.re = w.re/s; w.im = w.im/s;
	z3->re=z1.re+w.re*v.re-w.im*v.im;
	z3->im=z1.im+w.re*v.im+w.im*v.re;
	return;
} /* e_compcenter */
	
float
e_cos_overlap(e1,e2,e3,t1,t2,t3,flag) /* given three eucl radii, 
cos's of opp overlap angles, return cos of angle at e1. If radii and
overlaps incompatible, return value (for 0 or Pi, depending) and
set flag. Note: tj <= 1 for overlap, tj > 1 for inv distance. */
float e1,e2,e3,t1,t2,t3;
int *flag;
{
	float l1,l2,l3,sqrlen;

	l3=e1*e1+e2*e2+2*e1*e2*t3; 
	l2=e1*e1+e3*e3+2*e1*e3*t2;
	l1=e2*e2+e3*e3+2*e2*e3*t1;
	sqrlen=(l2+l3-l1)/(2*sqrt(l2*l3));
	if (sqrlen < -1.000001){(*flag)++; return -1.0;} /* error? */
	if (sqrlen < -1.0) return -1.0; /* roundoff error? */
	if (sqrlen > 1.000001){(*flag)++; return 1.0;} /* error? */ 
	if (sqrlen > 1.0) return 1.0; /* roundoff error? */
	return sqrlen;
} /* e_cos_overlap */

float
Fx(x,y,z) /* deriv in eucl setting for angle at x w.r.t radius x.*/
float x,y,z;
{
	float a,b;

	a=x*(x+y+z); b=y*z;
	return ( (-b)*(2*x+y+z)/((a+b)*sqrt(a*b)) );
}	 
	
float
Fy(x,y,z) /* deriv in eucl setting for angle at x w.r.t radius y.*/
float x,y,z;
{
	float a,b;

	a=x*(x+y+z); b=y*z;
	return (x*y*(x+y)/((a+b)*sqrt(a*b)));
}

float
Fz(x,y,z) /* deriv in eucl setting for angle at x w.r.t radius y.*/
float x,y,z;
{
	return (Fy(x,z,y));
}	 
	
