/*
 * YS/ys_dbg.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  ys_dbg.hpp  --  meine (H. Sbosny) Debugmakros 
 
   TRACE()   -  
   SPUR()    - 
   DBG       - general debug info: file, line number, function
   CTOR()    - constructor call
   DTOR()    - destructor call
   WINCALL() - call of a window callback (FLTK)
 
  Einzuschalten durch `#define YS_DEBUG', auszuschalten durch 
  `#undef YS_DEBUG'.
 
  Diese Datei soll mehrfach eingelesen werden koennen, um die Makros
  fuer jede Quelldatei neu definieren (an- und abschalten) zu koennen, 
  daher hier kein `ys_dbg_h'-Schalter. Damit die Umdefinitionen keine 
  "redefine"-Warnungen produzieren, werden die Makros zuerst immer
  entdefiniert.
*/
// #ifndef ys_dbg_hpp	 // No! We want allow multiple including!
// #define ys_dbg_hpp


/// (currently) unswitchable Macros...

#define CTOR(s)    printf("Ctor %s(\"%s\")...\n",__func__, s);
#define DTOR(s)    printf("Dtor %s(\"%s\")...\n",__func__, s);
#define WINCALL(s) printf("window callback(\"%s\") called...\n", s);
// Fuer auf die Schnelle
#define DB_        printf("[%s, Line %d]: %s()...\n",__FILE__,__LINE__,__func__);


/// switchable Macros... 

// undefine macros to avoid "redefine" warnings
#ifdef TRACE
  #undef TRACE
#endif

#ifdef SPUR
  #undef SPUR
#endif

#ifdef DBG
  #undef DBG
#endif

#ifdef DBG_CALL
  #undef DBG_CALL
#endif

#ifdef YS_DEBUG  
   void ynsobs_dbg (const char *fmt, ...);     // in "ys_dbg.cpp"

  #define TRACE(args)    printf ("%s(): ",__func__); ynsobs_dbg args ;
  #define SPUR(args)     ynsobs_dbg args ;
  #define DBG            printf("[%s, Line %d]:  %s()...\n",__FILE__,__LINE__,__func__);
  #define DBG_CALL(arg)	arg;	

#else
  // nichts...
  #define TRACE(args)     
  #define SPUR(args)      
  #define DBG    
  #define DBG_CALL(arg)

#endif  // YS_DEBUG

// #endif  // ys_dbg_hpp

// END OF FILE
