# -*- coding: utf-8 -*-

# Copyright (c) 2006 Stas Zykiewicz <stas.zytkiewicz@gmail.com>
#
#           splash.py
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.  A copy of this license should
# be included in the file GPL-2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.



import pygame,os,sys
pygame.init()
scr = pygame.display.set_mode((800,600))

from threading import Thread
from utils import trace_error,load_image,load_music
from CPConstants import DATADIR

def splash():
    """Display a splash screen at startup.
      This runs in a seperate thread at the timeout"""
    
    T = 5000
    try:
        snd = load_music(os.path.join(DATADIR,'cows.ogg'))
        snd.play(-1)
    except pygame.error,info:
        print >> sys.stderr,info
    try:
##        cow = load_image(os.path.join(DATADIR,'cowsplash.png'))
##        load = load_image(os.path.join(DATADIR,'cowsplash-load.png'))
##        pygame.display.update((scr.blit(cow,(300,100)),scr.blit(load,(40,20))))
        cow = load_image(os.path.join(DATADIR,'loading_splash.jpg'))
        pygame.display.update(scr.blit(cow,(0,0)))
    except (Exception,pygame.error),info:
        try:
            snd.stop()
        except:
            pass
        trace_error()
        T = 1
    # Keep it alive
    pygame.time.wait(T)
    try:
        snd.stop()
    except:
        pass
 
thread = Thread(target=splash)
thread.start()

pygame.time.wait(1)
