import random
import string
from base import *
from util import *

DIR = "common_pathinfo_2"

CONF = """
vserver!default!rule!1500!match = directory
vserver!default!rule!1500!match!directory = <dir>
vserver!default!rule!1500!handler = common
vserver!default!rule!1500!handler!allow_pathinfo = 0
"""

class Test (TestBase):
    def __init__ (self):
        TestBase.__init__ (self)
        self.name = "Handler common: No PathInfo"

        self.request           = "GET /%s/file/path/info HTTP/1.0\r\n" % (DIR)
        self.expected_error    = 404

    def Prepare (self, www):
        test_dir = self.Mkdir (www, DIR)
        self.conf = CONF.replace('<dir>', '/'+DIR)

        self.WriteFile (test_dir, "file", 0444)
