/***************************************************************************
                          interface.cpp  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"


const char * Interface::key_names[KEY_MAX_KEYS]  ={

        "Note Off",
        "Note Cut",
        "Play Note",
        "Play Row",
        "Next Instr.",
        "Prev Instr.",
        "Clear Field",
        "Toggle Mask",
        "Repeat Field",
        "Base C-1",
        "Base C#1",
        "Base D-1",
        "Base D#1",
        "Base E-1",
        "Base F-1",
        "Base F#1",
        "Base G-1",
        "Base G#1",
        "Base A-1",
        "Base A#1",
        "Base B-1",
        "Base C-2",
        "Base C#2",
        "Base D-2",
        "Base D#2",
        "Base E-2",
        "Base F-2",
        "Base F#2",
        "Base G-2",
        "Base G#2",
        "Base A-2",
        "Base A#2",
        "Base B-2",
        "Base C-3",
        "Base C#3",
        "Base D-3",
        "Base D#3",
        "Base E-3",
        "Base F-3",
        "Base F#3",
        "Base G-3"
};


Interface::Interface()  : Gtk::Window(GTK_WINDOW_TOPLEVEL),button_instrument_options("Edit"), label10("Song Name"), label11("   File Name"), label13("        Pattern"), label14("            Row"), label12("        Order"), table1(5, 2, false), label15("     Instrument "), label16("Speed/Tempo "), label17("         Octave "), table2(3, 2, false), button_main_play_prev_pattern(), button_main_stop(), button_main_play(), button_main_play_next_pattern(), button_main_play_pattern(), button_main_play_custom(), button_main_help(), label1("Pattern Editor"), clist_samples_list(3), frame1("Samples"), label34("Volume/Pan "), label20(" Default Volume "), label21(" Global Volume "), checkbutton_samples_def_pan("Default Pan"), label35("Vibrato "), label22(" Vibrato Speed "), label23(" Vibrato Depth"), label36(" Vibrato Rate"), table4(2, 2, false), frame8("Vibrato Waveform"), label24(" FileName "), label25("Fine/B.Note"), label27("      Begin"), label28("         End"), label30("       Begin"), label31("         End"), label32("     Quality"), label33("      Length"), label38("       Loop"), label39("Sust. Loop "), table3(13, 2, false), button_samples_edit("Edit"), button_samples_play("Play"), label2("Sample List"), clist_instrments_names(2), frame9("Instruments"), frame10("Equiv Table:     "), label50("New Note Action:"), label51("Dup. Check Type &amp; Action"), table5(4, 2, false), label52("Filename  "), label46("General"), frame19("Volume Envelope"), checkbutton_instruments_volume_envelope("Volume Envelope"), checkbutton_instruments_volume_envelope_carry("Carry"), checkbutton_instruments_volume_envelope_loop("Envelope Loop"), label23423("Loop Begin "), hbox31(true, 0), label234234("Loop End "), hbox32(true, 0), checkbutton_instruments_volume_envelope_susloop("Sustain Loop"), label7("SusLoop Begin"), hbox33(true, 0), label74("SusLoop End"), hbox34(true, 0), frame20("Envelope Options"), spinbutton_instruments_volume_global("  Global Volume "), label76("           Fadeout"), label77("Volume Swing %"), table8(3, 2, false), frame21("Misc"), label47("Volume"), frame14("Panning Envelope"), checkbutton_instruments_pan_envelope("Panning Envelope"), checkbutton_instruments_pan_envelope_carry("Carry"), checkbutton_instruments_pan_envelope_loop("Envelope Loop"), label60("Loop Begin "), hbox24(true, 0), label61("Loop End "), hbox25(true, 0), checkbutton_instruments_pan_envelope_susloop("Sustain Loop"), label62("SusLoop Begin"), hbox26(true, 0), label63("SusLoop End"), hbox27(true, 0), frame15("Envelope Options"), label82("             Pan Value "), checkbutton_instruments_pan_default("Default Pan"), label83(" Ptch/Pan Cntr"), label84("          Pitch/Pan Sep."), label85("      Pan Swing %"), table10(5, 2, false), frame23("Misc"), label48("Panning"), frame24("Frequency Envelope"), label94("Frequency Envelope  "), checkbutton_instruments_pitch_envelope("Pitch Envelope"),  checkbutton_instruments_pitch_envelope_filter("Use as filter"), checkbutton_instruments_frequency_envelope_carry("Carry"), checkbutton_instruments_frequency_envelope_loop("Envelope Loop"), label86("Loop Begin "), hbox38(true, 0), label87("Loop End "), hbox39(true, 0), checkbutton_instruments_frequency_envelope_susloop("Sustain Loop"), label88("SusLoop Begin"), hbox40(true, 0), label89("SusLoop End"), hbox41(true, 0), frame25("Envelope Options"), label90("             Pan Value "), checkbutton25("Default Pan"), label91(" Ptch/Pan Cntr"), label92("              Fadeout"), label93("   Volume Swing %"), table11(5, 2, false), frame26("Misc"), label49("Pitch/Filter"), label3("Instrument List"), label4("Info Page"), frame27("Order List:  "), label5("OrderList & Ch.Defaults"), label98("Initial Tempo  "), hbox46(true, 0), label99("initial Speed  "), hbox47(true, 0), frame28("Song Speed"), label100("Global Volume "), hbox48(true, 0), label101("Mixing Volume "), hbox49(true, 0), label102("Separation       "), hbox50(true, 0), checkbutton_variables_old_effects("Old Effects"), checkbutton_variables_compat_gxx("Compatible GXX"), frame29("Global Modifiers"), label103("Control:     "), hbox52(true, 0), label104("Playback:  "), hbox53(true, 0), label105("Slides:       "), hbox54(true, 0), frame30("Backwards Compatibility"), frame31("Message"), label18("Song Variables"), label19("Config"),clist_config_sound_driver_name(1), checkbutton_config_16bits("16 Bits"), checkbutton_config_stereo("Stereo"), label234243("Frequency:"), button_config_sound_restart("Restart"), button_config_sound_config("Config"), label234244("Status:"), table15(6, 4, false), frame37("Sound Driver:"), clist_config_mixer_proc(1), label234246("Virtual Channels:"), checkbutton_config_enable_filters("Enable Filters"), table16(2, 2, false), frame38("Software Mixer"), frame36("Sound Options"), label234247("Widget update/repaint frequency:  "), button_config_save("Save Config"), button_config_adjust_colors("Change"), clist_config_keyboard_type(2), table17(3, 6, false), frame39("Interface Otions"), labelbuffsize("Buffer Size:"),checkbutton_instruments_use_default_cutoff("Default cutoff:"),checkbutton_instruments_use_default_Q("Default Q:"), checkbutton_config_reverb_enabled("Enable reverb"), revset("R\ne\nv\ne\nr\nb\n")  {

	orderlist_ord_pan.set_events(GDK_KEY_PRESS_MASK|GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_VISIBILITY_NOTIFY_MASK|GDK_EXPOSURE_MASK);
	equivtable_instruments.set_events(GDK_KEY_PRESS_MASK|GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_VISIBILITY_NOTIFY|GDK_EXPOSE);
//	tracker.set_events(GDK_KEY_PRESS_MASK|GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_VISIBILITY_NOTIFY_MASK|GDK_EXPOSE_MASK);
//	tracker.add_events(GDK_ALL_EVENTS_MASK);
	tracker.add_events(GDK_BUTTON_PRESS_MASK);
	envelope_instruments_volume.set_events(GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_ENTER_NOTIFY_MASK|GDK_LEAVE_NOTIFY_MASK|GDK_KEY_PRESS_MASK);
        envelope_instruments_pan.set_events(GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_ENTER_NOTIFY_MASK|GDK_LEAVE_NOTIFY_MASK|GDK_KEY_PRESS_MASK);
        envelope_instruments_frequency.set_events(GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_ENTER_NOTIFY_MASK|GDK_LEAVE_NOTIFY_MASK|GDK_KEY_PRESS_MASK);

	initialize_widgets();
	fontname="-adobe-courier-bold-r-normal--*-120-*-*-*-*-*-*";
	set_fonts();
	// Initialize the samples clist

	{
		gchar *empty_strings[3]={"","",""};
		char row_num[3];
		int i;

		clist_samples_list.freeze();
		clist_samples_list.clear();
		row_num[2]=0;

		for (i=0;i<MAX_SAMPLES;i++) {

			clist_samples_list.append(empty_strings);
			row_num[0]='0'+(i+1)/10;
			row_num[1]='0'+(i+1) % 10;
        		clist_samples_list.set_text(i,0,row_num);
			clist_samples_list.set_column_justification(2,GTK_JUSTIFY_LEFT);
		}
		clist_samples_list.thaw();
	}

	// Initialize the instruments clist

	{
		gchar *empty_strings[2]={"",""};
		char row_num[3];
		int i;

		clist_instrments_names.freeze();
		clist_instrments_names.clear();
		row_num[2]=0;

		for (i=0;i<MAX_SAMPLES;i++) {

			clist_instrments_names.append(empty_strings);
			row_num[0]='0'+(i+1)/10;
			row_num[1]='0'+(i+1) % 10;

        		clist_instrments_names.set_text(i,0,row_num);
		}
		clist_instrments_names.thaw();
	}
        //Initialize misc variables
	selected_sample=0;
	selected_instrument=0;
	previous_shift=false;
	player=NULL;
	song=NULL;
	update_counter=0;
	clipboard_sample_index=-1;
 	selected_key=-1;
	selected_sample_updating_in_progress=false;
	selected_instrument_updating_in_progress=false;
	variables_page_updating_in_progress=false;
	orderpan_page_updating_in_progress=false;
	config_page_updating_in_progress=false;
        main_entries_updating_in_progress=false;
	song_follow_mode=false;

        current_page=PATTERN_EDITOR_PAGE;
	update_freq_counter=0;
	widgets_update_freq=1;
	quit_request=false;
	tracker.grab_focus();


 	editor.set_note_increment_table(&key_assign[KEY_NOTE_O1_C]);
 	
      	key_assign[KEY_NOTEOFF]='`';
      	key_assign[KEY_NOTECUT]='1';
 	key_assign[KEY_PLAY_NOTE]='4';
  	key_assign[KEY_PLAY_ROW]='8';
   	key_assign[KEY_NEXT_INSTRUMENT]='>';
   	key_assign[KEY_PREV_INSTRUMENT]='<';
        key_assign[KEY_ERASE_FIELD]='.';
        key_assign[KEY_TOGGLE_MASK]=',';
        key_assign[KEY_REPEAT_LAST_FIELD]=' ';
        key_assign[KEY_NOTE_O1_C]='Z';
        key_assign[KEY_NOTE_O1_Cs]='S';
        key_assign[KEY_NOTE_O1_D]='X';
        key_assign[KEY_NOTE_O1_Ds]='D';
        key_assign[KEY_NOTE_O1_E]='C';
        key_assign[KEY_NOTE_O1_F]='V';
        key_assign[KEY_NOTE_O1_Fs]='G';
        key_assign[KEY_NOTE_O1_G]='B';
        key_assign[KEY_NOTE_O1_Gs]='H';
        key_assign[KEY_NOTE_O1_A]='N';
        key_assign[KEY_NOTE_O1_As]='J';
	key_assign[KEY_NOTE_O1_B]='M';
        key_assign[KEY_NOTE_O2_C]='Q';
        key_assign[KEY_NOTE_O2_Cs]='2';
        key_assign[KEY_NOTE_O2_D]='W';
        key_assign[KEY_NOTE_O2_Ds]='3';
        key_assign[KEY_NOTE_O2_E]='E';
        key_assign[KEY_NOTE_O2_F]='R';
        key_assign[KEY_NOTE_O2_Fs]='5';
        key_assign[KEY_NOTE_O2_G]='T';
        key_assign[KEY_NOTE_O2_Gs]='6';
        key_assign[KEY_NOTE_O2_A]='Y';
        key_assign[KEY_NOTE_O2_As]='7';
        key_assign[KEY_NOTE_O2_B]='U';
        key_assign[KEY_NOTE_O3_C]='I';
        key_assign[KEY_NOTE_O3_Cs]='9';
        key_assign[KEY_NOTE_O3_D]='O';
        key_assign[KEY_NOTE_O3_Ds]='0';
        key_assign[KEY_NOTE_O3_E]='P';
        key_assign[KEY_NOTE_O3_F]='[';
        key_assign[KEY_NOTE_O3_Fs]='=';
        key_assign[KEY_NOTE_O3_G]=']';

        reverb.room=109;
        reverb.damp=127;
        reverb.wet=70;
        reverb.dry=90;
        reverb.width=120;

}

Interface::~Interface(){

        destroy_widgets();
	
}

bool Interface::has_key(int p_key) {

  	for (int i=0;i<KEY_MAX_KEYS;i++) {

     		if (key_assign[i]==p_key) return true;
        }

        return false;
}

int Interface::get_key_pos(int p_key) {

  	for (int i=0;i<KEY_MAX_KEYS;i++) {

     		if (key_assign[i]==p_key) return i;
        }

        return -1;
}

bool Interface::is_key(Key_Names p_key,int p_rkey) {

	return (key_assign[p_key]==p_rkey);

}

bool Interface::is_note(int p_key) {

  	for (int i=KEY_NOTE_O1_C;i<KEY_NOTE_O3_G;i++) {

     		if (key_assign[i]==p_key) return true;
       }

       return false;
}

void Interface::run_song_load_menu() {

	string filename;
      	bool load_ok=false;
      	int tmp_error;

	realtime_keyboard.instrument_stop_all();
	realtime_keyboard.sample_stop_all();

      	player->play_stop();				

      	file_select_popup= new File_Access_Widget;
      	file_select_popup->set_mode(File_Access_Widget::LOAD);					
        if (song_path!="") file_select_popup->set_filename(song_path);
	file_select_popup->make_default.connect(SigC::bind<string>(slot(this,&Interface::set_some_default_path),"song"));

      	do {

      		file_select_popup->poll_until_action(*kit);

      		if (file_select_popup->get_action()!=File_Access_Widget::CANCEL) {

	      		filename=file_select_popup->get_filename();

			variables_lock->grab();

	     		tmp_error=file_manager->load_module((char*)filename.c_str());

			variables_lock->release();

      			if (tmp_error) {

      				accept_dialog = new Dialog_Accept(Loader::error_string[tmp_error],*kit);
      				delete accept_dialog;
      			} else {
                                update_all_widgets();
      				load_ok=true;
      			}
      		}

      	} while (!load_ok && (file_select_popup->get_action()!=File_Access_Widget::CANCEL));

      	delete file_select_popup;
}

void Interface::run_song_save_menu() {

	string filename;
      	bool save_ok=false;
      	int tmp_error;

	realtime_keyboard.instrument_stop_all();
	realtime_keyboard.sample_stop_all();

      	player->play_stop();				

      	file_select_popup= new File_Access_Widget;     	
      	file_select_popup->set_mode(File_Access_Widget::SAVE);					
        if (song_path!="") file_select_popup->set_filename(song_path);
	file_select_popup->make_default.connect(SigC::bind<string>(slot(this,&Interface::set_some_default_path),"song"));

      	do {

      		file_select_popup->poll_until_action(*kit);
      		filename=file_select_popup->get_filename();

		variables_lock->grab();

      		tmp_error=file_manager->save_module((char*)filename.c_str());

		variables_lock->release();

      		if (file_select_popup->get_action()!=File_Access_Widget::CANCEL) {

      			if (tmp_error==Saver::SAVE_ERROR) {

      				accept_dialog = new Dialog_Accept("Error opening file for writing",*kit);
      				delete accept_dialog;
      			
      			} else if (tmp_error==Saver::UNKNOWN_TYPE) {
      			
      				accept_dialog = new Dialog_Accept("Unknown file format (check extension?)",*kit);      			
      				delete accept_dialog;      				
      			
      			} else {
      			
                                update_all_widgets();
      				save_ok=true;			
      			}
      		}

      	} while (!save_ok && (file_select_popup->get_action()!=File_Access_Widget::CANCEL));

      	delete file_select_popup;



}

