header {
package com.puppycrawl.tools.checkstyle.grammars;
}
class GeneratedJava14Recognizer extends Parser;

options {
	k= 2;
	exportVocab=GeneratedJava14;
	codeGenMakeSwitchThreshold= 2;
	codeGenBitsetTestThreshold= 3;
	defaultErrorHandler= false;
	buildAST= true;
	importVocab=GeneratedJava;
}

statement :traditionalStatement
	|	assertStatement
	;

assertStatement :ASSERT^ expression ( COLON expression )? SEMI
	;

// inherited from grammar GeneratedJavaRecognizer
compilationUnit :// A compilation unit starts with an optional package definition
		(	packageDefinition
		|	/* nothing */
		)

		// Next we have a series of zero or more import statements
		( importDefinition )*

		// Wrapping things up with any number of class or interface
		//    definitions
		( typeDefinition )*

		EOF!
	;

// inherited from grammar GeneratedJavaRecognizer
packageDefinition 
options {
	defaultErrorHandler= true;
}
:p:"package"^ {#p.setType(PACKAGE_DEF);} identifier SEMI
	;

// inherited from grammar GeneratedJavaRecognizer
importDefinition 
options {
	defaultErrorHandler= true;
}
:i:"import"^ {#i.setType(IMPORT);} identifierStar SEMI
	;

// inherited from grammar GeneratedJavaRecognizer
typeDefinition 
options {
	defaultErrorHandler= true;
}
:m:modifiers!
		( classDefinition[#m]
		| interfaceDefinition[#m]
		)
	|	SEMI
	;

// inherited from grammar GeneratedJavaRecognizer
declaration! :m:modifiers t:typeSpec[false] v:variableDefinitions[#m,#t]
		{#declaration = #v;}
	;

// inherited from grammar GeneratedJavaRecognizer
typeSpec[boolean addImagNode] :classTypeSpec[addImagNode]
	| builtInTypeSpec[addImagNode]
	;

// inherited from grammar GeneratedJavaRecognizer
classTypeSpec[boolean addImagNode] :identifier (lb:LBRACK^ {#lb.setType(ARRAY_DECLARATOR);} RBRACK!)*
		{
			if ( addImagNode ) {
				#classTypeSpec = #(#[TYPE,"TYPE"], #classTypeSpec);
			}
		}
	;

// inherited from grammar GeneratedJavaRecognizer
builtInTypeSpec[boolean addImagNode] :builtInType (lb:LBRACK^ {#lb.setType(ARRAY_DECLARATOR);} RBRACK!)*
		{
			if ( addImagNode ) {
				#builtInTypeSpec = #(#[TYPE,"TYPE"], #builtInTypeSpec);
			}
		}
	;

// inherited from grammar GeneratedJavaRecognizer
type :identifier
	|	builtInType
	;

// inherited from grammar GeneratedJavaRecognizer
builtInType :"void"
	|	"boolean"
	|	"byte"
	|	"char"
	|	"short"
	|	"int"
	|	"float"
	|	"long"
	|	"double"
	;

// inherited from grammar GeneratedJavaRecognizer
identifier :IDENT  ( DOT^ IDENT )*
	;

// inherited from grammar GeneratedJavaRecognizer
identifierStar :IDENT
		( DOT^ IDENT )*
		( DOT^ STAR  )?
	;

// inherited from grammar GeneratedJavaRecognizer
modifiers :( modifier )*
		{#modifiers = #([MODIFIERS, "MODIFIERS"], #modifiers);}
	;

// inherited from grammar GeneratedJavaRecognizer
modifier :"private"
	|	"public"
	|	"protected"
	|	"static"
	|	"transient"
	|	"final"
	|	"abstract"
	|	"native"
	|	"synchronized"
//	|	"const"			// reserved word, but not valid
	|	"volatile"
	|	"strictfp"
	;

// inherited from grammar GeneratedJavaRecognizer
classDefinition![AST modifiers] :c:"class" IDENT
		// it _might_ have a superclass...
		sc:superClassClause
		// it might implement some interfaces...
		ic:implementsClause
		// now parse the body of the class
		cb:classBlock
		{
                    #classDefinition = #(#[CLASS_DEF,"CLASS_DEF"],
                                         modifiers, c, IDENT, sc, ic, cb);
                }
	;

// inherited from grammar GeneratedJavaRecognizer
superClassClause! :( "extends" id:identifier )?
		{#superClassClause = #(#[EXTENDS_CLAUSE,"EXTENDS_CLAUSE"],id);}
	;

// inherited from grammar GeneratedJavaRecognizer
interfaceDefinition![AST modifiers] :i:"interface" IDENT
		// it might extend some other interfaces
		ie:interfaceExtends
		// now parse the body of the interface (looks like a class...)
		cb:classBlock
		{
                    #interfaceDefinition = #(#[INTERFACE_DEF,"INTERFACE_DEF"],
                                             modifiers, i, IDENT, ie, cb);
                }
	;

// inherited from grammar GeneratedJavaRecognizer
classBlock :LCURLY
			( field | SEMI )*
		RCURLY
		{#classBlock = #([OBJBLOCK, "OBJBLOCK"], #classBlock);}
	;

// inherited from grammar GeneratedJavaRecognizer
interfaceExtends :(
		e:"extends"!
		identifier ( COMMA identifier )*
		)?
		{#interfaceExtends = #(#[EXTENDS_CLAUSE,"EXTENDS_CLAUSE"],
							#interfaceExtends);}
	;

// inherited from grammar GeneratedJavaRecognizer
implementsClause :(
			i:"implements"! identifier ( COMMA identifier )*
		)?
		{#implementsClause = #(#[IMPLEMENTS_CLAUSE,"IMPLEMENTS_CLAUSE"],
								 #implementsClause);}
	;

// inherited from grammar GeneratedJavaRecognizer
field! :// method, constructor, or variable declaration
		mods:modifiers
		(	h:ctorHead s:constructorBody // constructor
			{#field = #(#[CTOR_DEF,"CTOR_DEF"], mods, h, s);}

		|	cd:classDefinition[#mods]       // inner class
			{#field = #cd;}

		|	id:interfaceDefinition[#mods]   // inner interface
			{#field = #id;}

		|	t:typeSpec[false]  // method or variable declaration(s)
			(	IDENT  // the name of the method

				// parse the formal parameter declarations.
				LPAREN param:parameterDeclarationList RPAREN

				rt:declaratorBrackets[#t]

				// get the list of exceptions that this method is
				// declared to throw
				(tc:throwsClause)?

				( s2:compoundStatement | s5:SEMI )
				{#field = #(#[METHOD_DEF,"METHOD_DEF"],
						     mods,
							 #(#[TYPE,"TYPE"],rt),
							 IDENT,
							 LPAREN,
							 param,
							 RPAREN,
							 tc,
							 s2,
                             s5);}
			|	v:variableDefinitions[#mods,#t] s6:SEMI
//				{#field = #(#[VARIABLE_DEF,"VARIABLE_DEF"], v);}
				{
                                    #field = #v;
                                    #v.addChild(#s6);
                                }
			)
		)

    // "static { ... }" class initializer
	|	si:"static" s3:compoundStatement
		{#si.setType(STATIC_INIT);
		 #si.setText("STATIC_INIT");
		 #field = #(#si, s3);}

    // "{ ... }" instance initializer
	|	s4:compoundStatement
		{#field = #(#[INSTANCE_INIT,"INSTANCE_INIT"], s4);}
	;

// inherited from grammar GeneratedJavaRecognizer
constructorBody :lc:LCURLY^ {#lc.setType(SLIST);}
		// Predicate might be slow but only checked once per constructor def
		// not for general methods.
		(	(explicitConstructorInvocation) => explicitConstructorInvocation
		|
		)
        (statement)*
        RCURLY
    ;

// inherited from grammar GeneratedJavaRecognizer
explicitConstructorInvocation :(	options {
				// this/super can begin a primaryExpression too; with finite
				// lookahead ANTLR will think the 3rd alternative conflicts
				// with 1, 2.  I am shutting off warning since ANTLR resolves
				// the nondeterminism by correctly matching alts 1 or 2 when
				// it sees this( or super(
				generateAmbigWarnings=false;
			}
		:	"this"! lp1:LPAREN^ argList RPAREN SEMI
			{#lp1.setType(CTOR_CALL);}

	    |   "super"! lp2:LPAREN^ argList RPAREN SEMI
			{#lp2.setType(SUPER_CTOR_CALL);}

			// (new Outer()).super()  (create enclosing instance)
		|	primaryExpression DOT! "super"! lp3:LPAREN^ argList RPAREN SEMI
			{#lp3.setType(SUPER_CTOR_CALL);}
		)
    ;

// inherited from grammar GeneratedJavaRecognizer
variableDefinitions[AST mods, AST t] :variableDeclarator[(AST) getASTFactory().dupTree(mods),
						   (AST) getASTFactory().dupTree(t)]
		(	COMMA
			variableDeclarator[(AST) getASTFactory().dupTree(mods),
							   (AST) getASTFactory().dupTree(t)]
		)*
	;

// inherited from grammar GeneratedJavaRecognizer
variableDeclarator![AST mods, AST t] :id:IDENT d:declaratorBrackets[t] v:varInitializer
		{#variableDeclarator = #(#[VARIABLE_DEF,"VARIABLE_DEF"], mods, #(#[TYPE,"TYPE"],d), id, v);}
	;

// inherited from grammar GeneratedJavaRecognizer
declaratorBrackets[AST typ] :{#declaratorBrackets=typ;}
		(lb:LBRACK^ {#lb.setType(ARRAY_DECLARATOR);} RBRACK!)*
	;

// inherited from grammar GeneratedJavaRecognizer
varInitializer :( ASSIGN^ initializer )?
	;

// inherited from grammar GeneratedJavaRecognizer
arrayInitializer :lc:LCURLY^ {#lc.setType(ARRAY_INIT);}
			(	initializer
				(
					// CONFLICT: does a COMMA after an initializer start a new
					//           initializer or start the option ',' at end?
					//           ANTLR generates proper code by matching
					//			 the comma as soon as possible.
					options {
						warnWhenFollowAmbig = false;
					}
				:
					COMMA initializer
				)*
				(COMMA)?
			)?
		RCURLY
	;

// inherited from grammar GeneratedJavaRecognizer
initializer :expression
	|	arrayInitializer
	;

// inherited from grammar GeneratedJavaRecognizer
ctorHead :IDENT  // the name of the method

		// parse the formal parameter declarations.
		LPAREN parameterDeclarationList RPAREN

		// get the list of exceptions that this method is declared to throw
		(throwsClause)?
	;

// inherited from grammar GeneratedJavaRecognizer
throwsClause :"throws"^ identifier ( COMMA identifier )*
	;

// inherited from grammar GeneratedJavaRecognizer
parameterDeclarationList :( parameterDeclaration ( COMMA parameterDeclaration )* )?
		{#parameterDeclarationList = #(#[PARAMETERS,"PARAMETERS"],
									#parameterDeclarationList);}
	;

// inherited from grammar GeneratedJavaRecognizer
parameterDeclaration! :pm:parameterModifier t:typeSpec[false] id:IDENT
		pd:declaratorBrackets[#t]
		{#parameterDeclaration = #(#[PARAMETER_DEF,"PARAMETER_DEF"],
									pm, #([TYPE,"TYPE"],pd), id);}
	;

// inherited from grammar GeneratedJavaRecognizer
parameterModifier :(f:"final")?
		{#parameterModifier = #(#[MODIFIERS,"MODIFIERS"], f);}
	;

// inherited from grammar GeneratedJavaRecognizer
compoundStatement :lc:LCURLY^ {#lc.setType(SLIST);}
			// include the (possibly-empty) list of statements
			(statement)*
		RCURLY
	;

// inherited from grammar GeneratedJavaRecognizer
traditionalStatement :compoundStatement

	// declarations are ambiguous with "ID DOT" relative to expression
	// statements.  Must backtrack to be sure.  Could use a semantic
	// predicate to test symbol table to see what the type was coming
	// up, but that's pretty hard without a symbol table ;)
	|	(declaration)=> declaration SEMI

	// An expression statement.  This could be a method call,
	// assignment statement, or any other expression evaluated for
	// side-effects.
	|	expression SEMI

	// class definition
	|	m:modifiers! classDefinition[#m]

	// Attach a label to the front of a statement
	|	IDENT c:COLON^ {#c.setType(LABELED_STAT);} statement

	// If-else statement
	|	"if"^ LPAREN expression RPAREN statement
		(
			// CONFLICT: the old "dangling-else" problem...
			//           ANTLR generates proper code matching
			//			 as soon as possible.  Hush warning.
			options {
				warnWhenFollowAmbig = false;
			}
		:
			elseStatement
		)?

	// For statement
	|	"for"^
			LPAREN
				forInit SEMI   // initializer
				forCond	SEMI   // condition test
				forIter         // updater
			RPAREN
			statement                     // statement to loop over

	// While statement
	|	"while"^ LPAREN expression RPAREN statement

	// do-while statement
	|	"do"^ statement "while"! LPAREN expression RPAREN SEMI

	// get out of a loop (or switch)
	|	"break"^ (IDENT)? SEMI

	// do next iteration of a loop
	|	"continue"^ (IDENT)? SEMI

	// Return an expression
	|	"return"^ (expression)? SEMI

	// switch/case statement
	|	"switch"^ LPAREN expression RPAREN LCURLY
			( casesGroup )*
		RCURLY

	// exception try-catch block
	|	tryBlock

	// throw an exception
	|	"throw"^ expression SEMI

	// synchronize a statement
	|	"synchronized"^ LPAREN expression RPAREN compoundStatement

	// empty statement
	|	s:SEMI {#s.setType(EMPTY_STAT);}
	;

// inherited from grammar GeneratedJavaRecognizer
elseStatement :"else"^ statement
    ;

// inherited from grammar GeneratedJavaRecognizer
casesGroup :(	// CONFLICT: to which case group do the statements bind?
			//           ANTLR generates proper code: it groups the
			//           many "case"/"default" labels together then
			//           follows them with the statements
			options {
				warnWhenFollowAmbig = false;
			}
			:
			aCase
		)+
		caseSList
		{#casesGroup = #([CASE_GROUP, "CASE_GROUP"], #casesGroup);}
	;

// inherited from grammar GeneratedJavaRecognizer
aCase :("case"^ expression | "default") COLON!
	;

// inherited from grammar GeneratedJavaRecognizer
caseSList :(statement)*
		{#caseSList = #(#[SLIST,"SLIST"],#caseSList);}
	;

// inherited from grammar GeneratedJavaRecognizer
forInit :(	(declaration)=> declaration
		// otherwise it could be an expression list...
		|	expressionList
		)?
		{#forInit = #(#[FOR_INIT,"FOR_INIT"],#forInit);}
	;

// inherited from grammar GeneratedJavaRecognizer
forCond :(expression)?
		{#forCond = #(#[FOR_CONDITION,"FOR_CONDITION"],#forCond);}
	;

// inherited from grammar GeneratedJavaRecognizer
forIter :(expressionList)?
		{#forIter = #(#[FOR_ITERATOR,"FOR_ITERATOR"],#forIter);}
	;

// inherited from grammar GeneratedJavaRecognizer
tryBlock :"try"^ compoundStatement
		(handler)*
		( finallyHandler )?
	;

// inherited from grammar GeneratedJavaRecognizer
handler :"catch"^ LPAREN parameterDeclaration RPAREN compoundStatement
	;

// inherited from grammar GeneratedJavaRecognizer
finallyHandler :"finally"^ compoundStatement
    ;

// inherited from grammar GeneratedJavaRecognizer
expression :assignmentExpression
		{#expression = #(#[EXPR,"EXPR"],#expression);}
	;

// inherited from grammar GeneratedJavaRecognizer
expressionList :expression (COMMA expression)*
		{#expressionList = #(#[ELIST,"ELIST"], expressionList);}
	;

// inherited from grammar GeneratedJavaRecognizer
assignmentExpression :conditionalExpression
		(	(	ASSIGN^
            |   PLUS_ASSIGN^
            |   MINUS_ASSIGN^
            |   STAR_ASSIGN^
            |   DIV_ASSIGN^
            |   MOD_ASSIGN^
            |   SR_ASSIGN^
            |   BSR_ASSIGN^
            |   SL_ASSIGN^
            |   BAND_ASSIGN^
            |   BXOR_ASSIGN^
            |   BOR_ASSIGN^
            )
			assignmentExpression
		)?
	;

// inherited from grammar GeneratedJavaRecognizer
conditionalExpression :logicalOrExpression
		( QUESTION^ assignmentExpression COLON conditionalExpression )?
	;

// inherited from grammar GeneratedJavaRecognizer
logicalOrExpression :logicalAndExpression (LOR^ logicalAndExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
logicalAndExpression :inclusiveOrExpression (LAND^ inclusiveOrExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
inclusiveOrExpression :exclusiveOrExpression (BOR^ exclusiveOrExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
exclusiveOrExpression :andExpression (BXOR^ andExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
andExpression :equalityExpression (BAND^ equalityExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
equalityExpression :relationalExpression ((NOT_EQUAL^ | EQUAL^) relationalExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
relationalExpression :shiftExpression
		(	(	(	LT^
				|	GT^
				|	LE^
				|	GE^
				)
				shiftExpression
			)*
		|	"instanceof"^ typeSpec[true]
		)
	;

// inherited from grammar GeneratedJavaRecognizer
shiftExpression :additiveExpression ((SL^ | SR^ | BSR^) additiveExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
additiveExpression :multiplicativeExpression ((PLUS^ | MINUS^) multiplicativeExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
multiplicativeExpression :unaryExpression ((STAR^ | DIV^ | MOD^ ) unaryExpression)*
	;

// inherited from grammar GeneratedJavaRecognizer
unaryExpression :INC^ unaryExpression
	|	DEC^ unaryExpression
	|	MINUS^ {#MINUS.setType(UNARY_MINUS);} unaryExpression
	|	PLUS^  {#PLUS.setType(UNARY_PLUS);} unaryExpression
	|	unaryExpressionNotPlusMinus
	;

// inherited from grammar GeneratedJavaRecognizer
unaryExpressionNotPlusMinus :BNOT^ unaryExpression
	|	LNOT^ unaryExpression

	|	(	// subrule allows option to shut off warnings
			options {
				// "(int" ambig with postfixExpr due to lack of sequence
				// info in linear approximate LL(k).  It's ok.  Shut up.
				generateAmbigWarnings=false;
			}
		:	// If typecast is built in type, must be numeric operand
			// Also, no reason to backtrack if type keyword like int, float...
			lpb:LPAREN^ {#lpb.setType(TYPECAST);} builtInTypeSpec[true] RPAREN
			unaryExpression

			// Have to backtrack to see if operator follows.  If no operator
			// follows, it's a typecast.  No semantic checking needed to parse.
			// if it _looks_ like a cast, it _is_ a cast; else it's a "(expr)"
		|	(LPAREN classTypeSpec[true] RPAREN unaryExpressionNotPlusMinus)=>
			lp:LPAREN^ {#lp.setType(TYPECAST);} classTypeSpec[true] RPAREN
			unaryExpressionNotPlusMinus

		|	postfixExpression
		)
	;

// inherited from grammar GeneratedJavaRecognizer
postfixExpression :primaryExpression // start with a primary

		(	// qualified id (id.id.id.id...) -- build the name
			DOT^ ( IDENT
				| "this"
				| "class"
				| newExpression
				| "super" // ClassName.super.field
				)
			// the above line needs a semantic check to make sure "class"
			// is the _last_ qualifier.

			// allow ClassName[].class
		|	( lbc:LBRACK^ {#lbc.setType(ARRAY_DECLARATOR);} RBRACK! )+
			DOT^ "class"

			// an array indexing operation
		|	lb:LBRACK^ {#lb.setType(INDEX_OP);} expression RBRACK!

			// method invocation
			// The next line is not strictly proper; it allows x(3)(4) or
			//  x[2](4) which are not valid in Java.  If this grammar were used
			//  to validate a Java program a semantic check would be needed, or
			//   this rule would get really ugly...
			// It also allows ctor invocation like super(3) which is now
			// handled by the explicit constructor rule, but it would
			// be hard to syntactically prevent ctor calls here
		|	lp:LPAREN^ {#lp.setType(METHOD_CALL);}
				argList
			RPAREN
		)*

		// possibly add on a post-increment or post-decrement.
		// allows INC/DEC on too much, but semantics can check
		(	in:INC^ {#in.setType(POST_INC);}
	 	|	de:DEC^ {#de.setType(POST_DEC);}
		|	// nothing
		)
	;

// inherited from grammar GeneratedJavaRecognizer
primaryExpression :IDENT
	|	constant
	|	"true"
	|	"false"
	|	"this"
	|	"null"
	|	newExpression
	|	LPAREN assignmentExpression RPAREN
	|	"super"
		// look for int.class and int[].class
	|	builtInType
		( lbt:LBRACK^ {#lbt.setType(ARRAY_DECLARATOR);} RBRACK! )*
		DOT^ "class"
	;

// inherited from grammar GeneratedJavaRecognizer
newExpression :"new"^ type
		(	LPAREN argList RPAREN (classBlock)?

			//java 1.1
			// Note: This will allow bad constructs like
			//    new int[4][][3] {exp,exp}.
			//    There needs to be a semantic check here...
			// to make sure:
			//   a) [ expr ] and [ ] are not mixed
			//   b) [ expr ] and an init are not used together

		|	newArrayDeclarator (arrayInitializer)?
		)
	;

// inherited from grammar GeneratedJavaRecognizer
argList :(	expressionList
		|	/*nothing*/
			{#argList = #[ELIST,"ELIST"];}
		)
	;

// inherited from grammar GeneratedJavaRecognizer
newArrayDeclarator :(
			// CONFLICT:
			// newExpression is a primaryExpression which can be
			// followed by an array index reference.  This is ok,
			// as the generated code will stay in this loop as
			// long as it sees an LBRACK (proper behavior)
			options {
				warnWhenFollowAmbig = false;
			}
		:
			lb:LBRACK^ {#lb.setType(ARRAY_DECLARATOR);}
				(expression)?
			RBRACK!
		)+
	;

// inherited from grammar GeneratedJavaRecognizer
constant :NUM_INT
	|	CHAR_LITERAL
	|	STRING_LITERAL
	|	NUM_FLOAT
	|	NUM_LONG
	|	NUM_DOUBLE
	;

class GeneratedJava14Lexer extends Lexer;

options {
	exportVocab=GeneratedJava14;
	testLiterals=false;
	k=4;
	charVocabulary='\u0003'..'\uFFFE';
	codeGenBitsetTestThreshold=20;
	importVocab=GeneratedJava;
}

tokens {
        ASSERT="assert";
}
{

    // explicitly set tab width to 1 (default in ANTLR 2.7.1)
    // in ANTLR 2.7.2a2 the default has changed from 1 to 8
    public void tab()
    {
        setColumn( getColumn() + 1 );
    }

    private CommentListener mCommentListener = null;

    // TODO: Check visibility of this method one parsing is done in central
    // utility method
    public void setCommentListener(CommentListener aCommentListener)
    { 
        mCommentListener = aCommentListener;
    }

}
protected FLOAT_SUFFIX :'f'|'F'|'d'|'D'
	;

// inherited from grammar GeneratedJavaLexer
QUESTION :'?'		;

// inherited from grammar GeneratedJavaLexer
LPAREN :'('		;

// inherited from grammar GeneratedJavaLexer
RPAREN :')'		;

// inherited from grammar GeneratedJavaLexer
LBRACK :'['		;

// inherited from grammar GeneratedJavaLexer
RBRACK :']'		;

// inherited from grammar GeneratedJavaLexer
LCURLY :'{'		;

// inherited from grammar GeneratedJavaLexer
RCURLY :'}'		;

// inherited from grammar GeneratedJavaLexer
COLON :':'		;

// inherited from grammar GeneratedJavaLexer
COMMA :','		;

// inherited from grammar GeneratedJavaLexer
ASSIGN :'='		;

// inherited from grammar GeneratedJavaLexer
EQUAL :"=="	;

// inherited from grammar GeneratedJavaLexer
LNOT :'!'		;

// inherited from grammar GeneratedJavaLexer
BNOT :'~'		;

// inherited from grammar GeneratedJavaLexer
NOT_EQUAL :"!="	;

// inherited from grammar GeneratedJavaLexer
DIV :'/'		;

// inherited from grammar GeneratedJavaLexer
DIV_ASSIGN :"/="	;

// inherited from grammar GeneratedJavaLexer
PLUS :'+'		;

// inherited from grammar GeneratedJavaLexer
PLUS_ASSIGN :"+="	;

// inherited from grammar GeneratedJavaLexer
INC :"++"	;

// inherited from grammar GeneratedJavaLexer
MINUS :'-'		;

// inherited from grammar GeneratedJavaLexer
MINUS_ASSIGN :"-="	;

// inherited from grammar GeneratedJavaLexer
DEC :"--"	;

// inherited from grammar GeneratedJavaLexer
STAR :'*'		;

// inherited from grammar GeneratedJavaLexer
STAR_ASSIGN :"*="	;

// inherited from grammar GeneratedJavaLexer
MOD :'%'		;

// inherited from grammar GeneratedJavaLexer
MOD_ASSIGN :"%="	;

// inherited from grammar GeneratedJavaLexer
SR :">>"	;

// inherited from grammar GeneratedJavaLexer
SR_ASSIGN :">>="	;

// inherited from grammar GeneratedJavaLexer
BSR :">>>"	;

// inherited from grammar GeneratedJavaLexer
BSR_ASSIGN :">>>="	;

// inherited from grammar GeneratedJavaLexer
GE :">="	;

// inherited from grammar GeneratedJavaLexer
GT :">"		;

// inherited from grammar GeneratedJavaLexer
SL :"<<"	;

// inherited from grammar GeneratedJavaLexer
SL_ASSIGN :"<<="	;

// inherited from grammar GeneratedJavaLexer
LE :"<="	;

// inherited from grammar GeneratedJavaLexer
LT :'<'		;

// inherited from grammar GeneratedJavaLexer
BXOR :'^'		;

// inherited from grammar GeneratedJavaLexer
BXOR_ASSIGN :"^="	;

// inherited from grammar GeneratedJavaLexer
BOR :'|'		;

// inherited from grammar GeneratedJavaLexer
BOR_ASSIGN :"|="	;

// inherited from grammar GeneratedJavaLexer
LOR :"||"	;

// inherited from grammar GeneratedJavaLexer
BAND :'&'		;

// inherited from grammar GeneratedJavaLexer
BAND_ASSIGN :"&="	;

// inherited from grammar GeneratedJavaLexer
LAND :"&&"	;

// inherited from grammar GeneratedJavaLexer
SEMI :';'		;

// inherited from grammar GeneratedJavaLexer
WS :(	' '
		|	'\t'
		|	'\f'
			// handle newlines
		|	(	options {generateAmbigWarnings=false;}
			:	"\r\n"  // Evil DOS
			|	'\r'    // Macintosh
			|	'\n'    // Unix (the right way)
			)
			{ newline(); }
		)+
		{ _ttype = Token.SKIP; }
	;

// inherited from grammar GeneratedJavaLexer
SL_COMMENT :"//"
        { mCommentListener.reportSingleLineComment("//", getLine(),
                                                   getColumn() - 3); }
        (~('\n'|'\r'))* ('\n'|'\r'('\n')?)
        {$setType(Token.SKIP); newline();}
	;

// inherited from grammar GeneratedJavaLexer
ML_COMMENT {
   int startLine;
   int startCol;
}
:"/*"  { startLine = getLine(); startCol = getColumn() - 3; }
		(	/*	'\r' '\n' can be matched in one alternative or by matching
				'\r' in one iteration and '\n' in another.  I am trying to
				handle any flavor of newline that comes in, but the language
				that allows both "\r\n" and "\r" and "\n" to all be valid
				newline is ambiguous.  Consequently, the resulting grammar
				must be ambiguous.  I'm shutting this warning off.
			 */
			options {
				generateAmbigWarnings=false;
			}
		:
			{ LA(2)!='/' }? '*'
		|	'\r' '\n'		{newline();}
		|	'\r'			{newline();}
		|	'\n'			{newline();}
		|	~('*'|'\n'|'\r')
		)*
		"*/"
      {
         mCommentListener.reportBlockComment("/*", startLine, startCol,
                            getLine(), getColumn() - 2);
         $setType(Token.SKIP);
      }
	;

// inherited from grammar GeneratedJavaLexer
CHAR_LITERAL :'\'' ( ESC | ~'\'' ) '\''
	;

// inherited from grammar GeneratedJavaLexer
STRING_LITERAL :'"' (ESC|~('"'|'\\'))* '"'
	;

// inherited from grammar GeneratedJavaLexer
protected ESC :'\\'
		(	'n'
		|	'r'
		|	't'
		|	'b'
		|	'f'
		|	'"'
		|	'\''
		|	'\\'
		|	('u')+ HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
		|	('0'..'3')
			(
				options {
					warnWhenFollowAmbig = false;
				}
			:	('0'..'7')
				(
					options {
						warnWhenFollowAmbig = false;
					}
				:	'0'..'7'
				)?
			)?
		|	('4'..'7')
			(
				options {
					warnWhenFollowAmbig = false;
				}
			:	('0'..'9')
			)?
		)
	;

// inherited from grammar GeneratedJavaLexer
protected HEX_DIGIT :('0'..'9'|'A'..'F'|'a'..'f')
	;

// inherited from grammar GeneratedJavaLexer
protected VOCAB :'\3'..'\377'
	;

// inherited from grammar GeneratedJavaLexer
IDENT 
options {
	testLiterals=true;
}
:('a'..'z'|'A'..'Z'|'_'|'$'| {Character.isJavaIdentifierStart(LA(1))}? '\u0080'..'\uFFFE')
                ('a'..'z'|'A'..'Z'|'_'|'0'..'9'|'$'| {Character.isJavaIdentifierPart(LA(1))}? '\u0080'..'\uFFFE')*
	;

// inherited from grammar GeneratedJavaLexer
NUM_INT {boolean isDecimal=false; Token t=null;}
:'.' {_ttype = DOT;}
            (	('0'..'9')+ (EXPONENT)? (f1:FLOAT_SUFFIX {t=f1;})?
                {
				if (t != null && t.getText().toUpperCase().indexOf('F')>=0) {
                	_ttype = NUM_FLOAT;
				}
				else {
                	_ttype = NUM_DOUBLE; // assume double
				}
				}
            )?

	|	(	'0' {isDecimal = true;} // special case for just '0'
			(	('x'|'X')
				(											// hex
					// the 'e'|'E' and float suffix stuff look
					// like hex digits, hence the (...)+ doesn't
					// know when to stop: ambig.  ANTLR resolves
					// it correctly by matching immediately.  It
					// is therefor ok to hush warning.
					options {
						warnWhenFollowAmbig=false;
					}
				:	HEX_DIGIT
				)+
			|	('0'..'7')+									// octal
			)?
		|	('1'..'9') ('0'..'9')*  {isDecimal=true;}		// non-zero decimal
		)
		(	('l'|'L') { _ttype = NUM_LONG; }

		// only check to see if it's a float if looks like decimal so far
		|	{isDecimal}?
            (   '.' ('0'..'9')* (EXPONENT)? (f2:FLOAT_SUFFIX {t=f2;})?
            |   EXPONENT (f3:FLOAT_SUFFIX {t=f3;})?
            |   f4:FLOAT_SUFFIX {t=f4;}
            )
            {
			if (t != null && t.getText().toUpperCase() .indexOf('F') >= 0) {
                _ttype = NUM_FLOAT;
			}
            else {
	           	_ttype = NUM_DOUBLE; // assume double
			}
			}
        )?
	;

// inherited from grammar GeneratedJavaLexer
protected EXPONENT :('e'|'E') ('+'|'-')? ('0'..'9')+
	;


