from lib.imap import *
from basechecker import BaseChecker
from lib.common import *

class IMAPChecker(BaseChecker):
	def __init__(self, notifier, account_id, status_cb, username, password, 
			server, port, ssl, 
			use_default_mbox, mbox_dir = None):
		self.username = username
		self.server = server
		self.port = port
		self.use_default_mbox = use_default_mbox
		self.mbox_dir = mbox_dir
		
		self.notified = []

		self.imapbox = ImapBox(username, password, 
						server, port, ssl,
						use_default_mbox, mbox_dir)

		BaseChecker.__init__(self, notifier, account_id, status_cb)
					
	def reset(self):
		self.notified = []
	
	def update_info(self, account):
		self.username = account["username"]
		password = account["password"]
		ssl = account["ssl"]
		self.server = account["server"]
		self.port = account["port"]
		ssl = False
		if account.has_key("ssl"):
			if account["ssl"] == "1":
				ssl = True
			elif account["ssl"] == "0":
				ssl = False
		mbox_dir = None
		if account["use_default_mbox"] == "1":
			use_default_mbox = True
		else:
			use_default_mbox = False
			mbox_dir = account["mbox"]
			
		del self.imapbox
		self.imapbox = ImapBox(self.username, password, 
						self.server, self.port, ssl,
						use_default_mbox, mbox_dir)

	def check(self):
		# prevent recalling
		if self.checking: return
		self.start_check()

		mailbox = "%s@%s" % (self.username, self.server)
		
		print "BEGIN checking imap account %s@%s ..." % (self.username, self.server)
		try:
			# each mail in mail: [subject, from, msgid]
			mails = self.imapbox.get_mails()
		except ImapBoxConnectionError:
			err = _("IMAP Error")
			msg = _("Error while connecting to %s on port %s") % (self.server, 
										self.port)
			self.notify_error(error, msg, False)
			self.stop_check()
			return
		except ImapBoxAuthError:
			err = _("IMAP Auth Error")
			msg = _("Invalid Username or password for account %s@%s") % (self.username, 
										self.server)
			
			self.notify_error(error, msg, True)
			self.stop_check()
			return

		count = len(mails)
		returnlist = []

		if count == 0:
			self.notify_msg(mailbox, count, mails)
			self.stop_check()
			print "END checking imap account %s@%s ..." % (self.username, self.server)
			return

		if count < MAX_NOTIFIED_MAILS:
			loop = count
		else:
			loop = MAX_NOTIFIED_MAILS

		tmp = 0
		
		mustnotify = False
		mails.reverse()
		for mail in mails:
			msgid = mail[2]
			if msgid not in self.notified:
				if tmp <= loop:
					try:
						subject = mail[0]
						author = mail[1]
						returnlist.append([author, subject])
					except:
						print "Warning: imapchecker cannot display the message"
					tmp += 1
				self.notified.append(msgid)
				mustnotify = True

		if not mustnotify:
			self.notify_msg(mailbox, count, [])
		else:
			self.notify_msg(mailbox, count, returnlist)

		self.stop_check()

		print "END checking imap account %s@%s ..." % (self.username, self.server)

