/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#include <stdio.h>
#include <ncurses.h>
#include <menu.h>
#include <form.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <libintl.h>
#include <locale.h>
#include <nl_types.h>
#include <string.h>
#include <mcheck.h>
#include "thread.h"
#include "options.h"
#include "log.h"
#include "config.h"
#include "color.h"
#include "gettext.h"

#ifdef GTK_GUI
#include "gtkgui.h"
#endif

#define COLOR_GRAY

void freemenu(MENU *name, ITEM **item, int number);
int one(struct dirent *unused);
void load_dir(char *dir, int width, int height);
void put_addwin(int width, int height, int y, int x);
void put_mainform();
double dirsize(char *dir);
int select_window(bool real);
int add_to_dic();
int menupos;

ITEM **items, **cditems;
MENU *menu, *cdmenu;
WINDOW *menuwin, *mainwin, *addwin, *select_sub, *menuwin_sub, *addwinlist;
int choices, i, lines, cols, c, n, num;
double size;
char homedir[256], *TITLE;
struct conf config;
int DEBUGMSG=0;
typedef struct file_item{
	char filename[255];
	int  type;
	int  size;
} fileitem;
int maxfiles;

fileitem *filei;

struct curses_menu {
    char add[22];
    char del[22];
    char cre[22];
    char cpi[22];
    char wri[22];
    char wau[22];
    char cdc[22];
    char blk[22];
    char opt[22];
    char qut[22];
    char nul[1];
} buttons;

void after_event(char *message, int adddic){
    if ( strcmp(config.showlog, "1")==0 )
        log_window(message, config.logfile, 0);
#ifdef HAVE_LIBMYSQLCLIENT
    if ( (strcmp(config.autodic, "1")==0) && (adddic==1) )
	add_to_dic();
#endif
#ifdef HAVE_LIBSQLITE
    if ( (strcmp(config.autodic, "1")==0) && (adddic==1) )
	add_to_dic();
#endif
    if ( strcmp(config.eject, "1")==0 ){
        eject_tray(config.cdrwdevice);
    }
}

void freemenu(MENU *name, ITEM **item, int number)
{
    unpost_menu(name);
}

void fill_info()
{   wrefresh(menuwin_sub);
    if (strcmp(config.fromimage, "1")==0)
        mvwprintw(menuwin_sub, LINES-10, 2, _("Write from image"));
    else 
	mvwprintw(menuwin_sub, LINES-10, 2, _("Write direct    "));
    mvwprintw(menuwin_sub, LINES-9, 2, _("Speed: %sX "), config.speed);
    if (strcmp(config.multi, "1")==0)
	mvwprintw(menuwin_sub, LINES-8, 2, _("Multi-session "));
    else 
	mvwprintw(menuwin_sub, LINES-8, 2, _("Single session"));
    wrefresh(menuwin_sub);
}

int one(struct dirent *unused)
{
    if (strcmp(unused->d_name,".") && strcmp(unused->d_name,"..")) {
	return 1;
    }
    else
	return 0;
}

void load_dir(char *dir, int width, int height)
{
    struct dirent **eps;
    struct stat stbuf;
    char name[1000];
    int pos=0;

    werase(addwinlist);
    n = scandir(dir, &eps, (void *)0, alphasort);
    filei =  (fileitem *) malloc(n*sizeof(fileitem));
    if (n>0) {
	for (i=0; i<n; ++i) {
	    memset(name, '\0', sizeof(name));
	    strcpy(name, "/");
	    strcat(name, dir);
	    strcat(name, "/");
	    strcat(name, eps[i]->d_name);
	    if ( lstat(name, &stbuf) == -1) {
		endwin();
		fprintf(stderr, _("File: %s not found!"), name);
		exit(-1);
	    }
	    if ( ((stbuf.st_mode& S_IFMT) == S_IFDIR ) && (strcmp(eps[i]->d_name, "." )!=0)){
		strcpy(filei[pos].filename, eps[i]->d_name);
		filei[pos].size=0;
		filei[pos++].type=0;
	    }
	}
	for (i=0; i<n; ++i) {
	    memset(name, '\0', sizeof(name));
	    strcpy(name, "/");
	    strcat(name, dir);
	    strcat(name, "/");
	    strcat(name, eps[i]->d_name);
	    if ( lstat(name, &stbuf) == -1) {
		endwin();
		fprintf(stderr, _("File: %s not found!"), name);
		exit(-1);
	    }
	    if ( (stbuf.st_mode& S_IFMT) != S_IFDIR ) {
		strcpy(filei[pos].filename, eps[i]->d_name);
		filei[pos].size=stbuf.st_size;
		filei[pos++].type=1;
	    }
	}
    }
    maxfiles=n-2;
    for (i=0; i<maxfiles+1; i++){
	if (filei[i].type==0){
	    wattrset(addwinlist, A_BOLD | COLOR_PAIR(2));
	    mvwprintw(addwinlist, i, 0, "/%.*s", getmaxx(addwinlist)-7, filei[i].filename);
	    mvwprintw(addwinlist, i, getmaxx(addwinlist)-5, "DIR");
	}
	if (filei[i].type==1){
	    wattrset(addwinlist, COLOR_PAIR(2));
	    mvwprintw(addwinlist, i, 0, "%.*s", getmaxx(addwinlist)-7, filei[i].filename);
	    mvwprintw(addwinlist, i, getmaxx(addwinlist)-5, "%4d%s", (filei[i].size/1024/1024>1?filei[i].size/1024/1024:filei[i].size/1024), (filei[i].size/1024/1024>1?"M":"K") );	    
	}

    }
    box(addwin, 0, 0);
    mvwprintw(addwin, width-1, 2, "( %s )",dir);
    wattrset(mainwin, A_REVERSE | COLOR_PAIR(2));    
    mvwaddch(addwin, 0, 2, ACS_RTEE);
    mvwprintw(addwin, 0, 3, " %s ", _("Add files"));
    waddch(addwin, ACS_LTEE);
    wrefresh(addwin);    
}

void highlight(int pos, fileitem file_p, int isreverse)
{
     if (file_p.type==0) {
	     if (isreverse==0)
		     wattrset(addwinlist, A_REVERSE | COLOR_PAIR(2));
	     else
		     wattrset(addwinlist, A_BOLD | COLOR_PAIR(2));
	     mvwprintw(addwinlist, pos, 0, "/%.*s", getmaxx(addwinlist)-7, file_p.filename);
     }
     if (file_p.type==1) 
     {
	     if (isreverse==0)
		     wattrset(addwinlist, A_REVERSE | COLOR_PAIR(2));
	     else
		     wattrset(addwinlist, COLOR_PAIR(2));
	     mvwprintw(addwinlist, pos, 0, "%.*s", getmaxx(addwinlist)-7, file_p.filename);
     }
     wrefresh(addwinlist);
}

void put_addwin(int width, int height, int y, int x)
{
    char path[2000], linkfile[2000], newlink[2000];
    struct stat stbuf;
    char name[1000];
    char *pos;
    int screenpos;

    menupos=0;
    addwin=newwin(width,height,y,x);
    keypad(addwin, TRUE);
    wbkgd(addwin, A_NORMAL | COLOR_PAIR(2));
    wattrset(addwin, A_NORMAL | COLOR_PAIR(2));
    box(addwin, 0, 0);
    addwinlist=derwin(addwin, width-2, height-2, 1, 1);
    wbkgd(addwinlist, A_NORMAL | COLOR_PAIR(2));
    mvwaddch(addwin, 0, 2, ACS_RTEE);
    mvwprintw(addwin, 0, 3, " %s ", _("Add files"));
    waddch(addwin, ACS_LTEE);
    sprintf(path,"%s",getenv("HOME"));
    load_dir(path, width, height);
    highlight(0, filei[menupos], 0);
    while ( (c=wgetch(addwin))!=27 ){
	    switch(c){
		// First item
    		case KEY_HOME:
		    if (menupos>0) {
		       menupos=0;
		       werase(addwinlist);
		       for (i=0; i<=maxfiles; i++){
			   highlight(i-menupos, filei[i], 1);
			   if (filei[i].type==0) {
			      wattrset(addwinlist, A_BOLD | COLOR_PAIR(2));
	    		      mvwprintw(addwinlist, i-menupos, getmaxx(addwinlist)-5, "DIR");
 			   } else if (filei[i].type==1){
		    	      wattrset(addwinlist, COLOR_PAIR(2));
	    		      mvwprintw(addwinlist, i-menupos, getmaxx(addwinlist)-5, "%4d%s", (filei[i].size/1024/1024>1?filei[i].size/1024/1024:filei[i].size/1024), (filei[i].size/1024/1024>1?"M":"K") );	    
			   }
		       }
		       screenpos=0;
		       highlight(screenpos, filei[menupos], 0);
		       wrefresh(addwinlist);
		    }
		    break;
		// Last item
		case KEY_END:
		    if (menupos<maxfiles) {
		       menupos=maxfiles-(maxfiles%getmaxy(addwinlist));
		       werase(addwinlist);
		       for (i=menupos; i<=maxfiles; i++){
			   highlight(i-menupos, filei[i], 1);
			   if (filei[i].type==0) {
			      wattrset(addwinlist, A_BOLD | COLOR_PAIR(2));
	    		      mvwprintw(addwinlist, i-menupos, getmaxx(addwinlist)-5, "DIR");
 			   } else if (filei[i].type==1){
		    	      wattrset(addwinlist, COLOR_PAIR(2));
	    		      mvwprintw(addwinlist, i-menupos, getmaxx(addwinlist)-5, "%4d%s", (filei[i].size/1024/1024>1?filei[i].size/1024/1024:filei[i].size/1024), (filei[i].size/1024/1024>1?"M":"K") );	    
			   }
		       }
		       menupos=maxfiles;
		       screenpos=menupos%getmaxy(addwinlist);
		       highlight(screenpos, filei[menupos], 0);
		       wrefresh(addwinlist);
		    }
		    break;
		// Next item
		case KEY_DOWN:
		    if (menupos<maxfiles) {
		       menupos++;
		       if ( (menupos%(getmaxy(addwinlist))!=0 ) || (menupos==0) ){
			  if (menupos<getmaxy(addwinlist))
		             screenpos=menupos;
			  else
		             screenpos=menupos%getmaxy(addwinlist);
			  highlight(screenpos-1, filei[menupos-1], 1);
			  highlight(screenpos, filei[menupos], 0);
			  wrefresh(addwinlist);
		       } else {
			  werase(addwinlist);
			  for (i=menupos-1; i<=maxfiles; i++) {
			      highlight(i-menupos, filei[i], 1);
			      if (filei[i].type==0) {
				 wattrset(addwinlist, A_BOLD | COLOR_PAIR(2));
	    			 mvwprintw(addwinlist, i-menupos, getmaxx(addwinlist)-5, "DIR");
 			      } else if (filei[i].type==1){
		    		 wattrset(addwinlist, COLOR_PAIR(2));
	    			 mvwprintw(addwinlist, i-menupos, getmaxx(addwinlist)-5, "%4d%s", (filei[i].size/1024/1024>1?filei[i].size/1024/1024:filei[i].size/1024), (filei[i].size/1024/1024>1?"M":"K") );	    
			      }
			  }
			  screenpos=menupos%getmaxy(addwinlist);
			  highlight(screenpos, filei[menupos], 0);
			  wrefresh(addwinlist);
		       }
		    }
		    break;
		// Prev item
		case KEY_UP:
		    if (menupos>0){
		       menupos--;
		       if ( (menupos%(getmaxy(addwinlist))!=getmaxy(addwinlist)-1) || (menupos==0) ){
			  if (menupos<getmaxy(addwinlist))
			     screenpos=menupos;
			  else
			     screenpos=menupos%getmaxy(addwinlist);
			  highlight(screenpos+1, filei[menupos+1], 1);
			  highlight(screenpos, filei[menupos], 0);
			  wrefresh(addwinlist);
		       }
		       else {
			  werase(addwinlist);
			  for (i=(menupos-getmaxy(addwinlist)); i<=maxfiles; i++){
			      highlight(i-(menupos-getmaxy(addwinlist))-1, filei[i], 1);
			      if (filei[i].type==0) {
				 wattrset(addwinlist, A_BOLD | COLOR_PAIR(2));
	    			 mvwprintw(addwinlist, i-(menupos-getmaxy(addwinlist))-1, getmaxx(addwinlist)-5, "DIR");
 			      } else if (filei[i].type==1){
		    		 wattrset(addwinlist, COLOR_PAIR(2));
	    			 mvwprintw(addwinlist, i-(menupos-getmaxy(addwinlist))-1, getmaxx(addwinlist)-5, "%4d%s", (filei[i].size/1024/1024>1?filei[i].size/1024/1024:filei[i].size/1024), (filei[i].size/1024/1024>1?"M":"K") );	    
			      }
			  }
			  screenpos=getmaxy(addwinlist)-1;
			  highlight(screenpos, filei[menupos], 0);
			  wrefresh(addwinlist);
		       }
		    }
		    break;
		// Chdir
		case 10:
		    memset(name, '\0', sizeof(name));
		    strcpy(name, path);
		    strcat(name, "/");
		    strcat(name, filei[menupos].filename );
		    if ( stat(name, &stbuf) == -1) {
			endwin();
			fprintf(stderr, _("File: %s not found!"), name);
			exit(-1);
		    }
		    if ( (stbuf.st_mode& S_IFMT) == S_IFDIR ) {
			strcpy(linkfile, path);
		        if ( strcmp(filei[menupos].filename,"..")==0 ){
			   if ( (pos=(char *)strrchr((char *)path, '/')) != NULL )
			      memset(pos,'\0',1);
			   if ( strlen(path)<=0 ) 
			      strcat(path, "/");
			} else {
			   if ( path[strlen(path)-1]!='/' ) 
			      strcat(path, "/");
			   strcat(path, filei[menupos].filename);
			}
			if ( access(path, R_OK | X_OK)==-1 ){
			    strcpy(path, linkfile);
			} else {
			    free(filei);
			    menupos=0;
		    	    load_dir(path, width, height);
			    highlight(0, filei[menupos], 0);
			}
		    }
		    break;
		// Add item
		case ' ':
		    strcpy(linkfile, path);
		    strcat(linkfile,"/");
		    strcat(linkfile,filei[menupos].filename);
		    strcpy(newlink,homedir);
		    strcat(newlink,"/");
		    strcat(newlink,filei[menupos].filename);
		    symlink(linkfile, newlink);
		    box(addwin, 0, 0);
		    mvwprintw(addwin, width-1, 2, "( %s )",path);
		    wattrset(mainwin, A_REVERSE | COLOR_PAIR(2));    
		    mvwaddch(addwin, 0, 2, ACS_RTEE);
		    mvwprintw(addwin, 0, 3, " %s ", _("Add files"));
		    waddch(addwin, ACS_LTEE);
		    select_window(TRUE);
		    break;
	    }
	    wrefresh(addwinlist);
    }
    free(filei);
    delwin(addwin);
}


void put_mainform()
{
    mainwin=newwin(LINES-1,COLS-1,0,0);
    keypad(mainwin, TRUE);
    wbkgd(mainwin, A_NORMAL | COLOR_PAIR(1));
    box(mainwin, 0, 0);
    mvwaddch(mainwin, 2, 0, ACS_LTEE);
    mvwhline(mainwin, 2, 1, ACS_HLINE, COLS-3);
    mvwaddch(mainwin, 2, COLS-2, ACS_RTEE);
    wattrset(mainwin, A_BOLD | COLOR_PAIR(3));
    mvwprintw(mainwin, 1, (COLS / 2) - (strlen(TITLE) / 2), TITLE);
    wattrset(mainwin, A_NORMAL | COLOR_PAIR(1));

    // *** Main Menu ***
    strcpy(buttons.add, _(" Add files           "));
    strcpy(buttons.del, _(" Delete files        "));
    strcpy(buttons.cre, _(" Create image        "));
    strcpy(buttons.cpi, _(" Copy CD image       "));
    strcpy(buttons.wri, _(" Write data CD       "));
    strcpy(buttons.wau, _(" Write audio CD      "));
    strcpy(buttons.cdc, _(" Copy data CD        "));
    strcpy(buttons.blk, _(" Blank CD-RW         "));
    strcpy(buttons.opt, _(" Options             "));
    strcpy(buttons.qut, _(" Quit                "));
    
    items = (ITEM **)calloc(11, sizeof(ITEM *));
    
    items[0]=new_item(buttons.add, "");
    items[1]=new_item(buttons.del, "");
    items[2]=new_item(buttons.cre, "");
    items[3]=new_item(buttons.cpi, "");
    items[4]=new_item(buttons.wri, "");
    items[5]=new_item(buttons.wau, "");
    items[6]=new_item(buttons.cdc, "");
    items[7]=new_item(buttons.blk, "");
    items[8]=new_item(buttons.opt, "");
    items[9]=new_item(buttons.qut, "");
    items[10]=new_item((char *)0, "");
    // *****************
    
    menu = new_menu((ITEM **)items);
    set_menu_win(menu, mainwin);
    set_menu_sub(menu, derwin(mainwin, LINES-8, 26, 5, 3));
    set_menu_fore(menu, COLOR_PAIR(4) | A_REVERSE);
    set_menu_back(menu, COLOR_PAIR(4));
    set_menu_mark(menu, "");
    select_sub=derwin(mainwin, LINES-5, COLS-29, 3, 27);
    menuwin_sub=derwin(mainwin, LINES-5, 26, 3, 1);
    box(derwin(mainwin, LINES-5, 26, 3, 1),0,0);
    box(select_sub,0,0);
    mvwaddch(menuwin_sub, 0, 2, ACS_RTEE);
    mvwprintw(menuwin_sub, 0, 3," %s ", _("Menu"));
    waddch(menuwin_sub, ACS_LTEE);
    mvwaddch(menuwin_sub, LINES-11, 0, ACS_LTEE);
    mvwhline(menuwin_sub, LINES-11, 1, ACS_HLINE, 24);
    mvwaddch(menuwin_sub, LINES-11, 25, ACS_RTEE);
    mvwprintw(menuwin_sub, LINES-11, 2,"( %s )", _("Info"));
    fill_info();

    mvwaddch(select_sub, 0, 2, ACS_RTEE);
    mvwprintw(select_sub, 0, 3," %s ",_("Selected files"));
    waddch(select_sub, ACS_LTEE);
    wattrset(select_sub, A_NORMAL | COLOR_PAIR(1));
    mvwaddch(select_sub, LINES-11, 0, ACS_LTEE);
    mvwhline(select_sub, LINES-11, 1, ACS_HLINE, COLS-31);
    mvwaddch(select_sub, LINES-11, COLS-30, ACS_RTEE);
    mvwaddch(select_sub, LINES-9, 0, ACS_LTEE);
    mvwhline(select_sub, LINES-9, 1, ACS_HLINE, COLS-31);
    mvwaddch(select_sub, LINES-9, COLS-30, ACS_RTEE);

    wattrset(mainwin, A_BOLD | COLOR_PAIR(2));
    post_menu(menu);
    wrefresh(mainwin);
}

double dirsize(char *dir)
{
    struct dirent **eps;
    struct stat *finfo;
    int n, ok, err, type, cnt;
    char *dname, *ch, ftime[256];

    n = scandir(dir, &eps, (void *)one, alphasort);
    if (n>=0) {
	for (cnt=0; cnt<n; ++cnt){
    	    ch=(char *) malloc(strlen(eps[cnt]->d_name)+strlen(dir)+4);
	    sprintf(ch,"%s/%s",dir,eps[cnt]->d_name);
	    finfo=(struct stat *)malloc(sizeof(finfo)+100);
	    ok=lstat(ch,finfo);
	    if ( (eps[cnt]->d_type=DT_DIR) ) 
		dirsize(ch);
	    if (ok=stat(ch,finfo)!=0);
	    else {
		size+=finfo->st_size;
	    }
	    free(finfo);
    	    free(ch);
	}
    }
    return size;
}

void delete_files()
{
    int c;
    char filetodelete[200]="\0";
    
    while ( ((c=wgetch(mainwin))!=27) && (num>0) ){
	switch(c){
	    case KEY_HOME:
		menu_driver(cdmenu, REQ_FIRST_ITEM);
		break;
	    case KEY_END:
		menu_driver(cdmenu, REQ_LAST_ITEM);
		break;
	    case KEY_DOWN:
		menu_driver(cdmenu, REQ_DOWN_ITEM);
		break;
	    case KEY_UP:
		menu_driver(cdmenu, REQ_UP_ITEM);
		break;
	    case KEY_DC:
    		strcpy(filetodelete, homedir);
		strcat(filetodelete,"/");
		strcat(filetodelete,item_name(current_item(cdmenu)));
		unlink(filetodelete);
		freemenu(cdmenu, cditems, num+1);
		select_window(TRUE);
		set_menu_fore(cdmenu, COLOR_PAIR(1)|A_REVERSE);
		fflush(stdin);
		break;
	}
	wrefresh(derwin(mainwin, LINES-8, COLS-31, 4, 28));
    }
}

void size_selector()
{
    WINDOW *volwin, *edit;
    int ch=0;
    char cdsize[20];
    
    volwin=newwin(10,30,(LINES-10)/2,(COLS-30)/2);
    wbkgd(volwin, COLOR_PAIR(2));
    werase(volwin);
    box(volwin,0,0);
    mvwaddch(volwin, 0, 2, ACS_RTEE);
    mvwprintw(volwin, 0, 3, " %s ", _("CD size"));
    waddch(volwin, ACS_LTEE);
    mvwprintw(volwin, 2, 3, _("Select CD size"));
    mvwprintw(volwin, 4, 5, "1 - 74 Min (650 MB)");
    mvwprintw(volwin, 5, 5, "2 - 80 Min (700 MB)");
    mvwprintw(volwin, 6, 5, "3 - DVD - (4700 MB)");
    mvwprintw(volwin, 7, 5, "4 -");
    edit=derwin(volwin, 1, 4, 7, 9);
    wbkgd(edit, COLOR_PAIR(6));
    werase(edit);
    sprintf(cdsize,"%d",config.cdsize);
    mvwprintw(edit, 0, 0, cdsize);
    switch (config.cdsize){
	case 657:
	    mvwaddch(volwin, 4, 3, '*');
	    break;
	case 702:
	    mvwaddch(volwin, 5, 3, '*');
	    break;
	case 4700:
	    mvwaddch(volwin, 6, 3, '*');
	    break;
	default:
	    mvwaddch(volwin, 7, 3, '*');
	    break;
    }
    wrefresh(edit);
    wmove(volwin, 9,29);
    while ( (ch!=27) && (ch!=10) ){
	ch=wgetch(volwin);
	switch(ch){
	    case '1':
		config.cdsize=657;
		break;
	    case '2':
		config.cdsize=702;
		break;
	    case '3':
		config.cdsize=4700;
		break;
	    case '4':
		sprintf(cdsize,"%d",config.cdsize);
		inbox(edit, cdsize);
		config.cdsize=atoi(cdsize);
		break;
	}
	mvwaddch(volwin, 4, 3, ' ');
	mvwaddch(volwin, 5, 3, ' ');
	mvwaddch(volwin, 6, 3, ' ');
	if ( config.cdsize == 657 )
    	    mvwaddch(volwin, 4, 3, '*');
	else if ( config.cdsize == 702 )
    	    mvwaddch(volwin, 5, 3, '*');
	else
    	    mvwaddch(volwin, 6, 3, '*');
	wrefresh(volwin);
    }
    write_conf(config);
}

void space(double size)
{
    int i;
    float percent;

    for (i=30; i<COLS-3; i++)
	mvwaddch(mainwin,LINES-5,i, ' ');
    for (i=1; i<30; i++)
	mvwaddch(mainwin,LINES-4,29+i, ACS_BOARD);
    if (size<=config.cdsize) {
	percent=(size / ((float)config.cdsize / 100));
	for (i=1; i<(int)((percent*30)/100); i++)
	    mvwaddch(mainwin,LINES-4,29+i, ACS_BLOCK);
    }
    else {
	percent=(float)(100);
    	for (i=1; i<30; i++)
	    mvwaddch(mainwin,LINES-4,29+i, ACS_BLOCK);
    }
    if ( config.cdsize-size >= 0 ) 
	mvwprintw(mainwin,LINES-5,30, _("Used: %2.1f%%, Wasted: %.0f/%d MB"), percent, config.cdsize-size,config.cdsize);
    else
	mvwprintw(mainwin,LINES-5,30, _("Used: %2.1f%%, Wasted: %d MB"), percent, config.cdsize);
}

int cdda2wav()
{
    WINDOW *cddawin, *starttrack, *endtrack, *bitsperchn_win, *bitrate_win;
    FILE *fp;
    DIR *directory;
    char *line;
    int start_track=0, end_track=0, max_track=0, tracknum=0;
    int ch=0, bitspc, bitrate;
    char lame[2], tmp[18], encode[255], ogg[255], cdinfo[255], strk[4], etrk[4], bpc[2], stereo[2], echo[2], highq[2], brate[4], cmd[255];
    FIELD *field[18];
    FORM *form;

    sprintf(cdinfo,"%s -D%s -J -H -g", CDDA2WAV, config.cdrom);
    run_command(cdinfo, _("Load CD info..."), 0, 0, 0, "");

    if ( (fp=fopen(config.logfile,"r"))==NULL){
	endwin();
	fprintf(stderr, _("Cannot open file..."));
	exit(-1);
    }
    line=(char *)malloc(1024);

    while ( (line=fgets(line, 256, fp))!=NULL){
	// T01:      33  2:36.25 audio linear copydenied stereo title '' from ''
	if (sscanf(line, "T%d: %s %s audio %s", &max_track, tmp, tmp, cdinfo) == 4 ){
	    start_track=1;
	    end_track=max_track;
	}
    }
    cddawin=newwin(15,60,(LINES-15)/2,(COLS-60)/2);
    keypad(cddawin, TRUE);
    wbkgd(cddawin, COLOR_PAIR(2));
    werase(cddawin);
    box(cddawin,0,0);
    mvwaddch(cddawin, 0, 2, ACS_RTEE);
    mvwprintw(cddawin, 0, 3, " %s ", _("Grab Audio CD"));
    waddch(cddawin, ACS_LTEE);
    mvwprintw(cddawin, 14, 2, "( %s )", _("Press G to start or ESC to exit"));
    if (end_track!=0)
	mvwprintw(cddawin, 2, 2, "%s %d", _("Number of tracks:"), max_track);
    else {
	wattrset(cddawin, COLOR_PAIR(7));
	mvwprintw(cddawin, 2, 2, _("No audio CD!"), max_track);
    }
    wattrset(cddawin, COLOR_PAIR(2));
    
    sprintf(bpc, "%s", config.bitsperchn);
    sprintf(brate, "%s", config.bitrate);
    sprintf(stereo, "%s", config.stereo);
    sprintf(echo, "%s", config.echosound);
    sprintf(encode, "%s", config.encode);
    sprintf(lame, "%s", config.lame);
    sprintf(highq, "%s", config.highq);
    sprintf(strk, "%d", start_track);
    sprintf(etrk, "%d", end_track);
    
    
    field[0]=new_field(1, 20, 1, 1, 0, 0);
    set_field_buffer(field[0], 0, _("Start track"));    
    field[1]=new_field(1, 3, 1, 22, 0, 0);
    set_field_buffer(field[1], 0, strk);

    field[2]=new_field(1, 20, 2, 1, 0, 0);
    set_field_buffer(field[2], 0, _("End track"));    
    field[3]=new_field(1, 3, 2, 22, 0, 0);
    set_field_buffer(field[3], 0, etrk);

    field[4]=new_field(1, 20, 4, 1, 0, 0);
    set_field_buffer(field[4], 0, _("Stereo"));    
    field[5]=new_field(1, 1, 4, 23, 0, 0);
    set_field_buffer(field[5], 0, (!strncmp(stereo, "1", 1)?"X":"_"));

    field[6]=new_field(1, 24, 4, 29, 0, 0);
    set_field_buffer(field[6], 0, _("Bits per channel"));
    field[7]=new_field(1, 3, 4, 54, 0, 0);
    set_field_buffer(field[7], 0, bpc);
    
    field[8]=new_field(1, 20, 5, 1, 0, 0);
    set_field_buffer(field[8], 0, _("Echo to sound dev."));    
    field[9]=new_field(1, 1, 5, 23, 0, 0);
    set_field_buffer(field[9], 0, (!strncmp(echo, "1", 1)?"X":"_"));
    
    field[10]=new_field(1, 20, 6, 1, 0, 0);
    set_field_buffer(field[10], 0, _("Encode to Ogg Vorbis"));    
    field[11]=new_field(1, 1, 6, 23, 0, 0);
    set_field_buffer(field[11], 0, (!strncmp(encode, "1", 1)?"X":"_"));
    
    field[12]=new_field(1, 24, 6, 29, 0, 0);
    set_field_buffer(field[12], 0, _("High Quality"));
    field[13]=new_field(1, 1, 6, 55, 0, 0);
    set_field_buffer(field[13], 0, (!strncmp(highq, "1", 1)?"X":"_"));

    field[14]=new_field(1, 20, 7, 1, 0, 0);
    set_field_buffer(field[14], 0, _("Encode to Mp3"));    
    field[15]=new_field(1, 1, 7, 23, 0, 0);
    set_field_buffer(field[15], 0, (!strncmp(lame, "1", 1)?"X":"_"));
    
    field[16]=new_field(1, 24, 7, 29, 0, 0);
    set_field_buffer(field[16], 0, _("Bitrate"));
    field[17]=new_field(1, 4, 7, 54, 0, 0);
    set_field_buffer(field[17], 0, brate);
    field[18]=NULL;

    /* Entries */
    for (i=1; i<=9; i++) { 
	switch (i){
#ifndef OGGENC
	    case 6:
		field_opts_off(field[(i*2)-1], O_ACTIVE);
		set_field_back(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
#ifndef LAME
	    case 8:
		field_opts_off(field[(i*2)-1], O_ACTIVE);
		set_field_back(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-1], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
	    case 1:
	    case 2:
	    case 4:
	    case 9:
		switch(i) {
		    case 1:
			set_field_type(field[(i*2)-1], TYPE_REGEXP, "[0-9]{,2}");
			break;
		    case 2:
			set_field_type(field[(i*2)-1], TYPE_REGEXP, "[0-9]{1,2}");
			break;
		    case 4:
			set_field_type(field[(i*2)-1], TYPE_REGEXP, "(8|12|16)+");
			break;
		    case 9:
			set_field_type(field[(i*2)-1], TYPE_REGEXP, "(32|56|64|96|128|192|320)+");
			break;
		}
		set_field_back(field[(i*2)-1], COLOR_PAIR(6));
		set_field_fore(field[(i*2)-1], COLOR_PAIR(6));
		break;
	    default:
		set_field_type(field[(i*2)-1], TYPE_REGEXP, "^(X|_)$");
		set_field_back(field[(i*2)-1], COLOR_PAIR(2));
		set_field_fore(field[(i*2)-1], COLOR_PAIR(2));
		break;
	}
    }
    /* Lables */
    for (i=1; i<=9; i++) {
	set_field_just(field[(i*2)-2], JUSTIFY_RIGHT);
	field_opts_off(field[(i*2)-2], O_ACTIVE);
	switch (i) {
#ifndef OGGENC
	    case 6:
		set_field_back(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
#ifndef LAME
	    case 8:
		set_field_back(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		set_field_fore(field[(i*2)-2], COLOR_PAIR(9) | A_BOLD);
		break;
#endif
	    default:
		set_field_back(field[(i*2)-2], COLOR_PAIR(2));
		set_field_fore(field[(i*2)-2], COLOR_PAIR(2));
		break;
	}
    }
    form=new_form(field);
    set_form_win(form, cddawin);
    set_form_sub(form, derwin(cddawin, 10, 58, 3, 1));
    post_form(form); 

    put_ckbox(cddawin, 7, 23);
    put_ckbox(cddawin, 8, 23);
#ifdef OGGENC
    put_ckbox(cddawin, 9, 23);
#endif
    put_ckbox(cddawin, 9, 55);
#ifdef LAME    
    put_ckbox(cddawin, 10, 23);
#endif
    
    set_current_field(form, field[0]);
    form_driver(form, REQ_END_LINE);
    wrefresh(cddawin);
    
    wattrset(cddawin, COLOR_PAIR(2));
    while ( (ch=wgetch(cddawin)) != 27 ){
	switch(ch){
	    case KEY_HOME:
		form_driver(form, REQ_BEG_LINE);
		break;
	    case KEY_END:
		form_driver(form, REQ_END_LINE);
		break;
	    case KEY_LEFT:
		form_driver(form, REQ_PREV_CHAR);
		break;
	    case KEY_RIGHT:
		form_driver(form, REQ_NEXT_CHAR);
		break;
	    case KEY_DOWN:
		form_driver(form, REQ_NEXT_FIELD);
		form_driver(form, REQ_END_LINE);
		break;
	    case KEY_UP:
		form_driver(form, REQ_PREV_FIELD);
		form_driver(form, REQ_END_LINE);
		break;
	    case KEY_BACKSPACE:
		form_driver(form, REQ_DEL_PREV);
		break;
	    case KEY_DC:
		form_driver(form, REQ_DEL_CHAR);
		break;
	    case 'g':
	    case 'G':
		//mkdir(config.audiodir, S_IRWXU);
		if ((directory=opendir(config.audiodir))==NULL) {
		    if (dialogbox(_("Audio directory not exist!\nDo you wish to create?"), _("Directory not exist"), 3)==0){
			if (mkdir(config.audiodir, S_IRWXU)!=0){
			    dialogbox(_("Cannot create directory!"), _("Error"), 0);
			    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			    break;
			}
		        wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    } else {
			wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			break;
		    }
		}
		(void) closedir(directory);
		wrefresh(cddawin);
		if ( end_track!=0 ){
		    sprintf(config.stereo, (!strncmp(field_buffer(field[5], 0), "X", 1)?"1":"0"));
		    sprintf(config.bitsperchn, rtrim(field_buffer(field[7], 0)));
		    sprintf(config.echosound, (!strncmp(field_buffer(field[9], 0), "X", 1)?"1":"0"));
		    sprintf(config.encode, (!strncmp(field_buffer(field[11], 0), "X", 1)?"1":"0"));
		    sprintf(config.highq, (!strncmp(field_buffer(field[13], 0), "X", 1)?"1":"0"));
		    sprintf(config.lame, (!strncmp(field_buffer(field[15], 0), "X", 1)?"1":"0"));
		    sprintf(config.bitrate, rtrim(field_buffer(field[17], 0)));
		    start_track=atoi(rtrim(field_buffer(field[1], 0)));
		    end_track=atoi(rtrim(field_buffer(field[3], 0)));
		    write_conf(config);
		    sprintf(cdinfo, "%s ", CDDA2WAV);
		    if ( strncmp(config.stereo,"1",strlen(config.stereo))==0)
			sprintf(cdinfo, "%s -s", cdinfo);
		    else
			sprintf(cdinfo, "%s -m", cdinfo);
		    if ( strncmp(config.echosound,"1", strlen(config.echosound))==0){
			sprintf(cdinfo, "%s -e", cdinfo);
		    }
		    if ( strncmp(config.encode,"1", strlen(config.encode))==0){
			char msg[30];
#ifdef OGGENC 
			wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			sprintf(cmd, "%s", cdinfo);
			for (tracknum=start_track; tracknum<=end_track; tracknum++) {
			    if ( strncmp(config.highq,"1", strlen(config.highq))==0){
			       sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -q 8 -o %s/audio_%.2d.ogg -", cmd, config.cdrom, tracknum, config.bitsperchn, OGGENC, config.audiodir, tracknum);
			    }
			    else
			       sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -b%s -o %s/audio_%.2d.ogg -", cmd, config.cdrom, tracknum, config.bitsperchn, OGGENC, config.bitrate, config.audiodir, tracknum);
			   sprintf(msg, _("Track: %d"), tracknum);
			   run_command(cdinfo, _("Grab Audio CD"), 0, 0, 1, msg);
			}
#endif			
		    } else if ( strncmp(config.lame,"1", strlen(config.lame))==0){
			char msg[30];
#ifdef LAME			  		
			wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			sprintf(cmd, "%s", cdinfo);
			for (tracknum=start_track; tracknum<=end_track; tracknum++) {
			    if ( strncmp(config.highq,"1", strlen(config.highq))==0){
			       sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -h -V2 -b%s - %s/audio_%.2d.mp3 -", cmd, config.cdrom, tracknum, config.bitsperchn, LAME, config.bitrate, config.audiodir, tracknum);
			    }
			    else
			       sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H - | %s -b%s - %s/audio_%.2d.mp3 -", cmd, config.cdrom, tracknum, config.bitsperchn, LAME, config.bitrate, config.audiodir, tracknum);
			    sprintf(msg, _("Track: %d"), tracknum);
			    run_command(cdinfo, _("Grab Audio CD"), 0, 0, 1, msg);
			}
#endif			
		    } else {
			char msg[30];

			wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			sprintf(cmd, "%s", cdinfo);
			for (tracknum=start_track; tracknum<=end_track; tracknum++) {
			    sprintf(cdinfo, "%s -D%s -t%d -b%s -g -H %s/audio_%.2d.wav", cmd, config.cdrom, tracknum, bpc, config.audiodir, tracknum);
			    sprintf(msg, _("Track: %d"), tracknum);
			    run_command(cdinfo, _("Grab Audio CD"), 0, 0, 1, msg);
			}
		    }
		    wrefresh(derwin(cddawin,15,60,0,0));    
		    wrefresh(cddawin);
		}
		break;
	    default:
		if (ch==' ') {
		    FIELD *cur;
		    int fld_index;

		    cur=current_field(form);
		    fld_index=field_index(cur);
		    switch (fld_index) {
			case 5:
			case 9:
			case 11:
			case 13:
			case 15:
			    ch=(!strncmp(field_buffer(cur, 0), "X", 1)?'_':'X');
			    if ((fld_index==11) && (!strcmp(field_buffer(field[11], 0), "_"))){
				set_field_buffer(field[15], 0, "_");
			    }
			    if ((fld_index==15) && (!strcmp(field_buffer(field[15], 0), "_"))){
				set_field_buffer(field[11], 0, "_");
			    }
			    break;
		    }
		}
		form_driver(form, ch);
		break;
	}
	wrefresh(cddawin);
    }
}

int select_window(bool real)
{
    struct dirent **cdfiles;
    int pos=0, datasize=0;
    
    if (real==TRUE) {
	num = scandir(homedir, &cdfiles, (void *)one, alphasort);
	cditems = (ITEM **)calloc(num+1, sizeof(ITEM *));
	if (num>0) {
    	    for (i=0; i<num; ++i) {
    		if ( cdfiles[i]->d_type==DT_DIR )
		    cditems[pos++]=new_item(cdfiles[i]->d_name," DIR");
	    }
	    for (i=0; i<num; ++i) {
		if ( cdfiles[i]->d_type!=DT_DIR )
	    	    cditems[pos++]=new_item(cdfiles[i]->d_name,"");
	    }
	}
	cditems[num]=(ITEM *)NULL;
	cdmenu = new_menu((ITEM **)cditems);
	set_menu_win(cdmenu, mainwin);
	set_menu_sub(cdmenu, derwin(mainwin, LINES-12, COLS-31, 4, 28));
	set_menu_format(cdmenu, LINES-12, 1);
	set_menu_fore(cdmenu, COLOR_PAIR(1));
	set_menu_back(cdmenu, COLOR_PAIR(1));
	post_menu(cdmenu);
    }
    select_sub=derwin(mainwin, LINES-8, COLS-29, 3, 27);
    wattrset(select_sub, A_NORMAL | COLOR_PAIR(1));
    mvwaddch(select_sub, LINES-11, 0, ACS_LTEE);
    mvwhline(select_sub, LINES-11, 1, ACS_HLINE, COLS-31);
    mvwaddch(select_sub, LINES-11, COLS-30, ACS_RTEE);
    wattrset(mainwin, A_BOLD | COLOR_PAIR(8));
    size=0;
    for (i=30; i<COLS-3; i++)
	mvwaddch(mainwin,LINES-7,i, ' ');
    mvwprintw(mainwin,LINES-7,30,_("Size: %.0f Mb in %d files"),dirsize(homedir)/1024/1024, num);
    space(size/1024/1024);
    wrefresh(mainwin);
}

int input_volume(char *title, char *label, char *prop)
{
    WINDOW *volwin, *edit;
    FIELD *field[2];
    FORM *form1;
    int ret;
    int ch;
    
    volwin=newwin(10,30,(LINES-10)/2,(COLS-30)/2);
    keypad(volwin, TRUE);
    wbkgd(volwin, COLOR_PAIR(2));
    werase(volwin);
    box(volwin,0,0);
    mvwaddch(volwin, 0, 2, ACS_RTEE);
    mvwprintw(volwin, 0, 3, " %s ", _(title));
    waddch(volwin, ACS_LTEE);
    mvwprintw(volwin, 3, 3, _(label));
    field[0]=new_field(1, 24, 0, 0, 0, 0);
    set_field_buffer(field[0], 0, prop);
    set_field_back(field[0], COLOR_PAIR(6));
    set_field_fore(field[0], COLOR_PAIR(6));
    field[1]=NULL;
    form1=new_form(field);
    set_form_win(form1, volwin);
    set_form_sub(form1, derwin(volwin, 1, 24, 5, 2));
    post_form(form1); 
    set_current_field(form1, field[0]);
    form_driver(form1, REQ_END_LINE);
    wrefresh(volwin);
    ch=0;
    while ( (ch != 27) && (ch != 10) ){
	ch=wgetch(volwin);
	switch(ch){
	    case KEY_LEFT:
		form_driver(form1, REQ_PREV_CHAR);
		break;
	    case KEY_RIGHT:
		form_driver(form1, REQ_NEXT_CHAR);
		break;
	    case KEY_BACKSPACE:
		form_driver(form1, REQ_DEL_PREV);
		break;
	    case KEY_DC:
		form_driver(form1, REQ_DEL_CHAR);
		break;
	    case KEY_F(10):
	    case 10:
		// return main loop
		form_driver(form1, REQ_VALIDATION);
		sprintf(prop, rtrim(field_buffer(field[0], 0)));
		write_conf(config);
		//return ch;
		break;
	    default:
		form_driver(form1, ch);
		break;
	wrefresh(volwin);
	}
    }
    unpost_form(form1);
    free_form(form1);
    free_field(field[0]);
/*    edit=derwin(volwin, 1, 24, 5, 3);
    wbkgd(edit, COLOR_PAIR(6));
    werase(edit);
    wrefresh(edit);
    ret=inbox(edit, prop);*/
    if (ch==27)
	ret=0;
    else
	ret=1;
    write_conf(config);
    return ret;
}

int main(int argc, char *argv[])
{
    char command[255];
    char buffer[80];
    FILE *fp;
    int fd[2], title_len, ret;
    char catfile[256];
    char cdname[25], category[25];
    
    /* Read config */
    mtrace();
    sprintf(homedir,"%.225s/.cdw",getenv("HOME"));
    mkdir(homedir,S_IRWXU);
    config=read_conf();

    setlocale(LC_ALL, "");
    textdomain(PACKAGE);
    bindtextdomain(PACKAGE, LOCALEDIR);

    
    title_len=strlen(PACKAGE)+2+strlen(VERSION)+9;
    TITLE=(char *)malloc(title_len);
    sprintf(TITLE, "::: %s-%s :::",PACKAGE, VERSION);
    
    if ( argc>1 ) {
//	printf(_("Usage: %s\n"),argv[0]);
#ifdef HAVE_LIBMYSQLCLIENT
	if ((strcmp((char *)argv[1], "--catalog")==0) || (strcmp((char *)argv[1], "-c")==0)){
	    initscr();
	    start_color();
	    cbreak();
	    noecho();
	    keypad(stdscr, TRUE);
	    // colors
	    init_curses_colors();
	    lines=LINES-2;
	    if ( ( LINES<24 ) || ( COLS<79 ) ) {
		endwin();
		printf(_("Needed min 80x25 terminal!"));
		exit(-1);
	    }
	    cddb_window();
	    endwin();
	    exit(0);
	}
#endif
#ifdef GTK_GUI
	if ((strcmp((char *)argv[1], "--gui")==0) || (strcmp((char *)argv[1], "-g")==0)){
	    gtk_gui(0, "");
	    exit(0);
	}
#endif
	if ((strcmp((char *)argv[1], "--version")==0) || (strcmp((char *)argv[1], "-v")==0)){
	    endwin();
	    printf("%s-%s (C) 2002-2003 Balazs Varkonyi\n\n", PACKAGE, VERSION);
	    exit(0);
	}
	if ((strcmp((char *)argv[1], "--help")==0) || (strcmp((char *)argv[1], "-h")==0)){
	    endwin();
	    printf(_("Usage: %s [options]\n\n"),argv[0]);
	    printf(_("Options:\n\n"));
#ifdef HAVE_LIBMYSQLCLIENT
	    printf(_("  --catalog | -c            : start in Disk Catalog mode\n"));
#endif
#ifdef GTK_GUI
	    printf(_("  --gui     | -g            : start cdw in GUI mode\n"));
#endif
	    printf(_("  --help    | -h            : show this screen\n"));
	    printf(_("  --version | -v            : show version\n\n"));
	    exit(0);
	}
	printf(_("%s: invalid option -- %s\n"),argv[0], argv[1]);
	printf(_("Try `%s --help`\n"),argv[0]);
	exit(0);
    }
    
    initscr();
    start_color();
    cbreak();
    noecho();
    keypad(stdscr, TRUE);

    // colors
    init_curses_colors();

    lines=LINES-2;
    if ( ( LINES<24 ) || ( COLS<79 ) ) {
	endwin();
	printf(_("Needed min 80x25 terminal!"));
	exit(-1);
    }
    put_mainform();
    select_window(TRUE);
    while ( (c=wgetch(mainwin))!='q' ){
	switch(c){
	    
	    // -------- HOT KEYS --------    
#ifdef HAVE_LIBMYSQLCLIENT
	    case 'c':
	    case 'C':
		// CDDB
		cddb_window();
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(FALSE);
		break;
#endif
#ifdef HAVE_LIBSQLITE
	    case 'c':
	    case 'C':
		// CDDB
		cddb_window();
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(FALSE);
		break;
#endif
	    case 'e':
	    case 'E':
		// eject tray
		eject_tray(config.cdrwdevice);
		break;
	    case 'g':
	    case 'G':
		// cdda2wav
		cdda2wav();
    		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
	    case KEY_F(1):
		// Show readme
		//sprintf(command, "%s/README.gz", DOCDIR);
		//log_window(_("Help"), command, 1);
		show_help_main();
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
	    case KEY_F(2):
		// Edit volume ID
		input_volume(_("Volume ID"), _("Enter volume label:"), config.volumeid);
    		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
	    case KEY_F(3):
		// Edit other parameters
		input_volume(_("CD record parameters"), _("Enter parameter:"), config.other);
    		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
	    case KEY_F(4):
		// CD size select
		size_selector();
    		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
	    case 'L':
	    case 'l':
	    case KEY_F(5):
		// Show last log
		log_window(_("Last log"), config.logfile, 0);
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
	    case KEY_F(6):
		// Show CD info
		sprintf(command,"%s dev=%s -atip", CDRECORD, config.scsi);
		run_command(command,_("Load CD info..."), 0, 0, 0, "");
		log_window(_("CD info"), config.logfile, 0);
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
/*	    case KEY_F(9):
		dialogbox("This is a sample message. Show in a simple\ndialog box\n\nOk?", "Dialog box", 3);
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;*/

	    case KEY_F(10):
		// Show GPL
		sprintf(command, "%s/LICENSE", DOCDIR);
		log_window(_("License"), command, 1);
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
#ifdef HAVE_LIBMYSQLCLIENT
	    case 'A':
	    case 'a':
		// Add disk to dic database
		add_to_dic();
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
#endif
#ifdef HAVE_LIBSQLITE
	    case 'A':
	    case 'a':
		// Add disk to dic database
		add_to_dic();
		wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		select_window(TRUE);
		break;
#endif
	    // -------- MENU --------

	    case KEY_HOME:
		menu_driver(menu, REQ_FIRST_ITEM);
		break;
	    case KEY_END:
		menu_driver(menu, REQ_LAST_ITEM);
		break;
	    case KEY_DOWN:
		menu_driver(menu, REQ_DOWN_ITEM);
		break;
	    case KEY_UP:
		menu_driver(menu, REQ_UP_ITEM);
		break;
	    case 10:
		// Add files
		if ( item_index(current_item(menu)) == 0 ){
		    put_addwin(getmaxy(mainwin)-10,getmaxx(mainwin)-10,(LINES-(getmaxy(mainwin)-10))/2,(COLS-(getmaxx(mainwin)-10))/2);
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(TRUE);
		}
		// Delete files
		if ( item_index(current_item(menu)) == 1 ){
		    // If cd files not empty!
		    if ( num>0 ) {
			set_menu_fore(cdmenu, COLOR_PAIR(1) | A_REVERSE);
			set_menu_fore(menu, COLOR_PAIR(4));
			wrefresh(mainwin);
			delete_files();
			set_menu_fore(cdmenu, COLOR_PAIR(1));
			set_menu_fore(menu, COLOR_PAIR(4) | A_REVERSE);
		    }
		}
		// Create image
		if ( (item_index(current_item(menu)) == 2) && (num>0) ){
		    int ret=1;
		    FILE *isofile;
		    
		    if ( strcmp(config.showvol,"1")==0 ){
			ret=input_volume(_("Volume ID"), _("Enter volume label:"), config.volumeid);
    			wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			select_window(TRUE);
		    }
		    if (ret==1) {
			int exist=0;
			int boot_exists=1;
			
			sprintf(command,"%s -f", MKISOFS);
			if ( strcmp(config.joliet, "1")==0 ) {
			    strcat(command," -J");
			}
			if ( strcmp(config.rockridge, "1")==0 ) {
			    strcat(command," -r");
			}
			if ( strlen(config.bootimg) ) {
			    char bootimage[255];
			    
			    sprintf(bootimage, "%s/.cdw/%s", getenv("HOME"), config.bootimg);
			    if ( (isofile=fopen(bootimage, "r"))==NULL ){
			        boot_exists=dialogbox(_("Boot image doesn'n exists!"), _("Boot image error"), 0);
			        boot_exists=0;
				wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
				select_window(FALSE);
			        break;
			    }
			    if (boot_exists) {
				fclose(isofile);
				sprintf(command,"%s -b %s -c boot.catalog -no-emul-boot", command, config.bootimg);
			    }
			}
			if ( strlen(config.volumeid) == 0){
			    strcpy(config.volumeid, "cdrom");
			}
			sprintf(command,"%s -V\"%s\" -o %s %s", command, config.volumeid, config.tempdir, homedir);
			if ( (isofile=fopen(config.tempdir, "r"))!=NULL ){
			   exist=dialogbox(_("Image file exist!\nDo you wish to overwrite it?"), _("Image exist"), 3);
		  	   fclose(isofile);
			}
			if ((exist==0) && (boot_exists))
			   run_command(command,_("Create image"), 0, 1, 1, "");
		    }
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(FALSE);
		}
		// Copy image
		if ( (item_index(current_item(menu)) == 3) ){
		    int exist=0;
		    FILE *isofile;
		    
		    if ( (isofile=fopen(config.tempdir, "r"))!=NULL ){
		       exist=dialogbox(_("Image file exist!\nDo you wish to overwrite it?"), _("Image exist"), 3);
		       fclose(isofile);
		    }
		    if (exist==0)
	               copy_image(_("Copy CD image"));
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(FALSE);
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(FALSE);
		}
		// Write image
		if ( (item_index(current_item(menu)) == 4) && (access(config.tempdir, R_OK)!=-1) && ( strcmp(config.fromimage, "1")==0 ) ){
		    sprintf(command,"%s -v speed=%s dev=%s %s",CDRECORD,config.speed,config.scsi,config.other);
		    if ( strcmp(config.dao, "1")==0 ){
			strcat(command, " -dao");
		    }
		    if ( strcmp(config.dummy, "1")==0 ){
			strcat(command, " -dummy");
		    }
		    if ( strcmp(config.burnproof, "1")==0 ){
			strcat(command, " -driveropts=burnproof");
		    }
		    sprintf(command,"%s -data %s",command, config.tempdir);
		    run_command(command, _("Write image"), 0, 1, 1, "");
		    after_event("Write image log", 1);
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(FALSE);
		}
		// Write direct
		if ( (item_index(current_item(menu)) == 4) && ( strcmp(config.fromimage, "0")==0 )){
		    int ismulti=0, ret=1;
		    char tsizecmd[255];
		    char mkisofscmd[255];
		    if ( strcmp(config.showvol,"1")==0 ){
			ret=input_volume("Volume ID", "Enter volume label:", config.volumeid);
    			wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			select_window(TRUE);
		    }
		    if (ret==1) {
			FILE *isofile;
			int boot_exists=1;
			
			sprintf(command,"%s -f", MKISOFS);
			if ( strcmp(config.joliet, "1")==0 ) {
			    strcat(command," -J");
			}
			if ( strcmp(config.rockridge, "1")==0 ) {
			    strcat(command," -R");
			}
			if ( strcmp(config.usefulRR, "1")==0 ) {
			    strcat(command," -r");
			}
			if ( strlen(config.bootimg) ) {
			    char bootimage[255];
			    
			    sprintf(bootimage, "%s/.cdw/%s", getenv("HOME"), config.bootimg);
			    if ( (isofile=fopen(bootimage, "r"))==NULL ){
			        boot_exists=dialogbox(_("Boot image doesn'n exists!"), _("Boot image error"), 0);
			        boot_exists=0;
				wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
				select_window(FALSE);
			        break;
			    }
			    if (boot_exists) {
				fclose(isofile);
				sprintf(command,"%s -b %s -c boot.catalog -no-emul-boot", command, config.bootimg);
			    }
			}
			if ( strcmp(config.multi, "1")==0 ) {
			    char msinfo[255];
			    char *line;
			    int track_start=0, track_end=0;
			    sprintf(msinfo,"%s dev=%s -msinfo", CDRECORD, config.scsi);
			    run_command(msinfo, _("Load CD info..."), 0, 0, 0, "");
			    if ( (fp=fopen(config.logfile,"r"))==NULL){
				endwin();
				fprintf(stderr, _("Cannot open file..."));
				exit(-1);
			    }
			    line=(char *)malloc(1024);
			
			    while ( (line=fgets(line, 256, fp))!=NULL){
				if ( sscanf(line, "%d,%d", &track_start, &track_end) == 2 ){
				    wrefresh(mainwin);
				    ismulti=1;
				}
			    }
			    if (ismulti==1) {
				sprintf(command,"%s -C %d,%d -M %s",command, track_start, track_end, config.cdrwdevice);
			    }
			    fclose(fp);
			    free(line);
			}
			if ( strlen(config.volumeid) == 0){
			    strcpy(config.volumeid, "cdrom");
			}
			sprintf(tsizecmd, "tsize=`%s -print-size -quiet %s`", command, homedir);
			sprintf(mkisofscmd,"%s; %s -V\"%s\" %s", tsizecmd, command, config.volumeid, homedir);
			sprintf(command,"%s | %s -v speed=%s dev=%s -tsize=${tsize}s %s", mkisofscmd, CDRECORD, config.speed,config.scsi,config.other);
			if ( strcmp(config.dao, "1")==0 ){
			    strcat(command, " -dao");
			}
			if ( strcmp(config.dummy, "1")==0 ){
			    strcat(command, " -dummy");
			}
			if ( strcmp(config.multi, "1")==0){
			    strcat(command, " -multi");
			}
			if ( strcmp(config.burnproof, "1")==0 ){
			    strcat(command, " -driveropts=burnproof");
			}
			sprintf(command,"%s -",command);
			wrefresh(mainwin);
			run_command(command, _("Write direct"), size, 1, 1, "");
			after_event("Write direct log", 1);
		    }
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(FALSE);
		}
		// Write Audio
		if ( (item_index(current_item(menu)) == 5) ){
		    int ret=1;
		    if ( strcmp(config.showvol,"1")==0 ){
			ret=input_volume("Volume ID", "Enter volume label:", config.volumeid);
    			wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			select_window(TRUE);
		    }
		    if (ret==1) {
			sprintf(command,"%s -v speed=%s dev=%s -audio",CDRECORD,config.speed,config.scsi);
			if ( strcmp(config.pad, "1")==0 ){
			    strcat(command, " -pad");
			}
			if ( strcmp(config.dao, "1")==0 ){
			    strcat(command, " -dao");
			}
			if ( strcmp(config.dummy, "1")==0 ){
			    strcat(command, " -dummy");
			}
			if ( strcmp(config.burnproof, "1")==0 ){
			    strcat(command, " -driveropts=burnproof");
			}
			sprintf(command,"%s %s/*.wav",command,homedir);
			run_command(command, _("Write audio"), size, 1, 1, "");
			after_event("Write audio log", 1);
		    }
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(FALSE);
		}
		// Copy data CD
		if ( (item_index(current_item(menu)) == 6) && (config.cdrom!=config.cdrwdevice) ){
		    int in_fd;
		    if ( (in_fd = open("/dev/cdrom", O_RDONLY)) != -1 ){
			close(in_fd);
			sprintf(command,"%s -v speed=%s dev=%s %s",CDRECORD,config.speed,config.scsi,config.other);
			if ( strcmp(config.eject, "1")==0 ){
			    strcat(command, " -eject");
			}
			if ( strcmp(config.dummy, "1")==0 ){
			    strcat(command, " -dummy");
			}
			sprintf(command,"%s -isosize %s",command, config.cdrom);
			run_command(command, _("Copy data CD"), 0, 1, 1, "");
			after_event("Copy data CD log", 1);
			wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
			select_window(FALSE);
		    } 
		}
		// Blank CD-RW
		if ( item_index(current_item(menu)) == 7){
		    sprintf(command,"%s -v speed=%s dev=%s blank=%s",CDRECORD,config.speed,config.scsi,config.blank);
		    run_command(command,_("Blank CD-RW"), 0, 1, 0, "");
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(FALSE);
		}
		// Options
		if ( item_index(current_item(menu)) == 8){
		    options_window();
		    config=read_conf();
		    wrefresh(derwin(mainwin,LINES-1,COLS-1,0,0));    
		    select_window(FALSE);
		    fill_info();
		}
		// Quit
		if ( item_index(current_item(menu)) == 9){
		    endwin();
		    exit(1);
		}
		break;
	}
	wrefresh(mainwin);
    }
    free(TITLE);
    unpost_menu(menu);
    free_menu(menu);
    for(i = 0; i < choices; ++i)
        free_item(items[i]);
    endwin();
    return 1;
}
