(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

module U = Encodings.Utf8

module Id = Pool.Weak(Ns.QName)
type id = Id.t
let ident = Id.mk
let value = Id.value
let to_string id = Ns.QName.to_string (Id.value id)
let print ppf id = Ns.QName.print ppf (Id.value id)

module IdSet = SortedList.Make(Id)
module IdMap = IdSet.Map
module Env = Map.Make(Id)
type 'a id_map = 'a IdMap.map
type fv = IdSet.t



module Label = Ns.QName

module LabelPool = Pool.Make(Label)
module LabelSet = SortedList.Make(LabelPool)
module LabelMap = LabelSet.Map

type label = LabelPool.t
type 'a label_map = 'a LabelMap.map
