(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

let has_ext = ref false

let has () = !has_ext

let register = 
  ref (fun _ _ _ -> 
	 Location.raise_generic "No built-in support for ocaml externals")

let resolve s args =
  has_ext := true;
  !register true s args

let typ s args =
  snd (!register false s args)


