(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

exception InconsistentCrc of Types.CompUnit.t
exception Loop of Types.CompUnit.t
exception InvalidObject of string
exception CannotOpen of string
exception NoImplementation of Types.CompUnit.t

val obj_path: string list ref

val compile: bool -> string -> Types.CompUnit.t -> string -> unit
val run: Types.CompUnit.t -> unit
val import: Types.CompUnit.t -> unit
val import_check: Types.CompUnit.t -> Digest.t -> unit
val import_from_string: Types.CompUnit.t -> string -> string -> (Ident.U.t * Digest.t) list -> unit

val register_unit: string -> string -> string -> (string * string) list -> Types.CompUnit.t
val load_unit: string -> string -> Types.CompUnit.t


val import_and_run: Types.CompUnit.t -> unit
val save: string -> Types.CompUnit.t -> string -> unit

val registered_types: Types.CompUnit.t -> Types.t array

val set_externals: Types.CompUnit.t -> Value.t array -> unit


type stub_ml
val stub_ml : (string -> Typer.t -> Compile.env -> 
		 stub_ml option * Types.t array) ref

val register_static_external: string -> Value.t -> unit
val get_builtins: unit -> string list
