/*
cdcd - Command Driven CD player
Copyright (C) 1998-99 Tony Arcieri
Copyright (C) 2001 Fabrice BAUZAC

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef STR_H
#define STR_H

#include <stdarg.h>

/* TODO: We could explain how the functions work in .h's too.  */

int strnlower (char *dest, const char *src, int len);
int strncasestr (const char *haystack, int haystacklen,
		 const char *needle, int needlelen);
const char *strcasestr (const char *haystack, const char *needle);

struct pprintfd {
  int col;    /* Cursor column.  */
  int liad;   /* Predicate: last is a dot?  */
};

/*

  These printf-like functions do word breaking.  MAXCOL is the column
  number at which the cursor can go at most (e.g. for 80-columns
  displays, it should be 79 (*)).  PPD is the current status: cursor
  position, and whether the last word terminated with a '.' (this is
  important in order to put an extra space after the end of a
  sentence).  FMT is the usual format string.

  (*) If the cursor went to position 80, thus after having written 80
  characters on the line, the cursor would jump to the next line,
  desyncronizing from pprintf's idea of the cursor position.

*/

void pprintf (int maxcol, char *fmt, ...);
void vpprintf (int maxcol, char *fmt, va_list v);
void pdprintf (int maxcol, struct pprintfd *ppd, char *fmt, ...);
void vpdprintf (int maxcol, struct pprintfd *ppd, char *fmt, va_list v);

char **cv2v0 (int argc, char **argv);
void freev0 (char **v);
char **my_tokenize (char *s);
char *quote_armor (char *s, char q);
char *unquote_armor (char *s);
char **unquote_params (char **argv);

#endif /* STR_H */
