/***************************************************************************
                          FakeFoldersListView.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef FAKEFOLDERSLISTVIEW_H
#define FAKEFOLDERSLISTVIEW_H

#include <klistview.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qdragobject.h>
#include <kio/job.h>

#include "FakeFolderItem.h"
#include "../EstimatePnl.h"

class QPopupMenu;
class QPainter;
class QDropEvent;
class QDragEnterEvent;
class QPoint;
class QStringList;
class QProgressDialog;
class KConfig;
//class FakeFolderItem;
class FakeFilesListView;

typedef QDict<FakeFolderItem> SourceAndPositionMap;

class FakeFoldersListView : public KListView  {
	Q_OBJECT
public:
	FakeFoldersListView(QWidget *parent, const char *name);
	~FakeFoldersListView();
	
	int shouldOverwrite(QString name);
	int shouldOverwriteDir(QString name);
	QString getPathToTop(FakeFolderItem *item);
	inline unsigned long getTotalSize(){ return top->getSize(); }
	
	inline void setFakeListView(FakeFilesListView * f){fakeListView = f;}
	inline void setPointForDrop(QPoint p) { pointForDrop = p; }
	void setEstimate(EstimatePnl *e);
	
	bool checkChildNameClash(QString fileName, bool *cancel);
	bool canFit(int size, QString fname);
	
	QString* generateMappingsString();
	bool persist(KConfig *file);
	bool loadFile(KConfig *file);
	
public slots:	
	void slotProperties();
	void slotShowHidden();
	
	void slotMenu(QListViewItem *, const QPoint &, int);
	void slotSelectFile   (QListViewItem *);
	void slotSelectFileConst(QListViewItem *);
	void setParentForDrop(QListViewItem *);
	inline void setDragedItem(QListViewItem * item) { dragedItem = (FakeFolderItem *)item; }
	
	bool addOneItem(QString);
	bool addMultipleItems(QString);
	bool addMultipleItems(QStringList);
	void updateSettings();
	
	void addNewFolder();
	bool remove();
	void removeAll();
	void resetSize();
	
	void longProcessCanceled(QString);
	bool moveItemsSlot();
	bool copyItemsSlot();
	
	void loadSession();
	inline void setMultiple(bool m = true){multiple = m;}

signals:
	void folderClicked(FakeFolderItem *);
	
	void processStarted();
	void processDone();
	void haveStatus(const QString &);
	void longProcessStarted(KIO::Job *);
	void longProcessDone(KIO::Job *);
	
	void changingSize(bool);
	void popUpSettings(int type);
	
	void modified();
	
protected:
	virtual bool acceptDrag (QDropEvent* event) const;
	virtual void contentsDragEnterEvent(QDragEnterEvent *);
	virtual void contentsDragLeaveEvent(QDragLeaveEvent *);
	virtual QRect drawDropVisualizer (QPainter *, QListViewItem *, QListViewItem *);
	bool addItem(QString);
	bool canAccept(QString path);
	
	bool isParentOf(QListViewItem *i1, QListViewItem *i2);
	
	bool readRow(FakeFolderItem *item);
	bool copyRow(FakeFolderItem *item, FakeFolderItem *parent);
	bool persistRow(FakeFolderItem *item, KConfig *file);
	bool loadRow(FakeFolderItem *item, KConfig *file, QStringList *list);
	
	QStringList fileList;
	
protected slots:
	void dropOcurred(QDropEvent * , QListViewItem *);
	void slotEntries( KIO::Job * , const KIO::UDSEntryList & );
	void slotResult( KIO::Job *);
	void slotMountResult( KIO::Job *);
	void slotUMountResult( KIO::Job *);
	
	void compilSettingsSlot();
	
	virtual void keyPressEvent(QKeyEvent *e);
	virtual QDragObject *dragObject() const;
	virtual void startDrag();
	
	void currentModifiedSlot();
	void loadSession(QString drive);
	void importSession(QString);
	void detectAndTryToLoadSlot();
	
private:
	bool doListern;
	KConfig *config;
	
	QPopupMenu *folderMenu;
	QPopupMenu *copyMenu;
	
	//QDict <FakeFolderItem>dirAndPosMap;
	
	QDict <SourceAndPositionMap>dicts;
	
	QPoint pointForDrop;
	QProgressDialog *progress;
	
	FakeFolderItem *top;
	FakeFolderItem *parentForDrop;
	FakeFolderItem *dragedItem;
	//QStringList fileMapings;
	EstimatePnl *estimate;
	FakeFilesListView *fakeListView;
	
	bool showHidden;
	int indexOfTop;
	
	int propertiesIndex;
	int removeIndex;	
	bool loadingSession;
	bool remTDir;
	QString mappingsString;
	bool multiple;
	
};

#endif