/***************************************************************************
                          EstimatePnl.h  -  description
                             -------------------
    begin                : Fri Jul 27 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef ESTIMATEPNL_H
#define ESTIMATEPNL_H

#include <qvariant.h>
#include <qwidget.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QComboBox;
class QGroupBox;
class QLCDNumber;
class QLabel;
class QPushButton;

class KConfig;

class EstimatePnl : public QWidget{
    Q_OBJECT

public:
    EstimatePnl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~EstimatePnl();
	void saveOptions();
	
	bool add(int);
	void subtract(int);
	void reset();
	
	inline int getTotal() { return total;}
	
	inline QPushButton* getRecalculateBtn() { return recalcEstBtn; }

signals:
	void recalculate();
	
protected slots:
    void capacityChangedSlot(int);

    void synchUp();
    void usedTypeChangedSlot(int);
    void wastedTypeChangedSlot(int);

protected:
		
	void readOptions();
	
	QGroupBox* estFrm;
     QGroupBox* GroupBox5;
     QComboBox* capacityCmb;
     QLabel* capacityLbl;
     QGroupBox* GroupBox2_2_2;
     QLCDNumber* usedLCD;
     QComboBox* usedTypeCmb;
     QGroupBox* GroupBox2_2;
     QLCDNumber* wastedLCD;
     QComboBox* wastedTypeCmb;
     QPushButton* recalcEstBtn;

     QGridLayout* EstimatePnlLayout;
     QVBoxLayout* estFrmLayout;
     QHBoxLayout* GroupBox5Layout;
     QHBoxLayout* GroupBox2_2_2Layout;
     QHBoxLayout* GroupBox2_2Layout;
     bool event( QEvent* );

 private:
 	KConfig *config;
 	int total;
 	
 	bool usedMB;
 	int wasted;
 	
 	bool wastedMB;
 	int max;
};

#endif // ESTIMATEPNL_H
