/***************************************************************************
                          CommandOutputDialog.cpp  -  description
                             -------------------
    begin                : Fri Jun 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//#include <iostream.h>

#include <qapp.h>
#include <qframe.h>
#include <qheader.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qpopupmenu.h>
#include <qtextview.h>
#include <qstringlist.h>
#include <qtextstream.h>
#include <qdir.h>
#include <qfile.h>

#include <klistview.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kiconloader.h>

#include "CommandOutputDialog.h"


CommandOutputDialog::CommandOutputDialog( QWidget* parent,  const char* name, bool modal)
    : QDialog( parent, name, modal ){
	if ( !name )
		setName( "CommandOutputDialog" );
	resize( 501, 421 );

	layout = new QVBoxLayout( this );
     layout->setSpacing( 6 );
     layout->setMargin( 11 );

     outputView = new KListView( this, "outputView" );
     //outputView->setRootIsDecorated( true );
	outputView->header()->hide();
	
     outputView->setLineWidth( 2 );
     outputView->addColumn( tr( "Name" ) );
     layout->addWidget( outputView );

       line = new QFrame( this, "line" );
       line->setFrameStyle( QFrame::HLine | QFrame::Sunken );
       layout->addWidget( line );

       closeBtn = new QPushButton( this, "closeBtn" );
       closeBtn->setText( tr( "&Close" ) );
       QToolTip::add(  closeBtn, tr( "Close this dialog." ) );
       layout->addWidget( closeBtn );

	menu = new QPopupMenu();
	menu -> insertItem(BarIcon("txt"), i18n("Dump this info to a file"),this ,SLOT(dumpSlot()));

	//fileMenu -> insertItem( BarIcon("reload"), i18n("Reload Directory"),   this ,SLOT(slotReload()));


	connect( outputView, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)),
					 this, SLOT(popupMenuSlot(QListViewItem*, const QPoint&, int)));

       connect( closeBtn, SIGNAL( clicked() ), this, SLOT( quitSlot() ) );
}
//===================================================
CommandOutputDialog::~CommandOutputDialog(){
}
//----------------------------------------------------------------------------------------------
void CommandOutputDialog::append(QString message){
	//cerr <<"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^" << endl;
	///cerr << message << endl;
	//cerr <<"^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^" << endl;
	QStringList list = QStringList::split("\n", message);
	
	QListViewItem *item;
	QString buff;
	for(int  i = 0; i < (int)list.count(); i++){
		//cerr <<"===================================================" << endl;
		//cerr << list[i] << endl;
		//cerr <<"===================================================" << endl;
		buff = list[i].simplifyWhiteSpace();
		item = new QListViewItem(outputView, outputView->lastChild());
		
		item->setText(0," " + buff);
	}

}
//==============================================================
void CommandOutputDialog::popupMenuSlot(QListViewItem *, const QPoint &point, int){
	menu->popup( point);
}
//===========================================================
void CommandOutputDialog::dumpSlot(){
	if(!outputView->firstChild())
		return;
    QString fileToOpen = KFileDialog::getSaveFileName(QDir::homeDirPath(),
				"*|All files",
				this,
				"Save Process Output As...");
	if(!fileToOpen || fileToOpen == "")
		return;
	QFile file(fileToOpen);
	
	if(file.exists())
		file.remove();
	if(!file.open(IO_ReadWrite))
		return;
		
	QTextStream stream(&file);
	for(QListViewItem *i = outputView->firstChild(); i; i = i->nextSibling()){
		stream << i->text(0);
		stream << "\n";
	}
	file.close();
}
//============================================================
void CommandOutputDialog::quitSlot(){
	accept();
}