/***************************************************************************
                          PreviewDialog.cpp  -  description
                             -------------------
    begin                : Fri Jun 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef PREVIEWDIALOG_H
#define PREVIEWDIALOG_H

#include <qvariant.h>
#include <qdialog.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QFrame;
class QListViewItem;
class QPushButton;
class QKeyEvent;
class QPopupMenu;

class KConfig;
class KListView;

class FolderItem;
class KShellProcess;
class KProcess;



class PreviewDialog : public QDialog{
    Q_OBJECT

public:
    	PreviewDialog( QWidget* parent = 0, const char* name = 0, bool modal = true, WFlags fl = 0 );
    	~PreviewDialog();
	
    	bool open(QString location, bool image = false);

protected slots:
	void slotSelectItem(QListViewItem *);
	void slotShowHidden();
	void slotProperties();
	void openWithSlot();
	void quitSlot();
	void popupMenuSlot(QListViewItem *, const QPoint &, int);
	void mounted(KProcess *);
	void unMounted(KProcess *);
	
	virtual void closeEvent(QCloseEvent *e);
	virtual void keyPressEvent(QKeyEvent *e);
    	
private:
	QString currentItemPath();
	
	KConfig *config;
	FolderItem *top;
	
	int hiddenFIndex;
	bool showHidden;
	
	 KShellProcess *cdboProc;
	QString mountPoint;
	bool umount;
	bool remTDir;
	
	QPopupMenu *folderMenu;
	QPopupMenu *fileMenu;
	
	QVBoxLayout* layout;
	KListView* filesView;
	QFrame* line;
	QPushButton* closeBtn;

};

#endif // PREVIEWDIALOG_H
