/***************************************************************************
                          CdboDialogBase.h  -  description
                             -------------------
    begin                : Tue Jul 17 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CDBODIALOGBASE_H
#define CDBODIALOGBASE_H

#include <qobject.h>


class CdboDialogBase{
public:
    CdboDialogBase(int t){ type = t;  }
	~CdboDialogBase(){}
	
	inline int getType(){ return type; }
	

	//pure virtuals
	virtual void blockBtns(bool) const = 0;
	virtual void output(int, QString) const = 0;
	virtual void status(QString) const = 0;
	
	virtual QString getScsiDevice() const = 0;
	virtual QString getSpeed() const = 0;
	virtual QString getActionType() const = 0;
	
	// constants
	
	static const int None = -1;
	
	static const int CdCopyDialogType = 0;
    	static const int NewCdDialogType  = 1;
    	static const int MusicDialogType = 2;
     static const int EraseDialogType = 3;
     static const int SettingsDialogType = 4;
     static const int NewAudioCdDialogType = 5;

	static const int ErrorMessage = 0;
    	static const int ProcessMessage  = 1;
    	static const int InfoMessage = 2;
     static const int StatusOkMessage = 3;
     static const int StatusNotOkMessage = 4;

//protected:
	//inline void setType(int t) {type = t; }
	
private:
	int type;

};
#endif
