/***************************************************************************
                          NewAdvancedCdCompilationView.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* QT includes */
#include <qpainter.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qgrid.h>
#include <qevent.h>
#include <qdir.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>

/* KDE includes */
#include <kcontainer.h>
#include <kmainwindow.h>
#include <kprogress.h>
#include <kio/job.h>
#include <kio/jobclasses.h>

/* cdbakeoven includes */
#include "NewAdvancedCdCompilationView.h"
#include "CdboCompilationView.h"
#include "cdbakeoven.h"

#include "widgets/TargetTreeCntPanel.h"
#include "widgets/EstimatePnl.h"
#include "widgets/ExpandPnl.h"
#include "widgets/fileViews/AdvancedCompilationTreeView.h"

NewAdvancedCdCompilationView::NewAdvancedCdCompilationView(CDBakeOvenApp * cdboApp, QWidget *parent, const char *name) :
			CdboCompilationView(cdboApp, parent, name){
	
	this->cdboApp = cdboApp;
	initView();
}

NewAdvancedCdCompilationView::~NewAdvancedCdCompilationView(){
}

void NewAdvancedCdCompilationView::initView(){

// -------------------- TargetTreeCntPanel ------------------------
	targetCnt = new TargetTreeCntPanel(this, "targetCnt", false);
	targetCnt->resize(10,10);

// --------------------  CompilationTreeView ------------------------
	compilView = new AdvancedCompilationTreeView(cdboApp, this, "compilView");
  	compilView ->setFocusPolicy(QWidget::ClickFocus);

// --------------------  EstimatePnl ------------------------
  	
  	estimateHldr = new ExpandPnl(this, "estimateHldr");
  	estimate = new EstimatePnl(estimateHldr,"estimate" );
  	
  	estimateHldr->addCustomWidget(estimate);
  	compilView->setEstimate(estimate);
  	
  	
  	
//=============== SLOTS & SIGNALS =====================================
	
						
	
						
//////////////////////INNER//////////////////////////
						
	
	connect( targetCnt->getShowPropBtn(), SIGNAL(clicked()),
						getView(), SLOT(slotProperties()) );
	connect( targetCnt->getReloadBtn(), SIGNAL(clicked()),
						compilView, SLOT(loadSession()) );
	connect( targetCnt->getDeleteNodeBtn(), SIGNAL(clicked()),
						getView(), SLOT(remove()) );
	connect( targetCnt->getIsoPropBtn(), SIGNAL(clicked()),
						getView(), SLOT(compilSettingsSlot()) );
						
	/*connect( targetCnt->getCollapseTrgBtn(), SIGNAL(clicked()),
						getView(), SLOT(collapse()) );*/
	connect( targetCnt->getBurnBtn(), SIGNAL(clicked()),
						compilView, SLOT(createCD()) );
	connect( targetCnt->getCreateImgBtn(), SIGNAL(clicked()),
						compilView, SLOT(createISO()) );
						
						
			
	/*connect(getView(), SIGNAL(changingSize(bool)),
						estimateHldr, SLOT(expandSlot(bool)));*/
}
//==============================
void NewAdvancedCdCompilationView::saveOptions(){
	estimate->saveOptions();
	estimateHldr->saveOptions();
}
//==============================
void NewAdvancedCdCompilationView::showTargetControl(bool doShow){
	if(!doShow)
		targetCnt->hide();
	else
		targetCnt->show();
}
//==============================
void NewAdvancedCdCompilationView::showEstimate(bool doShow){

	if(!doShow)
		estimateHldr->hide();
	else
		estimateHldr->show();
}
