/*
   Copyright (C) 1999 J.H.M. Dassen (Ray) <jdassen@wi.LeidenUniv.nl>
   Copyright (C) 1999 Antti-Juhani Kaijanaho <gaia@iki.fi>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include "util.h"

int msglevel = 0; /* the higher, the more messages... */
int suppress_warnings = 0; /* flag */
int num_warnings = 0; /* count */

void warning(char *format, ...)
{
	va_list args;

        ++num_warnings;

        va_start(args, format);
        if (!suppress_warnings) vfprintf(stderr, format, args);
        va_end(args);
}

void panic(char *format, ...)
{
	va_list args;

        va_start(args, format);
        vfprintf(stderr, format, args);
        va_end(args);
	exit(EXIT_FAILURE);
}

#if defined(NDEBUG) && defined(__GNUC__)
/* Nothing. pmesg has been "defined away" in util.h already. */
#else
void eassert(int expr, char *format, ...) {
#ifdef NDEBUG
	/* Empty body, so a good compiler will optimise calls away */
#else
	va_list args;

	if (!expr) {
		va_start(args, format);
		vfprintf(stderr, format, args);
		va_end(args);
		exit(EXIT_FAILURE);
	}
#endif /* NDEBUG */
}
#endif /* NDEBUG && __GNUC__ */


#if defined(NDEBUG) && defined(__GNUC__)
/* Nothing. pmesg has been "defined away" in util.h already. */
#else
void pmesg(int level, char* format, ...) {
#ifdef NDEBUG
	/* Empty body, so a good compiler will optimise calls
	   to pmesg away */
#else
        va_list args;

        if (level>msglevel)
                return;

        va_start(args, format);
        vfprintf(stderr, format, args);
        va_end(args);
#endif /* NDEBUG */
#endif /* NDEBUG && __GNUC__ */
}

void strupcase(char * s)
{
        register char * p;

        for (p = s; *p !=0; ++p) {
                *p = islower(*p) ?
                        toupper(*p) :
                        *p;
        }
}

char * strupcasedup(char const * s)
{
    char * su;

    su = malloc(strlen(s) + 1);
    if (su == NULL) return NULL;
    strcpy(su, s);
    	/* We don't use strdup because it's not part of ISO C. */
    strupcase(su);
    
    return su;
}

int patmatch(char const * pat, char const * s)
{
    for( ; *pat != 0; ++pat, ++s) {
	switch(*pat) {
    	    case '*':
		++pat;
		if(*pat == 0) return 1;
	    	    /* speedup in frequent case that pattern ends with '*' */
		do {
	    	    if(patmatch(pat, s)) return 1;
		} while(*s++ != 0);
		return 0;
	    case '?':
		if(*s == 0) return 0;
		break;
#if 0
    	    /* Possibly useful extension: '+' matches 0 or 1 characters.
	     * Or even interchange '+', '?' ? Disabeled for now.
	     */
	    case '+':
	    	++pat;
	    	return ((*s != 0) && patmatch(pat, s+1)) || patmatch(pat, s);
#endif
	    case '#':
		if(!isdigit(*s)) return 0;
		break;
#if 0
    	    /* Possibly useful extension: '\\' protects next char from
	     * wildcard interpretation. Disabeled for now.
	     */
	    case '\\':
	    	++pat;
		assert(*pat != 0);
		/* fall through to default */
#endif
	    default:
		if(*pat != *s) return 0;
	    	    /* this covers premature end of s, too */
	} /* switch */
    } /* for */
    return (*s == 0);
}
