#ifndef VIDEODEVICEINPUT_HPP
#define VIDEODEVICEINPUT_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qobject.h>
#include <qvector.h>

#include <linux/videodev.h>

#include "VideoDeviceTuner.h"

class CVideoDeviceLinux;

class CVideoDeviceInput: public QObject
{
   Q_OBJECT
private:
   struct video_channel m_VChan;

   CVideoDeviceLinux *m_pVideo;
   QVector<CVideoDeviceTuner> m_Tuners;
   int m_CurrentTuner;

   QString m_Name;
   int m_Type;
   int m_Flags;

private slots:
   void VideoTunerSwitched(int);

public:
   enum {
     Unknown,
     TV,
     Camera
   } InputTypes;

   CVideoDeviceInput(CVideoDeviceLinux *video, int channel);

   int GetNumber() const;
   QString GetName() const;
   int GetType() const;
   bool HasAudio() const;

   bool Select();

   int GetNumberOfTuners() const;
   CVideoDeviceTuner *GetTuner(int number = -1) const;
   int GetCurrentTuner() const;

signals:
   void Selected(int);
};


#endif
