/* Slightly more intelligent configuration dialog */

#include <qlineedit.h>
#include <qbutton.h>
#include <qbuttongroup.h>
#include <qcolordialog.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qfontdialog.h>
#include <qspinbox.h>

#include "SnapshotSettingsDlg.h"
#include "CamStreamApp.h"

CSnapshotSettingsDlg::CSnapshotSettingsDlg(struct CVideoOptions *opts, QWidget *parent, const char *name)
	: CSnapshotSettings(parent, name)
{
   int i, m, mask, set;
   QString fm;

qDebug("CSnapshotSettingsDlg::CSnapshotSettingsDlg(...)");
   pVOpts = opts;
   BaseNameLineEdit->setText(pVOpts->GetBaseName());
   TextColor = pVOpts->GetTextColor();
   TextFont = pVOpts->GetTextFont();
   TimestampImage->setChecked(pVOpts->GetTimeInImage());
   FileFormat = pVOpts->GetFileFormat();
   SaveToDisk->setChecked(pVOpts->GetSaveToDisk());
   FTPToServer->setChecked(pVOpts->GetFTPToServer());
   switch(pVOpts->GetMiddlePart())
   {
     case CVideoOptions::Overwrite:    NameMiddleGroupBox->setButton(1); break;
     case CVideoOptions::Timestamp:    NameMiddleGroupBox->setButton(2); break;
     case CVideoOptions::Sequence:     NameMiddleGroupBox->setButton(3); break;
   }
   MaxSequence->setValue(pVOpts->GetMaxSequence());
   RunCommandCheckBox->setChecked(pVOpts->GetRunCommand());
   CommandLineEdit->setText(pVOpts->GetCommand());
   YourMessageLineEdit->setText(pVOpts->GetUserMessage());

   m = g_pCamApp->GetNumberOfFileTypes();
   mask = g_pCamApp->GetFileTypeMask();
//qDebug("Mask = 0x%02x", mask);
   set = -1;
   /* Loop through the file formats and fill the combobox */
   for (i = 0; i < g_pCamApp->GetNumberOfFileTypes(); i++) {
      fm = g_pCamApp->GetFileTypeFormatStr(i);
      ExtensionComboBox->insertItem(fm);
      if (fm == FileFormat)
        set = i;
   }
   if (set >= 0)
     ExtensionComboBox->setCurrentItem(set);

   pFTPSettings = new CFTPSettings(0, 0, TRUE);
   if (pFTPSettings != 0) {
     pFTPSettings->Hostname->setText(pVOpts->GetFTPServer());
     pFTPSettings->PortSpinbox->setValue(pVOpts->GetFTPPort());
     pFTPSettings->Path->setText(pVOpts->GetFTPPath());
     pFTPSettings->Username->setText(pVOpts->GetFTPUser());
     pFTPSettings->Password->setText(pVOpts->GetFTPPass());
     pFTPSettings->m_Passive->setChecked(pVOpts->GetFTPPassive());
     pFTPSettings->m_Unique->setChecked(pVOpts->GetFTPUnique());
   }
}


void CSnapshotSettingsDlg::ClickedOK()
{
qDebug("CSnapshotSettingsDlg::ClickedOK()");
   // Stuff options back into CVideoOptions
   pVOpts->SetBaseName(BaseNameLineEdit->text());
   pVOpts->SetTextColor(TextColor);
   pVOpts->SetTextFont(TextFont);
   pVOpts->SetTimeInImage(TimestampImage->isChecked());
   pVOpts->SetFileFormat(ExtensionComboBox->currentText());
   pVOpts->SetSaveToDisk(SaveToDisk->isChecked());
   pVOpts->SetFTPToServer(FTPToServer->isChecked());
   switch(NameMiddleGroupBox->id(NameMiddleGroupBox->selected()))
   {
     case 1: pVOpts->SetMiddlePart(CVideoOptions::Overwrite); break;
     case 2: pVOpts->SetMiddlePart(CVideoOptions::Timestamp); break;
     case 3: pVOpts->SetMiddlePart(CVideoOptions::Sequence); break;
   }
   pVOpts->SetMaxSequence(MaxSequence->value());
   pVOpts->SetRunCommand(RunCommandCheckBox->isChecked());
   pVOpts->SetCommand(CommandLineEdit->text());
   pVOpts->SetUserMessage(YourMessageLineEdit->text());
}

void CSnapshotSettingsDlg::ClickedColor()
{
   QColor c;

qDebug("CSnapshotSettingsDlg::ClickedColor()");
   c = QColorDialog::getColor(TextColor, this);
   if (c.isValid())
     TextColor = c;
}

void CSnapshotSettingsDlg::ClickedFont()
{
   bool ok;
   QFont f;

qDebug("CSnapshotSettingsDlg::ClickedFont()");
   f = QFontDialog::getFont(&ok, TextFont, this);
   if (ok)
     TextFont = f;
}

void CSnapshotSettingsDlg::ClickedFTP()
{
   int result = 0;

   if (pFTPSettings == 0)
     return;
   result = pFTPSettings->exec();
   if (result == QDialog::Accepted) {
     qDebug("Setting FTP values");
     pVOpts->SetFTPServer(pFTPSettings->Hostname->text());
     pVOpts->SetFTPPort(pFTPSettings->PortSpinbox->value());
     pVOpts->SetFTPPath(pFTPSettings->Path->text());
     pVOpts->SetFTPUser(pFTPSettings->Username->text());
     pVOpts->SetFTPPass(pFTPSettings->Password->text());
     pVOpts->SetFTPPassive(pFTPSettings->m_Passive->isChecked());
     pVOpts->SetFTPUnique(pFTPSettings->m_Unique->isChecked());
     emit FTPSettingsUpdated();
   }
}
