/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>

#include "MemoryAudioSample.h"


CMemoryAudioSample::CMemoryAudioSample()
{
}

CMemoryAudioSample::CMemoryAudioSample(const CMemoryAudioSample &src)
	: CAudioSample(src)
{
  // nothing to copy
}


CMemoryAudioSample::CMemoryAudioSample(const SoundAttributes &attr, SamplePos sample_length)
	: CAudioSample(attr, sample_length)
{
}

CMemoryAudioSample::~CMemoryAudioSample()
{
  // nothing to destroy
}


// private




// protected

// public

bool CMemoryAudioSample::Create(const SoundAttributes &attr, SamplePos sample_length)
{
   Detach();
   return CreateBuffer(attr, sample_length);
}

//

//void RawCopy(void *input_buffer, SamplePos offset, SamplePos length);

void *CMemoryAudioSample::GetRawPointer(SamplePos offset) const
{
   char *s = 0;

   if (m_pData != 0 && m_pData->pMemBuffer != 0)
   {
     s = (char *)m_pData->pMemBuffer;
     s += offset * m_pData->Attributes.BytesPerSample();
   }
   return s;
}

