class status_bar ?packing ?show () =
  let hbox = GPack.hbox ?packing ?show () in

  let label = 
    let f = GBin.frame ~shadow_type: `IN 
              ~packing: (hbox#pack ~expand: true ~fill: true) () in
    let hbox = GPack.hbox ~packing: f#add () in
    (* add some space on the left side of the frame... *)
    let l' = GMisc.label ~text: " " ~packing: (hbox#pack ~expand: false) () in
    let l = GMisc.label ~packing: (hbox#pack ~expand: false ~fill: true) () in
    l
  in
  let progress =
    let f = GBin.frame ~width: 120 ~shadow_type: `IN 
	~packing: (hbox#pack ~expand: false ~fill: false) () in
    let p = GRange.progress_bar ~bar_style: `CONTINUOUS ~packing: f#add () in
    p#set_show_text true;
    p#set_format_string "";
    p
  in

  object (self)
  inherit GObj.widget hbox#as_widget

  method set_text = label#set_text
  method text = label#text
  method set_justify = label#set_justify
  method set_pattern = label#set_pattern
  method set_line_wrap = label#set_line_wrap

  method adjustment = progress#adjustment
  method configure = progress#configure
  method percentage = progress#percentage
  method set_adjustment = progress#set_adjustment
  method set_value = progress#set_value
  method value = progress#value

  method event = progress#event
  method set_activity_blocks = progress#set_activity_blocks
  method set_activity_step = progress#set_activity_step
  method set_bar_style = progress#set_bar_style
  method set_discrete_blocks = progress#set_discrete_blocks
  method set_orientation = progress#set_orientation

  val mutable activity_mode = false
      
  method set_percentage p = 
    if activity_mode then begin
      progress#set_activity_mode false;
      activity_mode <- false
    end;
    progress#set_percentage p

  method activate () =
    if not activity_mode then begin
      progress#set_activity_mode true;
      activity_mode <- true
    end;
    let p = 
      let p = progress#percentage +. 0.01 in
      if p > 1.0 then 0.0 else p
    in
    progress#set_percentage p
end

let status_bar ?packing ?show () = new status_bar ?packing ?show ()
