(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)

(* Class interface for Color *)

open Color

class map : Color.map -> object
  method colormap : Color.map

  method max : int
  method map : rgb array

  method query_rgb : int -> rgb

  method set_max : int -> unit
  method set_map : rgb array -> unit

  method size : int
  method find_exact : rgb -> int
  method find_nearest : rgb -> int
  method add_color : rgb -> int
  method add_colors : rgb list -> int list
end
