/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef COMPONENT_POPUP_MENU_H
#define COMPONENT_POPUP_MENU_H

// -- Core stuff
#include "CamiTKAPI.h"

// -- QT stuff
#include <QMenu>

// -- vtk stuff Classes
class vtkTransform;


namespace camitk
{
// -- Core stuff classes
class Component;

/** \deprecated since CamiTK 2.0
  * \note this class is deprecated, please use the Action framework.
  *
  * @ingroup group_sdk_libraries_core_component
  * 
  * @brief 
  * Generic class for Component popup menu.
  * To create your own Component popup, create a class that inherits from this one. Your class could have as many
  * slot that you want. Create popup menu item and connect your slot using the addAction method.
  *
  * <b>Example:</b>
  * \code
  * // ---------------------------
  * // -- ExampleComponentPopup.h
  * // ---------------------------
  * #include <ComponentPopupMenu.h>
  * 
  * class ExampleComponentPopup : public camitk::ComponentPopupMenu  {
  *   Q _ OBJECT  // note: the spaces around the underscore have to be removed
  * 
  *   public:
  *     ExampleComponentPopup(camitk::Component *, QWidget*);
  * 
  *   public slots:
  *     void test();
  * };
  * 
  * // -----------------------------
  * // -- ExampleComponentPopup.cpp
  * // -----------------------------
  * 
  * #include "ExampleComponentPopup.h"
  * #include "ExampleComponent.h"
  * #include <QMessageBox>
  * using namespace camitk;
  * 
  * ExampleComponentPopup::ExampleComponentPopup(Component *comp, QWidget *parent) : ComponentPopupMenu(comp,parent) {
  *   addAction("action test", SLOT(test()), true);
  * }
  * 
  * void ExampleComponentPopup::test() {
  *   // if you want to do something specific to the ExampleComponent class, then you can 
  *   // safely use dynamic cast as this:
  *   // ExampleComponent *comp = dynamic_cast<ExampleComponent*>(myComponent);
  *   // comp->specificMethodOfExampleComponent(...)
  *   
  *   QString testMessage;
  * 
  *   // myComponent is known here, so we could ask for its name 
  *   // getName() is a generic Component method, not specific to ExampleComponent, no need to use dynamic_cast here
  *   testMessage = QString("This is a test on \"%1\" .\nNice isn't it?").arg(QString(myComponent->getName()));
  *   
  *   QMessageBox::information( 0, "Test", testMessage);
  * 
  * }
  * 
  * // ----------------------
  * // -- ExampleComponent.h
  * // ----------------------
  * ...
  * public:
  *   // Overriden method so that we actually can instanciate a popup menu using ExampleComponentPopup
  *   virtual QMenu * getPopupMenu(QWidget* parent);
  * ...
  * private:
  *   // the popup menu
  *   QMenu * myPopupMenu;
  * ...
  * 
  * // ------------------------
  * // -- ExampleComponent.cpp
  * // ------------------------
  * #include "ExampleComponentPopup.h"
  * ...
  *   // Do NOT forget to add this line in the constructor
  *   myPopupMenu = NULL;
  * ...
  *   // Do NOT forget to add these lines in the destructor
  *   delete myPopupMenu;
  *   myPopupMenu = NULL;
  * ...
  * QMenu * ExampleComponent::getPopupMenu(QWidget* parent) {
  *   // lazy instanciation pattern
  *   if (!myPopupMenu) {
  *     myPopupMenu = new ExampleComponentPopup(this,parent);
  *   }
  * 
  *   return myPopupMenu;
  * }
  * 
  * ...
  * \endcode
  * 
  *
  * 
  */
class CAMITK_API ComponentPopupMenu : public QMenu {

  public:
    /// default constructor
    ComponentPopupMenu(Component *, QWidget*);

  protected:
    /** Add a new item to the popup menu)
      *  @param name string that will appears as the name of the menu item
      *  @param member is the slot to be connected to this action (slot that should be implemented in your subclass)
      *  @param isCheckable if the item is checkable
      *  @return the corresponding action
      */
    QAction * addAction(const QString name, const char * member, bool isCheckable = true);

    /// insert a menu separator and return the corresponding action
    QAction * addSeparator();

    /// the Component concerned by this popup menu
    Component *myComponent;


};

}

#endif
