#!
#! @ingroup group_sdk_cmake
#!
#! macro get_subdirectoryfiles get the names of all the files (and not directories) contained in a defined directory
#! 
#! Usage:
#! \code
#! get_subdirectoryfiles(Path Filenames)
#! \endcode
#!
#! \inparam Path (required)           input directory path
#! \outparam Name (required)          the name of the resulting variable containing all the file names of the given directory 
macro(get_subdirectoryfiles Path Filenames)
  set(Filenames)  
  FILE(GLOB children ${Path}/*)
#   message( STATUS children  ${children} )
  foreach(FILENAME ${children})
    if(NOT IS_DIRECTORY ${FILENAME})
#         message( STATUS "isfile "  ${FILENAME} )
        set(${Filenames} ${${Filenames}} ${FILENAME})
    endif()
  endforeach()
endmacro()
