#!
#! @ingroup group_sdk_cmake
#!
#! macro get_subdirectories get the names of all the subdirectories that
#! contains a CMakeLists.txt
#! 
#! Usage:
#! \code
#! get_subdirectories(Name)
#! \endcode
#!
#! \param Name (required)          the name of the resulting variable containing all the subdirectories names
macro(get_subdirectories Name)
  set(Name)
  file(GLOB LS *)
  foreach(FILENAME ${LS})
    if(IS_DIRECTORY ${FILENAME} AND EXISTS ${FILENAME}/CMakeLists.txt)
      get_directory_name(${FILENAME} DIRNAME)
      # ignore .svn
      if (NOT ${DIRNAME} STREQUAL ".svn")
          set(${Name} ${${Name}} ${DIRNAME})
      endif()
    endif()
  endforeach()
endmacro()
