/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#include <pml/StructuralComponent.h>
#include <pml/StructuralComponentProperties.h>


#include "StructuralComponentDCProperties.h"
#include "StructuralComponentDC.h"


#include <Application.h>

#include <QMessageBox>


// ---------------------- Constructor ----------------------
StructuralComponentDCProperties::StructuralComponentDCProperties(StructuralComponentDC *dc) : QObject(NULL) {
  setObjectName("Structural Component Properties");
  updateProperties(dc);
  // install a filter to get the modification of the dynamic properties
  installEventFilter(this);
}


// ---------------------- updateProperties ----------------------
void StructuralComponentDCProperties::updateProperties(StructuralComponentDC *dc) {

  // get the DC (who will get the messages)
  myDC = dc;

  if (myDC != NULL) {
    // message on the statusbar
    camitk::Application::showStatusBarMessage("SC \"" + QString(dc->getSC()->getName().c_str()) + "\" selected.", 2000); // for 2sec
  }

  // check for extra properties...
  StructuralComponentProperties *scProp = dc->getSC()->getProperties();

  std::string propName;

  for (unsigned int i = 0; i < scProp->numberOfFields(); i++) {
    propName = scProp->getField(i);

    if (propName != "") {
      setProperty(propName.c_str(), QVariant(scProp->getString(propName).c_str()));
    }
  }

}


// ---------------------- setName ----------------------
void StructuralComponentDCProperties::setName(QString id) {
  if (myDC) {
    dynamic_cast<StructuralComponent *>(myDC->getSC())->setName(id.toStdString());
    myDC->setName(id);
    myDC->setModified();
    myDC->refresh();
  }
}

// ---------------------- getName ----------------------
QString StructuralComponentDCProperties::getName() const {
  if (myDC)
    return myDC->getName();
  else
    return "";
}

// ---------------------- event ----------------------------
bool StructuralComponentDCProperties::event(QEvent * e) {
  if (e->type() == QEvent::DynamicPropertyChange) {
    e->accept();
    QDynamicPropertyChangeEvent *chev = dynamic_cast<QDynamicPropertyChangeEvent *>(e);

    if (! chev)
      return false;

    // set the corresponding property (field)
    myDC->getSC()->getProperties()->set(QString(chev->propertyName()).toStdString(), std::string(property(chev->propertyName()).toString().toStdString()));

    return true;
  }

  return QObject::event(e);
}

