/*
 * Calcoo: b_main.c
 *
 * Copyright (C) 2001,2002 Alexei Kaminski
 *
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "codes.h"
#include "body.h"
#include "defaults.h"
#include "b_headers.h"
#include "gtkaux_headers.h"
#include "io_headers.h"


#include "pixmaps/main.xpm"

t_calcoo_body *body;

void create_body(void)
{
	malloc_body();
	malloc_displays(); /* these displays are not widgets, but structures to
			    * store information what to display in the
			    * corresponding widgets */
	create_widgets();
	assign_accel();
}

void malloc_body(void)
{
	body = (t_calcoo_body*) malloc(sizeof(t_calcoo_body));
}

void create_main_window(int w, int h)
{
	GdkPixmap *main_pixmap;
	GdkBitmap *main_mask;
	int i;

/* Main widget */
	body->main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (body->main_window), "Calcoo");
	gtk_container_border_width (GTK_CONTAINER (body->main_window), 0);
	gtk_widget_set_usize(body->main_window, w, h);
	gtk_window_set_policy (GTK_WINDOW (body->main_window), 
			       FALSE, FALSE, FALSE);

	gtk_signal_connect (GTK_OBJECT (body->main_window), "delete_event",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
	gtk_signal_connect (GTK_OBJECT (body->main_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

	body->style = gtk_widget_get_style( body->main_window );

	gtk_widget_show (body->main_window);

/* Main window icon */
	main_pixmap = gdk_pixmap_create_from_xpm_d ( 
		(body->main_window)->window,
		&main_mask,
		&(body->style)->bg[GTK_STATE_NORMAL],
		(gchar **) main_xpm 
		);

  	gdk_window_set_icon (body->main_window->window, NULL,  
  			     main_pixmap, main_mask); 

/* Fixer to fix the button positions and sizes */
	body->fixer = gtk_fixed_new();
	gtk_container_add (GTK_CONTAINER(body->main_window), body->fixer);
	gtk_widget_show (body->fixer);

/* Button tooltips */
	body->button_tooltips = gtk_tooltips_new();
	gtk_tooltips_set_delay(body->button_tooltips, DEFAULT_TOOLTIP_DELAY);

/* Setting all button pointers to NULL in order to be able to tell
 * existing from non-existing buttons when making all the buttons 
 * active/non-active, like after an error */
	for (i = 0; i < MAX_BUTTON_NUMBER; i++)
		body->button[i] = NULL;
}

void set_rpn_mode(int a)
{
	if (a) {
		show_button(CODE_ENTER);
		show_button(CODE_EXCH_XZ);
		show_button(CODE_EXCH_XT);
		hide_button(CODE_EQ);
		hide_button(CODE_RIGHT_PAREN);
		hide_button(CODE_LEFT_PAREN);
	} else {
		show_button(CODE_EQ);
		show_button(CODE_RIGHT_PAREN);
		show_button(CODE_LEFT_PAREN);
		hide_button(CODE_ENTER);
		hide_button(CODE_EXCH_XZ);
		hide_button(CODE_EXCH_XT);
	}
	set_accel_mode(a);
	clicked_set_rpn_mode(a);
}

int get_rpn_mode(void)
{
	int a;
	a = requested_rpn_mode();
	return a;
}

void set_enter_mode(int a)
{
	clicked_set_enter_mode(a);
}

int get_enter_mode(void)
{
	int a;
	a = requested_enter_mode();
	return a;
}

void set_stack_mode(int a)
{
	clicked_set_stack_mode(a);
}

int get_stack_mode(void)
{
	int a;
	a = requested_stack_mode();
	return a;
}

void call_exit(void)
{
	gtk_main_quit();
}
