#!/usr/bin/ruby

require 'test/unit'
require 'codesnippet'

class TC_CodeSnippet < Test::Unit::TestCase
  def test_parse
    tests = [
      ['int x',       'int x;', nil],
      ['int x = 3',   'int x;', 'x = 3;'],
      ['void f() {}', 'void f();', nil, 'void f() {}'],
      ['while(foo) { bar; }', nil, 'while(foo) { bar; };'],
      ['x = 4', nil, 'x = 4;'],
      ['f(x)', nil, 'f(x);'],
    ]
    tests.each do |input, decl, stmt, func|
      c = CodeSnippet.parse(input)
      assert_equal decl, c.decl
      assert_equal stmt, c.stmt
      assert_equal func, c.func
    end
  end
end

# vim: set ts=2 sw=2 et :
