/*  $Id: EnemySprite.cpp,v 1.3 2002/04/03 06:11:27 sarrazip Exp $
    EnemySprite.cpp - Sprite that represents an enemy of the player.

    burgerspace - A hamburger-smashing video game.
    Copyright (C) 2001 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#include "EnemySprite.h"

#include <stdio.h>


EnemySprite::EnemySprite(const PixmapArray &pa,
			    Couple pos, Couple speed,
			    Couple collBoxPos, Couple collBosSize) throw(int)
  : Sprite(pa, pos, speed, Couple(0, 0), collBoxPos, collBosSize),
    carryingGroup(NULL),
    disappearanceTime(0),
    timeToDie(0)
{
}


EnemySprite::~EnemySprite()
{
}


void
EnemySprite::setCarryingGroup(IngredientGroup *g)
{
    carryingGroup = g;
}
