/*
 * buffy - Mailbox watcher
 *
 * Copyright (C) 2003  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#define APPNAME PACKAGE_NAME
#else
#warning No config.h found: using fallback values
#define APPNAME __FILE__
#define PACKAGE_VERSION "unknown"
#endif

#include "Environment.h"
#include "CommandlineParser.h"
#include "BuffyWindow.h"
#include <wibble/exception.h>

#include <gtkmm/main.h>

using namespace std;
using namespace wibble;

int main(int argc, char* argv[])
{
	try {
		CommandlineParser opts(APPNAME, "[options] [file1|-]",
				"Mail folder monitor.\n"
				"Monitor new and unread messages in a collection of mail folders.\n");
		opts.add("version", 0, "version", "print the program version, then exit");
		opts.add("verbose", 0, "verbose", "enable verbose output");
		opts.add("debug", 0, "debug", "enable debugging output (including verbose output)");

		// Process the commandline
		if (!opts.parse(argc, const_cast<const char**&>(argv)))
		{
			opts.printHelp();
			return 1;
		}
		if (opts.get("help").defined())
		{
			opts.printHelp();
			return 0;
		}

		Environment::init();
		
		if (opts.get("version").defined())
		{
			printf("%s ver." PACKAGE_VERSION "\n", APPNAME);
			return 0;
		}		
		if (opts.get("verbose").defined())
			Environment::get().verbose(true);
		if (opts.get("debug").defined())
			Environment::get().debug(true);

		Gtk::Main app(argc, argv);

		// Connect the SIGCHLD pipe to the right signal
		//app.input.connect(Environment::get().signal_child_exit(), Environment::get().get_SIGCHLD_pipe(), Gdk::GTK_INPUT_READ);
		
		BuffyWindow buffyWindow;

		//buffyWindow.rescanFolders();

		Gtk::Main::run(buffyWindow);

		Environment::get().config().save();
		
		return 0;
	}
	catch (wibble::exception::Generic& e)
	{
		fatal_error("%s: %s\n", e.type(), e.fullInfo().c_str());
		return 1;
	}
}

// vim:set ts=4 sw=4:
