/* PlacesIndicatorWindow.c generated by valac 0.32.1, the Vala compiler
 * generated from PlacesIndicatorWindow.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2015-2016 Solus Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_PLACES_INDICATOR_WINDOW (places_indicator_window_get_type ())
#define PLACES_INDICATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindow))
#define PLACES_INDICATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindowClass))
#define IS_PLACES_INDICATOR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLACES_INDICATOR_WINDOW))
#define IS_PLACES_INDICATOR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLACES_INDICATOR_WINDOW))
#define PLACES_INDICATOR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindowClass))

typedef struct _PlacesIndicatorWindow PlacesIndicatorWindow;
typedef struct _PlacesIndicatorWindowClass PlacesIndicatorWindowClass;
typedef struct _PlacesIndicatorWindowPrivate PlacesIndicatorWindowPrivate;

#define TYPE_MESSAGE_REVEALER (message_revealer_get_type ())
#define MESSAGE_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MESSAGE_REVEALER, MessageRevealer))
#define MESSAGE_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MESSAGE_REVEALER, MessageRevealerClass))
#define IS_MESSAGE_REVEALER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MESSAGE_REVEALER))
#define IS_MESSAGE_REVEALER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MESSAGE_REVEALER))
#define MESSAGE_REVEALER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MESSAGE_REVEALER, MessageRevealerClass))

typedef struct _MessageRevealer MessageRevealer;
typedef struct _MessageRevealerClass MessageRevealerClass;

#define TYPE_PLACES_SECTION (places_section_get_type ())
#define PLACES_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLACES_SECTION, PlacesSection))
#define PLACES_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLACES_SECTION, PlacesSectionClass))
#define IS_PLACES_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLACES_SECTION))
#define IS_PLACES_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLACES_SECTION))
#define PLACES_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLACES_SECTION, PlacesSectionClass))

typedef struct _PlacesSection PlacesSection;
typedef struct _PlacesSectionClass PlacesSectionClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TYPE_LIST_ITEM (list_item_get_type ())
#define LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_ITEM, ListItem))
#define LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_ITEM, ListItemClass))
#define IS_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_ITEM))
#define IS_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_ITEM))
#define LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_ITEM, ListItemClass))

typedef struct _ListItem ListItem;
typedef struct _ListItemClass ListItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _PlacesSectionPrivate PlacesSectionPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_VOLUME_ITEM (volume_item_get_type ())
#define VOLUME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VOLUME_ITEM, VolumeItem))
#define VOLUME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VOLUME_ITEM, VolumeItemClass))
#define IS_VOLUME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VOLUME_ITEM))
#define IS_VOLUME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VOLUME_ITEM))
#define VOLUME_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VOLUME_ITEM, VolumeItemClass))

typedef struct _VolumeItem VolumeItem;
typedef struct _VolumeItemClass VolumeItemClass;

#define TYPE_MOUNT_ITEM (mount_item_get_type ())
#define MOUNT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ITEM, MountItem))
#define MOUNT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ITEM, MountItemClass))
#define IS_MOUNT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ITEM))
#define IS_MOUNT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ITEM))
#define MOUNT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ITEM, MountItemClass))

typedef struct _MountItem MountItem;
typedef struct _MountItemClass MountItemClass;

#define TYPE_PLACE_ITEM (place_item_get_type ())
#define PLACE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLACE_ITEM, PlaceItem))
#define PLACE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLACE_ITEM, PlaceItemClass))
#define IS_PLACE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLACE_ITEM))
#define IS_PLACE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLACE_ITEM))
#define PLACE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLACE_ITEM, PlaceItemClass))

typedef struct _PlaceItem PlaceItem;
typedef struct _PlaceItemClass PlaceItemClass;

struct _PlacesIndicatorWindow {
	GtkPopover parent_instance;
	PlacesIndicatorWindowPrivate * priv;
};

struct _PlacesIndicatorWindowClass {
	GtkPopoverClass parent_class;
};

struct _PlacesIndicatorWindowPrivate {
	GVolumeMonitor* volume_monitor;
	MessageRevealer* message_bar;
	PlacesSection* places_section;
	GtkListBox* mounts_listbox;
	GHashTable* places_list;
	gboolean _show_places;
	gboolean _show_drives;
	gboolean _show_networks;
	GFileMonitor* bookmarks_monitor;
	GUserDirectory* DEFAULT_DIRECTORIES;
	gint DEFAULT_DIRECTORIES_length1;
	gint _DEFAULT_DIRECTORIES_size_;
};

struct _PlacesSection {
	GtkBox parent_instance;
	PlacesSectionPrivate * priv;
	gchar* expanded_by;
};

struct _PlacesSectionClass {
	GtkBoxClass parent_class;
};


static gpointer places_indicator_window_parent_class = NULL;
static GType places_indicator_window_type_id = 0;

GType places_indicator_window_get_type (void) G_GNUC_CONST;
GType places_indicator_window_register_type (GTypeModule * module);
GType message_revealer_get_type (void) G_GNUC_CONST;
GType message_revealer_register_type (GTypeModule * module);
GType places_section_get_type (void) G_GNUC_CONST;
GType places_section_register_type (GTypeModule * module);
#define PLACES_INDICATOR_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindowPrivate))
enum  {
	PLACES_INDICATOR_WINDOW_DUMMY_PROPERTY,
	PLACES_INDICATOR_WINDOW_SHOW_PLACES,
	PLACES_INDICATOR_WINDOW_SHOW_DRIVES,
	PLACES_INDICATOR_WINDOW_SHOW_NETWORKS
};
PlacesIndicatorWindow* places_indicator_window_new (GtkWidget* window_parent);
PlacesIndicatorWindow* places_indicator_window_construct (GType object_type, GtkWidget* window_parent);
static void _g_free0_ (gpointer var);
MessageRevealer* message_revealer_new (void);
MessageRevealer* message_revealer_construct (GType object_type);
PlacesSection* places_section_new (void);
PlacesSection* places_section_construct (GType object_type);
static void places_indicator_window_list_header_func (PlacesIndicatorWindow* self, GtkListBoxRow* before, GtkListBoxRow* after);
static void _places_indicator_window_list_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
static void places_indicator_window_set_up_placeholder (PlacesIndicatorWindow* self);
static void places_indicator_window_connect_signals (PlacesIndicatorWindow* self);
GType list_item_get_type (void) G_GNUC_CONST;
GType list_item_register_type (GTypeModule * module);
gchar* list_item_get_item_category (ListItem* self);
static GFile* places_indicator_window_get_bookmarks_file (PlacesIndicatorWindow* self);
static void places_indicator_window_connect_bookmarks_monitor (PlacesIndicatorWindow* self);
static void ___lambda7_ (PlacesIndicatorWindow* self, GFile* src, GFile* dest, GFileMonitorEvent event);
static void places_indicator_window_refresh_special_dirs (PlacesIndicatorWindow* self);
static void ____lambda7__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void places_indicator_window_refresh_mounts (PlacesIndicatorWindow* self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_drive_connected (GVolumeMonitor* _sender, GDrive* drive, gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_drive_disconnected (GVolumeMonitor* _sender, GDrive* drive, gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void _places_indicator_window_refresh_mounts_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self);
static void places_indicator_window_check_expand (PlacesIndicatorWindow* self);
gboolean places_indicator_window_get_show_drives (PlacesIndicatorWindow* self);
gboolean places_indicator_window_get_show_networks (PlacesIndicatorWindow* self);
gboolean places_indicator_window_get_show_places (PlacesIndicatorWindow* self);
void places_section_reveal (PlacesSection* self, gboolean state);
static void places_indicator_window_toggle_section_visibility (PlacesIndicatorWindow* self, const gchar* section);
static void places_indicator_window_refresh_bookmarks (PlacesIndicatorWindow* self);
static void places_indicator_window_add_place (PlacesIndicatorWindow* self, const gchar* path, const gchar* class);
void places_section_clear (PlacesSection* self);
static gboolean places_indicator_window_is_interesting (PlacesIndicatorWindow* self, GMount* mount);
static void places_indicator_window_add_volume (PlacesIndicatorWindow* self, GVolume* volume);
static void places_indicator_window_add_mount (PlacesIndicatorWindow* self, GMount* mount, const gchar* class);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GType volume_item_get_type (void) G_GNUC_CONST;
GType volume_item_register_type (GTypeModule * module);
VolumeItem* volume_item_new (GVolume* volume);
VolumeItem* volume_item_construct (GType object_type, GVolume* volume);
static void __lambda12_ (PlacesIndicatorWindow* self, const gchar* message_content, GtkMessageType message_type);
void message_revealer_set_content (MessageRevealer* self, const gchar* message, GtkMessageType message_type);
static void ___lambda12__volume_item_send_message (VolumeItem* _sender, const gchar* message_content, GtkMessageType message_type, gpointer self);
GType mount_item_get_type (void) G_GNUC_CONST;
GType mount_item_register_type (GTypeModule * module);
MountItem* mount_item_new (GMount* mount, const gchar* class);
MountItem* mount_item_construct (GType object_type, GMount* mount, const gchar* class);
static void __lambda17_ (PlacesIndicatorWindow* self, const gchar* message_content, GtkMessageType message_type);
static void ___lambda17__mount_item_send_message (MountItem* _sender, const gchar* message_content, GtkMessageType message_type, gpointer self);
GType place_item_get_type (void) G_GNUC_CONST;
GType place_item_register_type (GTypeModule * module);
PlaceItem* place_item_new (GFile* file, const gchar* class);
PlaceItem* place_item_construct (GType object_type, GFile* file, const gchar* class);
void places_section_add_item (PlacesSection* self, PlaceItem* item);
void places_indicator_window_set_show_places (PlacesIndicatorWindow* self, gboolean value);
void places_indicator_window_set_show_drives (PlacesIndicatorWindow* self, gboolean value);
void places_indicator_window_set_show_networks (PlacesIndicatorWindow* self, gboolean value);
static void places_indicator_window_finalize (GObject* obj);
static void _vala_places_indicator_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_places_indicator_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _places_indicator_window_list_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	places_indicator_window_list_header_func ((PlacesIndicatorWindow*) self, row, before);
}


PlacesIndicatorWindow* places_indicator_window_construct (GType object_type, GtkWidget* window_parent) {
	PlacesIndicatorWindow * self = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GtkBox* main_content = NULL;
	GtkBox* _tmp5_ = NULL;
	MessageRevealer* _tmp6_ = NULL;
	MessageRevealer* _tmp7_ = NULL;
	MessageRevealer* _tmp8_ = NULL;
	PlacesSection* _tmp9_ = NULL;
	PlacesSection* _tmp10_ = NULL;
	GtkListBox* _tmp11_ = NULL;
	GtkListBox* _tmp12_ = NULL;
	GtkListBox* _tmp13_ = NULL;
	GtkListBox* _tmp14_ = NULL;
	GVolumeMonitor* _tmp15_ = NULL;
	_tmp0_ = window_parent;
	self = (PlacesIndicatorWindow*) g_object_new (object_type, "relative-to", _tmp0_, NULL);
	gtk_widget_set_size_request ((GtkWidget*) self, 280, 0);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "places-menu");
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->places_list);
	self->priv->places_list = _tmp4_;
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp5_);
	main_content = _tmp5_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_content);
	_tmp6_ = message_revealer_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->message_bar);
	self->priv->message_bar = _tmp6_;
	_tmp7_ = self->priv->message_bar;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->message_bar;
	gtk_box_pack_start (main_content, (GtkWidget*) _tmp8_, FALSE, TRUE, (guint) 0);
	_tmp9_ = places_section_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->places_section);
	self->priv->places_section = _tmp9_;
	_tmp10_ = self->priv->places_section;
	gtk_box_pack_start (main_content, (GtkWidget*) _tmp10_, FALSE, TRUE, (guint) 0);
	_tmp11_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->mounts_listbox);
	self->priv->mounts_listbox = _tmp11_;
	_tmp12_ = self->priv->mounts_listbox;
	gtk_list_box_set_selection_mode (_tmp12_, GTK_SELECTION_NONE);
	_tmp13_ = self->priv->mounts_listbox;
	gtk_list_box_set_header_func (_tmp13_, _places_indicator_window_list_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp14_ = self->priv->mounts_listbox;
	gtk_box_pack_start (main_content, (GtkWidget*) _tmp14_, TRUE, TRUE, (guint) 0);
	places_indicator_window_set_up_placeholder (self);
	_tmp15_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp15_;
	places_indicator_window_connect_signals (self);
	gtk_widget_show_all ((GtkWidget*) main_content);
	_g_object_unref0 (main_content);
	return self;
}


PlacesIndicatorWindow* places_indicator_window_new (GtkWidget* window_parent) {
	return places_indicator_window_construct (TYPE_PLACES_INDICATOR_WINDOW, window_parent);
}


/**
     * Provide section headers in the mounts list
     * Ripped out of budgie-menu
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void places_indicator_window_list_header_func (PlacesIndicatorWindow* self, GtkListBoxRow* before, GtkListBoxRow* after) {
	ListItem* child = NULL;
	gchar* prev = NULL;
	gchar* next = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp6_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GtkListBoxRow* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	child = NULL;
	prev = NULL;
	next = NULL;
	_tmp0_ = before;
	if (_tmp0_ != NULL) {
		GtkListBoxRow* _tmp1_ = NULL;
		GtkWidget* _tmp2_ = NULL;
		ListItem* _tmp3_ = NULL;
		ListItem* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = before;
		_tmp2_ = gtk_bin_get_child ((GtkBin*) _tmp1_);
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_LIST_ITEM) ? ((ListItem*) _tmp2_) : NULL);
		_g_object_unref0 (child);
		child = _tmp3_;
		_tmp4_ = child;
		_tmp5_ = list_item_get_item_category (_tmp4_);
		_g_free0 (prev);
		prev = _tmp5_;
	}
	_tmp6_ = after;
	if (_tmp6_ != NULL) {
		GtkListBoxRow* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		ListItem* _tmp9_ = NULL;
		ListItem* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp7_ = after;
		_tmp8_ = gtk_bin_get_child ((GtkBin*) _tmp7_);
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_LIST_ITEM) ? ((ListItem*) _tmp8_) : NULL);
		_g_object_unref0 (child);
		child = _tmp9_;
		_tmp10_ = child;
		_tmp11_ = list_item_get_item_category (_tmp10_);
		_g_free0 (next);
		next = _tmp11_;
	}
	_tmp14_ = before;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		GtkListBoxRow* _tmp15_ = NULL;
		_tmp15_ = after;
		_tmp13_ = _tmp15_ == NULL;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = prev;
		_tmp17_ = next;
		_tmp12_ = g_strcmp0 (_tmp16_, _tmp17_) != 0;
	}
	if (_tmp12_) {
		GtkLabel* label = NULL;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GtkLabel* _tmp21_ = NULL;
		GtkLabel* _tmp22_ = NULL;
		GtkLabel* _tmp23_ = NULL;
		GtkStyleContext* _tmp24_ = NULL;
		GtkLabel* _tmp25_ = NULL;
		GtkLabel* _tmp26_ = NULL;
		GtkListBoxRow* _tmp27_ = NULL;
		GtkLabel* _tmp28_ = NULL;
		GtkLabel* _tmp29_ = NULL;
		_tmp18_ = prev;
		_tmp19_ = g_markup_printf_escaped ("<span font=\"11\">%s</span>", _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = (GtkLabel*) gtk_label_new (_tmp20_);
		g_object_ref_sink (_tmp21_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		label = _tmp22_;
		_tmp23_ = label;
		_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
		gtk_style_context_add_class (_tmp24_, "dim-label");
		_tmp25_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp25_, GTK_ALIGN_START);
		_tmp26_ = label;
		gtk_label_set_use_markup (_tmp26_, TRUE);
		_tmp27_ = before;
		_tmp28_ = label;
		gtk_list_box_row_set_header (_tmp27_, (GtkWidget*) _tmp28_);
		_tmp29_ = label;
		g_object_set ((GtkWidget*) _tmp29_, "margin", 3, NULL);
		_g_object_unref0 (label);
	} else {
		GtkListBoxRow* _tmp30_ = NULL;
		_tmp30_ = before;
		gtk_list_box_row_set_header (_tmp30_, NULL);
	}
	_g_free0 (next);
	_g_free0 (prev);
	_g_object_unref0 (child);
}


static void places_indicator_window_set_up_placeholder (PlacesIndicatorWindow* self) {
	GtkBox* placeholder_box = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_ = NULL;
	GtkImage* placeholder_image = NULL;
	GtkImage* _tmp2_ = NULL;
	GtkLabel* placeholder_label = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* placeholder_label1 = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkStyleContext* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp0_);
	placeholder_box = _tmp0_;
	g_object_set ((GtkWidget*) placeholder_box, "margin", 10, NULL);
	gtk_widget_set_halign ((GtkWidget*) placeholder_box, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) placeholder_box, GTK_ALIGN_CENTER);
	_tmp1_ = self->priv->mounts_listbox;
	gtk_list_box_set_placeholder (_tmp1_, (GtkWidget*) placeholder_box);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("drive-harddisk-symbolic", GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp2_);
	placeholder_image = _tmp2_;
	gtk_image_set_pixel_size (placeholder_image, 64);
	gtk_box_pack_start (placeholder_box, (GtkWidget*) placeholder_image, FALSE, FALSE, (guint) 6);
	_tmp3_ = _ ("Nothing to display right now");
	_tmp4_ = g_strdup_printf ("<span font=\"11\">%s</span>", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	placeholder_label = _tmp7_;
	gtk_label_set_use_markup (placeholder_label, TRUE);
	gtk_box_pack_start (placeholder_box, (GtkWidget*) placeholder_label, FALSE, FALSE, (guint) 0);
	_tmp8_ = _ ("Mount some drives");
	_tmp9_ = _ ("Enable more sections");
	_tmp10_ = g_strdup_printf ("<span font=\"10\">%s\n%s</span>", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	placeholder_label1 = _tmp13_;
	gtk_label_set_use_markup (placeholder_label1, TRUE);
	gtk_label_set_justify (placeholder_label1, GTK_JUSTIFY_CENTER);
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) placeholder_label1);
	gtk_style_context_add_class (_tmp14_, "dim-label");
	gtk_box_pack_start (placeholder_box, (GtkWidget*) placeholder_label1, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) placeholder_box);
	_g_object_unref0 (placeholder_label1);
	_g_object_unref0 (placeholder_label);
	_g_object_unref0 (placeholder_image);
	_g_object_unref0 (placeholder_box);
}


static GFile* places_indicator_window_get_bookmarks_file (PlacesIndicatorWindow* self) {
	GFile* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gtk-3.0", "bookmarks", NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


static void ___lambda7_ (PlacesIndicatorWindow* self, GFile* src, GFile* dest, GFileMonitorEvent event) {
	GFileMonitorEvent _tmp0_ = 0;
	g_return_if_fail (src != NULL);
	_tmp0_ = event;
	if (_tmp0_ == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
		places_indicator_window_refresh_special_dirs (self);
	}
}


static void ____lambda7__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	___lambda7_ ((PlacesIndicatorWindow*) self, file, other_file, event_type);
}


static void places_indicator_window_connect_bookmarks_monitor (PlacesIndicatorWindow* self) {
	GFile* bookmarks_file = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = places_indicator_window_get_bookmarks_file (self);
	bookmarks_file = _tmp0_;
	_tmp1_ = bookmarks_file;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	if (!_tmp2_) {
		_g_object_unref0 (bookmarks_file);
		return;
	}
	{
		GFileMonitor* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFileMonitor* _tmp5_ = NULL;
		GFileMonitor* _tmp6_ = NULL;
		GFileMonitor* _tmp7_ = NULL;
		GFileMonitor* _tmp8_ = NULL;
		_tmp4_ = bookmarks_file;
		_tmp5_ = g_file_monitor_file (_tmp4_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (bookmarks_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->bookmarks_monitor);
		self->priv->bookmarks_monitor = _tmp6_;
		_tmp7_ = self->priv->bookmarks_monitor;
		g_file_monitor_set_rate_limit (_tmp7_, 1000);
		_tmp8_ = self->priv->bookmarks_monitor;
		g_signal_connect_object (_tmp8_, "changed", (GCallback) ____lambda7__g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("PlacesIndicatorWindow.vala:182: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (bookmarks_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (bookmarks_file);
}


static void _places_indicator_window_refresh_mounts_g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}


static void _places_indicator_window_refresh_mounts_g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}


static void _places_indicator_window_refresh_mounts_g_volume_monitor_drive_connected (GVolumeMonitor* _sender, GDrive* drive, gpointer self) {
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}


static void _places_indicator_window_refresh_mounts_g_volume_monitor_drive_disconnected (GVolumeMonitor* _sender, GDrive* drive, gpointer self) {
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}


static void _places_indicator_window_refresh_mounts_g_volume_monitor_mount_added (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}


static void _places_indicator_window_refresh_mounts_g_volume_monitor_mount_removed (GVolumeMonitor* _sender, GMount* mount, gpointer self) {
	places_indicator_window_refresh_mounts ((PlacesIndicatorWindow*) self);
}


static void places_indicator_window_connect_signals (PlacesIndicatorWindow* self) {
	GVolumeMonitor* _tmp0_ = NULL;
	GVolumeMonitor* _tmp1_ = NULL;
	GVolumeMonitor* _tmp2_ = NULL;
	GVolumeMonitor* _tmp3_ = NULL;
	GVolumeMonitor* _tmp4_ = NULL;
	GVolumeMonitor* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	places_indicator_window_connect_bookmarks_monitor (self);
	_tmp0_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp0_, "volume-added", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_volume_added, self, 0);
	_tmp1_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp1_, "volume-removed", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_volume_removed, self, 0);
	_tmp2_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp2_, "drive-connected", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_drive_connected, self, 0);
	_tmp3_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp3_, "drive-disconnected", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_drive_disconnected, self, 0);
	_tmp4_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp4_, "mount-added", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_mount_added, self, 0);
	_tmp5_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp5_, "mount-removed", (GCallback) _places_indicator_window_refresh_mounts_g_volume_monitor_mount_removed, self, 0);
}


static void places_indicator_window_check_expand (PlacesIndicatorWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp3_ = places_indicator_window_get_show_drives (self);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = places_indicator_window_get_show_networks (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GtkListBox* _tmp7_ = NULL;
		GList* _tmp8_ = NULL;
		GList* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		_tmp7_ = self->priv->mounts_listbox;
		_tmp8_ = gtk_container_get_children ((GtkContainer*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_list_length (_tmp9_);
		_tmp1_ = _tmp10_ == ((guint) 0);
		_g_list_free0 (_tmp9_);
	}
	if (_tmp1_) {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = places_indicator_window_get_show_places (self);
		_tmp12_ = _tmp11_;
		_tmp0_ = _tmp12_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp13_ = NULL;
		GtkListBox* _tmp14_ = NULL;
		PlacesSection* _tmp15_ = NULL;
		_tmp13_ = self->priv->mounts_listbox;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp13_, TRUE);
		_tmp14_ = self->priv->mounts_listbox;
		gtk_widget_hide ((GtkWidget*) _tmp14_);
		_tmp15_ = self->priv->places_section;
		places_section_reveal (_tmp15_, TRUE);
	} else {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		_tmp17_ = places_indicator_window_get_show_drives (self);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			_tmp16_ = TRUE;
		} else {
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			_tmp19_ = places_indicator_window_get_show_networks (self);
			_tmp20_ = _tmp19_;
			_tmp16_ = _tmp20_;
		}
		if (_tmp16_) {
			GtkListBox* _tmp21_ = NULL;
			GtkListBox* _tmp22_ = NULL;
			PlacesSection* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp21_ = self->priv->mounts_listbox;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp21_, FALSE);
			_tmp22_ = self->priv->mounts_listbox;
			gtk_widget_show ((GtkWidget*) _tmp22_);
			_tmp23_ = self->priv->places_section;
			_tmp24_ = _tmp23_->expanded_by;
			if (g_strcmp0 (_tmp24_, "code") == 0) {
				PlacesSection* _tmp25_ = NULL;
				_tmp25_ = self->priv->places_section;
				places_section_reveal (_tmp25_, FALSE);
			}
		} else {
			GtkListBox* _tmp26_ = NULL;
			GtkListBox* _tmp27_ = NULL;
			_tmp26_ = self->priv->mounts_listbox;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp26_, FALSE);
			_tmp27_ = self->priv->mounts_listbox;
			gtk_widget_show ((GtkWidget*) _tmp27_);
		}
	}
}


static void places_indicator_window_toggle_section_visibility (PlacesIndicatorWindow* self, const gchar* section) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	PlacesSection* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("places")))) {
		switch (0) {
			default:
			{
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				_tmp4_ = places_indicator_window_get_show_places (self);
				_tmp5_ = _tmp4_;
				if (_tmp5_) {
					PlacesSection* _tmp6_ = NULL;
					PlacesSection* _tmp7_ = NULL;
					_tmp6_ = self->priv->places_section;
					gtk_widget_show ((GtkWidget*) _tmp6_);
					_tmp7_ = self->priv->places_section;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp7_, FALSE);
					places_indicator_window_refresh_special_dirs (self);
				} else {
					PlacesSection* _tmp8_ = NULL;
					PlacesSection* _tmp9_ = NULL;
					_tmp8_ = self->priv->places_section;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp8_, TRUE);
					_tmp9_ = self->priv->places_section;
					gtk_widget_hide ((GtkWidget*) _tmp9_);
				}
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("drives")))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("networks"))))) {
		switch (0) {
			default:
			{
				places_indicator_window_refresh_mounts (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp10_ = self->priv->places_section;
	places_section_reveal (_tmp10_, FALSE);
	places_indicator_window_check_expand (self);
}


static void places_indicator_window_refresh_bookmarks (PlacesIndicatorWindow* self) {
	GFile* bookmarks_file = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = places_indicator_window_get_bookmarks_file (self);
	bookmarks_file = _tmp0_;
	_tmp1_ = bookmarks_file;
	_tmp2_ = g_file_query_exists (_tmp1_, NULL);
	if (!_tmp2_) {
		_g_object_unref0 (bookmarks_file);
		return;
	}
	{
		GFileInputStream* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFileInputStream* _tmp5_ = NULL;
		GDataInputStream* dis = NULL;
		GDataInputStream* _tmp6_ = NULL;
		gchar* line = NULL;
		_tmp4_ = bookmarks_file;
		_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp6_ = g_data_input_stream_new ((GInputStream*) _tmp3_);
		dis = _tmp6_;
		while (TRUE) {
			gchar* _tmp7_ = NULL;
			GDataInputStream* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp8_ = dis;
			_tmp9_ = g_data_input_stream_read_line (_tmp8_, NULL, NULL, &_inner_error_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (line);
				_g_object_unref0 (dis);
				_g_object_unref0 (_tmp3_);
				goto __catch1_g_error;
			}
			_tmp10_ = _tmp7_;
			_tmp7_ = NULL;
			_g_free0 (line);
			line = _tmp10_;
			_tmp11_ = line;
			if (!(_tmp11_ != NULL)) {
				_g_free0 (_tmp7_);
				break;
			}
			_tmp12_ = line;
			places_indicator_window_add_place (self, _tmp12_, "bookmark");
			_g_free0 (_tmp7_);
		}
		_g_free0 (line);
		_g_object_unref0 (dis);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("PlacesIndicatorWindow.vala:270: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (bookmarks_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (bookmarks_file);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void places_indicator_window_refresh_special_dirs (PlacesIndicatorWindow* self) {
	GHashTable* _tmp0_ = NULL;
	PlacesSection* _tmp1_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GUserDirectory* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->places_list;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->priv->places_section;
	places_section_clear (_tmp1_);
	_tmp2_ = g_get_home_dir ();
	_tmp3_ = g_strdup (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("file://", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	places_indicator_window_add_place (self, _tmp7_, "place");
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->DEFAULT_DIRECTORIES;
	_tmp8__length1 = self->priv->DEFAULT_DIRECTORIES_length1;
	{
		GUserDirectory* special_dir_collection = NULL;
		gint special_dir_collection_length1 = 0;
		gint _special_dir_collection_size_ = 0;
		gint special_dir_it = 0;
		special_dir_collection = _tmp8_;
		special_dir_collection_length1 = _tmp8__length1;
		for (special_dir_it = 0; special_dir_it < _tmp8__length1; special_dir_it = special_dir_it + 1) {
			GUserDirectory special_dir = 0;
			special_dir = special_dir_collection[special_dir_it];
			{
				GUserDirectory _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				_tmp9_ = special_dir;
				_tmp10_ = g_get_user_special_dir (_tmp9_);
				_tmp11_ = g_strdup (_tmp10_);
				_g_free0 (path);
				path = _tmp11_;
				_tmp12_ = path;
				_tmp13_ = string_to_string (_tmp12_);
				_tmp14_ = g_strconcat ("file://", _tmp13_, NULL);
				_tmp15_ = _tmp14_;
				places_indicator_window_add_place (self, _tmp15_, "place");
				_g_free0 (_tmp15_);
			}
		}
	}
	places_indicator_window_refresh_bookmarks (self);
	_g_free0 (path);
}


static gboolean places_indicator_window_is_interesting (PlacesIndicatorWindow* self, GMount* mount) {
	gboolean result = FALSE;
	GMount* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mount;
	_tmp1_ = g_mount_is_shadowed (_tmp0_);
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void places_indicator_window_refresh_mounts (PlacesIndicatorWindow* self) {
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GVolumeMonitor* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GVolumeMonitor* _tmp18_ = NULL;
	GList* _tmp19_ = NULL;
	GtkWidget* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mounts_listbox;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp1_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkWidget* _tmp2_ = NULL;
			GtkWidget* item = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) item_it->data);
			item = _tmp2_;
			{
				GtkWidget* _tmp3_ = NULL;
				_tmp3_ = item;
				gtk_widget_destroy (_tmp3_);
				_g_object_unref0 (item);
			}
		}
		_g_list_free0 (item_collection);
	}
	_tmp4_ = self->priv->volume_monitor;
	_tmp5_ = g_volume_monitor_get_connected_drives (_tmp4_);
	{
		GList* drive_collection = NULL;
		GList* drive_it = NULL;
		drive_collection = _tmp5_;
		for (drive_it = drive_collection; drive_it != NULL; drive_it = drive_it->next) {
			GDrive* _tmp6_ = NULL;
			GDrive* drive = NULL;
			_tmp6_ = _g_object_ref0 ((GDrive*) drive_it->data);
			drive = _tmp6_;
			{
				GDrive* _tmp7_ = NULL;
				GList* _tmp8_ = NULL;
				_tmp7_ = drive;
				_tmp8_ = g_drive_get_volumes (_tmp7_);
				{
					GList* volume_collection = NULL;
					GList* volume_it = NULL;
					volume_collection = _tmp8_;
					for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
						GVolume* _tmp9_ = NULL;
						GVolume* volume = NULL;
						_tmp9_ = _g_object_ref0 ((GVolume*) volume_it->data);
						volume = _tmp9_;
						{
							GMount* mount = NULL;
							GVolume* _tmp10_ = NULL;
							GMount* _tmp11_ = NULL;
							GMount* _tmp12_ = NULL;
							_tmp10_ = volume;
							_tmp11_ = g_volume_get_mount (_tmp10_);
							mount = _tmp11_;
							_tmp12_ = mount;
							if (_tmp12_ == NULL) {
								GVolume* _tmp13_ = NULL;
								_tmp13_ = volume;
								places_indicator_window_add_volume (self, _tmp13_);
							} else {
								GMount* _tmp14_ = NULL;
								GVolume* _tmp15_ = NULL;
								gchar* _tmp16_ = NULL;
								gchar* _tmp17_ = NULL;
								_tmp14_ = mount;
								_tmp15_ = volume;
								_tmp16_ = g_volume_get_identifier (_tmp15_, "class");
								_tmp17_ = _tmp16_;
								places_indicator_window_add_mount (self, _tmp14_, _tmp17_);
								_g_free0 (_tmp17_);
							}
							_g_object_unref0 (mount);
							_g_object_unref0 (volume);
						}
					}
					__g_list_free__g_object_unref0_0 (volume_collection);
				}
				_g_object_unref0 (drive);
			}
		}
		__g_list_free__g_object_unref0_0 (drive_collection);
	}
	_tmp18_ = self->priv->volume_monitor;
	_tmp19_ = g_volume_monitor_get_volumes (_tmp18_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp19_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp20_ = NULL;
			GVolume* volume = NULL;
			_tmp20_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp20_;
			{
				GVolume* _tmp21_ = NULL;
				GDrive* _tmp22_ = NULL;
				GDrive* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				GMount* mount = NULL;
				GVolume* _tmp25_ = NULL;
				GMount* _tmp26_ = NULL;
				GMount* _tmp27_ = NULL;
				_tmp21_ = volume;
				_tmp22_ = g_volume_get_drive (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = _tmp23_ != NULL;
				_g_object_unref0 (_tmp23_);
				if (_tmp24_) {
					_g_object_unref0 (volume);
					continue;
				}
				_tmp25_ = volume;
				_tmp26_ = g_volume_get_mount (_tmp25_);
				mount = _tmp26_;
				_tmp27_ = mount;
				if (_tmp27_ == NULL) {
					GVolume* _tmp28_ = NULL;
					_tmp28_ = volume;
					places_indicator_window_add_volume (self, _tmp28_);
				} else {
					GMount* _tmp29_ = NULL;
					GVolume* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					_tmp29_ = mount;
					_tmp30_ = volume;
					_tmp31_ = g_volume_get_identifier (_tmp30_, "class");
					_tmp32_ = _tmp31_;
					places_indicator_window_add_mount (self, _tmp29_, _tmp32_);
					_g_free0 (_tmp32_);
				}
				_g_object_unref0 (mount);
				_g_object_unref0 (volume);
			}
		}
		__g_list_free__g_object_unref0_0 (volume_collection);
	}
	_tmp33_ = gtk_bin_get_child ((GtkBin*) self);
	gtk_widget_show_all (_tmp33_);
	places_indicator_window_check_expand (self);
}


static void __lambda12_ (PlacesIndicatorWindow* self, const gchar* message_content, GtkMessageType message_type) {
	MessageRevealer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageType _tmp2_ = 0;
	g_return_if_fail (message_content != NULL);
	_tmp0_ = self->priv->message_bar;
	_tmp1_ = message_content;
	_tmp2_ = message_type;
	message_revealer_set_content (_tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda12__volume_item_send_message (VolumeItem* _sender, const gchar* message_content, GtkMessageType message_type, gpointer self) {
	__lambda12_ ((PlacesIndicatorWindow*) self, message_content, message_type);
}


static void places_indicator_window_add_volume (PlacesIndicatorWindow* self, GVolume* volume) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GVolume* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	VolumeItem* volume_item = NULL;
	GVolume* _tmp15_ = NULL;
	VolumeItem* _tmp16_ = NULL;
	GtkListBox* _tmp17_ = NULL;
	VolumeItem* _tmp18_ = NULL;
	VolumeItem* _tmp19_ = NULL;
	GtkContainer* _tmp20_ = NULL;
	VolumeItem* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp2_ = volume;
	_tmp3_ = g_volume_get_identifier (_tmp2_, "class");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "network") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = places_indicator_window_get_show_networks (self);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		GVolume* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp9_ = volume;
		_tmp10_ = g_volume_get_identifier (_tmp9_, "class");
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strcmp0 (_tmp11_, "device") == 0;
		_g_free0 (_tmp11_);
		if (_tmp12_) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = places_indicator_window_get_show_drives (self);
			_tmp14_ = _tmp13_;
			_tmp8_ = !_tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp15_ = volume;
	_tmp16_ = volume_item_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	volume_item = _tmp16_;
	_tmp17_ = self->priv->mounts_listbox;
	_tmp18_ = volume_item;
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = volume_item;
	_tmp20_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp19_);
	gtk_widget_set_can_focus ((GtkWidget*) _tmp20_, FALSE);
	_tmp21_ = volume_item;
	g_signal_connect_object (_tmp21_, "send-message", (GCallback) ___lambda12__volume_item_send_message, self, 0);
	_g_object_unref0 (volume_item);
}


static void __lambda17_ (PlacesIndicatorWindow* self, const gchar* message_content, GtkMessageType message_type) {
	MessageRevealer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageType _tmp2_ = 0;
	g_return_if_fail (message_content != NULL);
	_tmp0_ = self->priv->message_bar;
	_tmp1_ = message_content;
	_tmp2_ = message_type;
	message_revealer_set_content (_tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda17__mount_item_send_message (MountItem* _sender, const gchar* message_content, GtkMessageType message_type, gpointer self) {
	__lambda17_ ((PlacesIndicatorWindow*) self, message_content, message_type);
}


static void places_indicator_window_add_mount (PlacesIndicatorWindow* self, GMount* mount, const gchar* class) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp9_ = FALSE;
	GMount* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GMount* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	MountItem* mount_item = NULL;
	GMount* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	MountItem* _tmp18_ = NULL;
	GtkListBox* _tmp19_ = NULL;
	MountItem* _tmp20_ = NULL;
	MountItem* _tmp21_ = NULL;
	GtkContainer* _tmp22_ = NULL;
	MountItem* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp2_ = class;
	if (g_strcmp0 (_tmp2_, "network") == 0) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = places_indicator_window_get_show_networks (self);
		_tmp4_ = _tmp3_;
		_tmp1_ = !_tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_ = NULL;
		_tmp6_ = class;
		if (g_strcmp0 (_tmp6_, "device") == 0) {
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			_tmp7_ = places_indicator_window_get_show_drives (self);
			_tmp8_ = _tmp7_;
			_tmp5_ = !_tmp8_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp10_ = mount;
	_tmp11_ = g_mount_can_unmount (_tmp10_);
	if (!_tmp11_) {
		GMount* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = mount;
		_tmp13_ = g_mount_can_eject (_tmp12_);
		_tmp9_ = !_tmp13_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		return;
	}
	_tmp14_ = mount;
	_tmp15_ = places_indicator_window_is_interesting (self, _tmp14_);
	if (!_tmp15_) {
		return;
	}
	_tmp16_ = mount;
	_tmp17_ = class;
	_tmp18_ = mount_item_new (_tmp16_, _tmp17_);
	g_object_ref_sink (_tmp18_);
	mount_item = _tmp18_;
	_tmp19_ = self->priv->mounts_listbox;
	_tmp20_ = mount_item;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = mount_item;
	_tmp22_ = (GtkContainer*) gtk_widget_get_parent ((GtkWidget*) _tmp21_);
	gtk_widget_set_can_focus ((GtkWidget*) _tmp22_, FALSE);
	_tmp23_ = mount_item;
	g_signal_connect_object (_tmp23_, "send-message", (GCallback) ___lambda17__mount_item_send_message, self, 0);
	_g_object_unref0 (mount_item);
}


static void places_indicator_window_add_place (PlacesIndicatorWindow* self, const gchar* path, const gchar* class) {
	gchar* unescaped_path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	GFile* file = NULL;
	const gchar* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	PlaceItem* place_item = NULL;
	GFile* _tmp8_ = NULL;
	PlaceItem* _tmp9_ = NULL;
	GHashTable* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	PlacesSection* _tmp13_ = NULL;
	PlaceItem* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (class != NULL);
	_tmp0_ = path;
	_tmp1_ = g_uri_unescape_string (_tmp0_, NULL);
	unescaped_path = _tmp1_;
	_tmp2_ = self->priv->places_list;
	_tmp3_ = unescaped_path;
	_tmp4_ = g_hash_table_contains (_tmp2_, _tmp3_);
	if (_tmp4_) {
		_g_free0 (unescaped_path);
		return;
	}
	_tmp5_ = path;
	if (g_strcmp0 (_tmp5_, "file:/// /") == 0) {
		path = "file:///";
	}
	_tmp6_ = path;
	_tmp7_ = g_file_new_for_uri (_tmp6_);
	file = _tmp7_;
	_tmp8_ = file;
	_tmp9_ = place_item_new (_tmp8_, "place");
	g_object_ref_sink (_tmp9_);
	place_item = _tmp9_;
	_tmp10_ = self->priv->places_list;
	_tmp11_ = unescaped_path;
	_tmp12_ = g_strdup (_tmp11_);
	g_hash_table_add (_tmp10_, _tmp12_);
	_tmp13_ = self->priv->places_section;
	_tmp14_ = place_item;
	places_section_add_item (_tmp13_, _tmp14_);
	_g_object_unref0 (place_item);
	_g_object_unref0 (file);
	_g_free0 (unescaped_path);
}


gboolean places_indicator_window_get_show_places (PlacesIndicatorWindow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_places;
	result = _tmp0_;
	return result;
}


void places_indicator_window_set_show_places (PlacesIndicatorWindow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_places = _tmp0_;
	places_indicator_window_toggle_section_visibility (self, "places");
	g_object_notify ((GObject *) self, "show-places");
}


gboolean places_indicator_window_get_show_drives (PlacesIndicatorWindow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_drives;
	result = _tmp0_;
	return result;
}


void places_indicator_window_set_show_drives (PlacesIndicatorWindow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_drives = _tmp0_;
	places_indicator_window_toggle_section_visibility (self, "drives");
	g_object_notify ((GObject *) self, "show-drives");
}


gboolean places_indicator_window_get_show_networks (PlacesIndicatorWindow* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_show_networks;
	result = _tmp0_;
	return result;
}


void places_indicator_window_set_show_networks (PlacesIndicatorWindow* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_show_networks = _tmp0_;
	places_indicator_window_toggle_section_visibility (self, "networks");
	g_object_notify ((GObject *) self, "show-networks");
}


static void places_indicator_window_class_init (PlacesIndicatorWindowClass * klass) {
	places_indicator_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PlacesIndicatorWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_places_indicator_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_places_indicator_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = places_indicator_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLACES_INDICATOR_WINDOW_SHOW_PLACES, g_param_spec_boolean ("show-places", "show-places", "show-places", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLACES_INDICATOR_WINDOW_SHOW_DRIVES, g_param_spec_boolean ("show-drives", "show-drives", "show-drives", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLACES_INDICATOR_WINDOW_SHOW_NETWORKS, g_param_spec_boolean ("show-networks", "show-networks", "show-networks", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void places_indicator_window_instance_init (PlacesIndicatorWindow * self) {
	GUserDirectory* _tmp0_ = NULL;
	self->priv = PLACES_INDICATOR_WINDOW_GET_PRIVATE (self);
	self->priv->_show_places = TRUE;
	self->priv->_show_drives = TRUE;
	self->priv->_show_networks = TRUE;
	_tmp0_ = g_new0 (GUserDirectory, 5);
	_tmp0_[0] = G_USER_DIRECTORY_DOCUMENTS;
	_tmp0_[1] = G_USER_DIRECTORY_DOWNLOAD;
	_tmp0_[2] = G_USER_DIRECTORY_MUSIC;
	_tmp0_[3] = G_USER_DIRECTORY_PICTURES;
	_tmp0_[4] = G_USER_DIRECTORY_VIDEOS;
	self->priv->DEFAULT_DIRECTORIES = _tmp0_;
	self->priv->DEFAULT_DIRECTORIES_length1 = 5;
	self->priv->_DEFAULT_DIRECTORIES_size_ = self->priv->DEFAULT_DIRECTORIES_length1;
}


static void places_indicator_window_finalize (GObject* obj) {
	PlacesIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindow);
	_g_object_unref0 (self->priv->volume_monitor);
	_g_object_unref0 (self->priv->message_bar);
	_g_object_unref0 (self->priv->places_section);
	_g_object_unref0 (self->priv->mounts_listbox);
	_g_hash_table_unref0 (self->priv->places_list);
	_g_object_unref0 (self->priv->bookmarks_monitor);
	self->priv->DEFAULT_DIRECTORIES = (g_free (self->priv->DEFAULT_DIRECTORIES), NULL);
	G_OBJECT_CLASS (places_indicator_window_parent_class)->finalize (obj);
}


GType places_indicator_window_get_type (void) {
	return places_indicator_window_type_id;
}


GType places_indicator_window_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PlacesIndicatorWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) places_indicator_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlacesIndicatorWindow), 0, (GInstanceInitFunc) places_indicator_window_instance_init, NULL };
	places_indicator_window_type_id = g_type_module_register_type (module, gtk_popover_get_type (), "PlacesIndicatorWindow", &g_define_type_info, 0);
	return places_indicator_window_type_id;
}


static void _vala_places_indicator_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PlacesIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindow);
	switch (property_id) {
		case PLACES_INDICATOR_WINDOW_SHOW_PLACES:
		g_value_set_boolean (value, places_indicator_window_get_show_places (self));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_DRIVES:
		g_value_set_boolean (value, places_indicator_window_get_show_drives (self));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_NETWORKS:
		g_value_set_boolean (value, places_indicator_window_get_show_networks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_places_indicator_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PlacesIndicatorWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PLACES_INDICATOR_WINDOW, PlacesIndicatorWindow);
	switch (property_id) {
		case PLACES_INDICATOR_WINDOW_SHOW_PLACES:
		places_indicator_window_set_show_places (self, g_value_get_boolean (value));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_DRIVES:
		places_indicator_window_set_show_drives (self, g_value_get_boolean (value));
		break;
		case PLACES_INDICATOR_WINDOW_SHOW_NETWORKS:
		places_indicator_window_set_show_networks (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



