/* NotificationsApplet.c generated by valac 0.32.1, the Vala compiler
 * generated from NotificationsApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <libpeas/peas.h>
#include <plugin.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_NOTIFICATIONS_PLUGIN (notifications_plugin_get_type ())
#define NOTIFICATIONS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATIONS_PLUGIN, NotificationsPlugin))
#define NOTIFICATIONS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATIONS_PLUGIN, NotificationsPluginClass))
#define IS_NOTIFICATIONS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATIONS_PLUGIN))
#define IS_NOTIFICATIONS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATIONS_PLUGIN))
#define NOTIFICATIONS_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATIONS_PLUGIN, NotificationsPluginClass))

typedef struct _NotificationsPlugin NotificationsPlugin;
typedef struct _NotificationsPluginClass NotificationsPluginClass;
typedef struct _NotificationsPluginPrivate NotificationsPluginPrivate;

#define TYPE_NOTIFICATIONS_APPLET (notifications_applet_get_type ())
#define NOTIFICATIONS_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATIONS_APPLET, NotificationsApplet))
#define NOTIFICATIONS_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATIONS_APPLET, NotificationsAppletClass))
#define IS_NOTIFICATIONS_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATIONS_APPLET))
#define IS_NOTIFICATIONS_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATIONS_APPLET))
#define NOTIFICATIONS_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATIONS_APPLET, NotificationsAppletClass))

typedef struct _NotificationsApplet NotificationsApplet;
typedef struct _NotificationsAppletClass NotificationsAppletClass;

#define TYPE_RAVEN_REMOTE (raven_remote_get_type ())
#define RAVEN_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RAVEN_REMOTE, RavenRemote))
#define IS_RAVEN_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RAVEN_REMOTE))
#define RAVEN_REMOTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RAVEN_REMOTE, RavenRemoteIface))

typedef struct _RavenRemote RavenRemote;
typedef struct _RavenRemoteIface RavenRemoteIface;

#define TYPE_RAVEN_REMOTE_PROXY (raven_remote_proxy_get_type ())
typedef GDBusProxy RavenRemoteProxy;
typedef GDBusProxyClass RavenRemoteProxyClass;
typedef struct _NotificationsAppletPrivate NotificationsAppletPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _NotificationsPlugin {
	PeasExtensionBase parent_instance;
	NotificationsPluginPrivate * priv;
};

struct _NotificationsPluginClass {
	PeasExtensionBaseClass parent_class;
};

struct _RavenRemoteIface {
	GTypeInterface parent_iface;
	void (*ToggleNotificationsView) (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ToggleNotificationsView_finish) (RavenRemote* self, GAsyncResult* _res_, GError** error);
	void (*GetNotificationCount) (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint (*GetNotificationCount_finish) (RavenRemote* self, GAsyncResult* _res_, GError** error);
};

struct _NotificationsApplet {
	BudgieApplet parent_instance;
	NotificationsAppletPrivate * priv;
};

struct _NotificationsAppletClass {
	BudgieAppletClass parent_class;
};

struct _NotificationsAppletPrivate {
	GtkEventBox* widget;
	GtkImage* icon;
	RavenRemote* raven_proxy;
};


static gpointer notifications_plugin_parent_class = NULL;
static BudgiePluginIface* notifications_plugin_budgie_plugin_parent_iface = NULL;
static GType notifications_plugin_type_id = 0;
static GType raven_remote_type_id = 0;
static gpointer notifications_applet_parent_class = NULL;
static GType notifications_applet_type_id = 0;

GType notifications_plugin_get_type (void) G_GNUC_CONST;
GType notifications_plugin_register_type (GTypeModule * module);
enum  {
	NOTIFICATIONS_PLUGIN_DUMMY_PROPERTY
};
static BudgieApplet* notifications_plugin_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid);
NotificationsApplet* notifications_applet_new (void);
NotificationsApplet* notifications_applet_construct (GType object_type);
GType notifications_applet_get_type (void) G_GNUC_CONST;
GType notifications_applet_register_type (GTypeModule * module);
NotificationsPlugin* notifications_plugin_new (void);
NotificationsPlugin* notifications_plugin_construct (GType object_type);
#define RAVEN_DBUS_NAME "com.solus_project.budgie.Raven"
#define RAVEN_DBUS_OBJECT_PATH "/com/solus_project/budgie/Raven"
GType raven_remote_proxy_get_type (void) G_GNUC_CONST;
void raven_remote_proxy_register_dynamic_type (GTypeModule* module);
guint raven_remote_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType raven_remote_get_type (void) G_GNUC_CONST;
GType raven_remote_register_type (GTypeModule * module);
void raven_remote_ToggleNotificationsView (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void raven_remote_ToggleNotificationsView_finish (RavenRemote* self, GAsyncResult* _res_, GError** error);
void raven_remote_GetNotificationCount (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint raven_remote_GetNotificationCount_finish (RavenRemote* self, GAsyncResult* _res_, GError** error);
static void raven_remote_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_raven_remote_notifications_changed (RavenRemote* self, GVariant* parameters);
static void _dbus_handle_raven_remote_unread_notifications (RavenRemote* self, GVariant* parameters);
static void _dbus_handle_raven_remote_read_notifications (RavenRemote* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void raven_remote_proxy_ToggleNotificationsView_async (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void raven_remote_proxy_ToggleNotificationsView_finish (RavenRemote* self, GAsyncResult* _res_, GError** error);
static void raven_remote_proxy_GetNotificationCount_async (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static guint raven_remote_proxy_GetNotificationCount_finish (RavenRemote* self, GAsyncResult* _res_, GError** error);
static void raven_remote_proxy_raven_remote_interface_init (RavenRemoteIface* iface);
static void _dbus_raven_remote_ToggleNotificationsView (RavenRemote* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_raven_remote_ToggleNotificationsView_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_raven_remote_GetNotificationCount (RavenRemote* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_raven_remote_GetNotificationCount_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void raven_remote_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* raven_remote_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean raven_remote_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_raven_remote_notifications_changed (GObject* _sender, gpointer* _data);
static void _dbus_raven_remote_unread_notifications (GObject* _sender, gpointer* _data);
static void _dbus_raven_remote_read_notifications (GObject* _sender, gpointer* _data);
static void _raven_remote_unregister_object (gpointer user_data);
#define NOTIFICATIONS_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFICATIONS_APPLET, NotificationsAppletPrivate))
enum  {
	NOTIFICATIONS_APPLET_DUMMY_PROPERTY
};
static void notifications_applet_on_raven_get (NotificationsApplet* self, GObject* o, GAsyncResult* res);
static void notifications_applet_on_notifications_changed (NotificationsApplet* self);
static void _notifications_applet_on_notifications_changed_raven_remote_notifications_changed (RavenRemote* _sender, gpointer self);
static void notifications_applet_on_notifications_unread (NotificationsApplet* self);
static void _notifications_applet_on_notifications_unread_raven_remote_unread_notifications (RavenRemote* _sender, gpointer self);
static void notifications_applet_on_notifications_read (NotificationsApplet* self);
static void _notifications_applet_on_notifications_read_raven_remote_read_notifications (RavenRemote* _sender, gpointer self);
static void notifications_applet_on_get_count (NotificationsApplet* self, GObject* o, GAsyncResult* res);
static void _notifications_applet_on_get_count_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean notifications_applet_on_button_release (NotificationsApplet* self, GdkEventButton* button);
static void _notifications_applet_on_raven_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean _notifications_applet_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void notifications_applet_finalize (GObject* obj);
void peas_register_types (GTypeModule* module);

static const GDBusArgInfo * const _raven_remote_dbus_arg_info_ToggleNotificationsView_in[] = {NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_ToggleNotificationsView_out[] = {NULL};
static const GDBusMethodInfo _raven_remote_dbus_method_info_ToggleNotificationsView = {-1, "ToggleNotificationsView", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_ToggleNotificationsView_in), (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_ToggleNotificationsView_out)};
static const GDBusArgInfo _raven_remote_dbus_arg_info_GetNotificationCount_result = {-1, "result", "u"};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_GetNotificationCount_in[] = {NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_GetNotificationCount_out[] = {&_raven_remote_dbus_arg_info_GetNotificationCount_result, NULL};
static const GDBusMethodInfo _raven_remote_dbus_method_info_GetNotificationCount = {-1, "GetNotificationCount", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_GetNotificationCount_in), (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_GetNotificationCount_out)};
static const GDBusMethodInfo * const _raven_remote_dbus_method_info[] = {&_raven_remote_dbus_method_info_ToggleNotificationsView, &_raven_remote_dbus_method_info_GetNotificationCount, NULL};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_notifications_changed[] = {NULL};
static const GDBusSignalInfo _raven_remote_dbus_signal_info_notifications_changed = {-1, "NotificationsChanged", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_notifications_changed)};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_unread_notifications[] = {NULL};
static const GDBusSignalInfo _raven_remote_dbus_signal_info_unread_notifications = {-1, "UnreadNotifications", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_unread_notifications)};
static const GDBusArgInfo * const _raven_remote_dbus_arg_info_read_notifications[] = {NULL};
static const GDBusSignalInfo _raven_remote_dbus_signal_info_read_notifications = {-1, "ReadNotifications", (GDBusArgInfo **) (&_raven_remote_dbus_arg_info_read_notifications)};
static const GDBusSignalInfo * const _raven_remote_dbus_signal_info[] = {&_raven_remote_dbus_signal_info_notifications_changed, &_raven_remote_dbus_signal_info_unread_notifications, &_raven_remote_dbus_signal_info_read_notifications, NULL};
static const GDBusPropertyInfo * const _raven_remote_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _raven_remote_dbus_interface_info = {-1, "com.solus_project.budgie.Raven", (GDBusMethodInfo **) (&_raven_remote_dbus_method_info), (GDBusSignalInfo **) (&_raven_remote_dbus_signal_info), (GDBusPropertyInfo **) (&_raven_remote_dbus_property_info)};
static const GDBusInterfaceVTable _raven_remote_dbus_interface_vtable = {raven_remote_dbus_interface_method_call, raven_remote_dbus_interface_get_property, raven_remote_dbus_interface_set_property};

static BudgieApplet* notifications_plugin_real_get_panel_widget (BudgiePlugin* base, const gchar* uuid) {
	NotificationsPlugin * self;
	BudgieApplet* result = NULL;
	NotificationsApplet* _tmp0_ = NULL;
	self = (NotificationsPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = notifications_applet_new ();
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}


NotificationsPlugin* notifications_plugin_construct (GType object_type) {
	NotificationsPlugin * self = NULL;
	self = (NotificationsPlugin*) g_object_new (object_type, NULL);
	return self;
}


NotificationsPlugin* notifications_plugin_new (void) {
	return notifications_plugin_construct (TYPE_NOTIFICATIONS_PLUGIN);
}


static void notifications_plugin_class_init (NotificationsPluginClass * klass) {
	notifications_plugin_parent_class = g_type_class_peek_parent (klass);
}


static void notifications_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface) {
	notifications_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*)(BudgiePlugin*, const gchar*)) notifications_plugin_real_get_panel_widget;
}


static void notifications_plugin_instance_init (NotificationsPlugin * self) {
}


GType notifications_plugin_get_type (void) {
	return notifications_plugin_type_id;
}


GType notifications_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsPlugin), 0, (GInstanceInitFunc) notifications_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) notifications_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	notifications_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "NotificationsPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, notifications_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return notifications_plugin_type_id;
}


void raven_remote_ToggleNotificationsView (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RAVEN_REMOTE_GET_INTERFACE (self)->ToggleNotificationsView (self, _callback_, _user_data_);
}


void raven_remote_ToggleNotificationsView_finish (RavenRemote* self, GAsyncResult* _res_, GError** error) {
	RAVEN_REMOTE_GET_INTERFACE (self)->ToggleNotificationsView_finish (self, _res_, error);
}


void raven_remote_GetNotificationCount (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RAVEN_REMOTE_GET_INTERFACE (self)->GetNotificationCount (self, _callback_, _user_data_);
}


guint raven_remote_GetNotificationCount_finish (RavenRemote* self, GAsyncResult* _res_, GError** error) {
	return RAVEN_REMOTE_GET_INTERFACE (self)->GetNotificationCount_finish (self, _res_, error);
}


static void raven_remote_base_init (RavenRemoteIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("notifications_changed", TYPE_RAVEN_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("unread_notifications", TYPE_RAVEN_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("read_notifications", TYPE_RAVEN_REMOTE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	}
}


GType raven_remote_get_type (void) {
	return raven_remote_type_id;
}


GType raven_remote_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RavenRemoteIface), (GBaseInitFunc) raven_remote_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	raven_remote_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "RavenRemote", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (raven_remote_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (raven_remote_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) raven_remote_proxy_get_type);
	g_type_set_qdata (raven_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.solus_project.budgie.Raven");
	g_type_set_qdata (raven_remote_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_raven_remote_dbus_interface_info));
	g_type_set_qdata (raven_remote_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) raven_remote_register_object);
	return raven_remote_type_id;
}


G_DEFINE_DYNAMIC_TYPE_EXTENDED (RavenRemoteProxy, raven_remote_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_RAVEN_REMOTE, raven_remote_proxy_raven_remote_interface_init) )
static void raven_remote_proxy_class_init (RavenRemoteProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = raven_remote_proxy_g_signal;
}


static void _dbus_handle_raven_remote_notifications_changed (RavenRemote* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "notifications-changed");
}


static void _dbus_handle_raven_remote_unread_notifications (RavenRemote* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "unread-notifications");
}


static void _dbus_handle_raven_remote_read_notifications (RavenRemote* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "read-notifications");
}


static void raven_remote_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "NotificationsChanged") == 0) {
		_dbus_handle_raven_remote_notifications_changed ((RavenRemote*) proxy, parameters);
	} else if (strcmp (signal_name, "UnreadNotifications") == 0) {
		_dbus_handle_raven_remote_unread_notifications ((RavenRemote*) proxy, parameters);
	} else if (strcmp (signal_name, "ReadNotifications") == 0) {
		_dbus_handle_raven_remote_read_notifications ((RavenRemote*) proxy, parameters);
	}
}


static void raven_remote_proxy_class_finalize (RavenRemoteProxyClass* klass) {
}


void raven_remote_proxy_register_dynamic_type (GTypeModule* module) {
	raven_remote_proxy_register_type (module);
}


static void raven_remote_proxy_init (RavenRemoteProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void raven_remote_proxy_ToggleNotificationsView_async (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.solus_project.budgie.Raven", "ToggleNotificationsView");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void raven_remote_proxy_ToggleNotificationsView_finish (RavenRemote* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void raven_remote_proxy_GetNotificationCount_async (RavenRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.solus_project.budgie.Raven", "GetNotificationCount");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static guint raven_remote_proxy_GetNotificationCount_finish (RavenRemote* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint _result;
	GVariant* _tmp0_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return 0U;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return 0U;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static void raven_remote_proxy_raven_remote_interface_init (RavenRemoteIface* iface) {
	iface->ToggleNotificationsView = raven_remote_proxy_ToggleNotificationsView_async;
	iface->ToggleNotificationsView_finish = raven_remote_proxy_ToggleNotificationsView_finish;
	iface->GetNotificationCount = raven_remote_proxy_GetNotificationCount_async;
	iface->GetNotificationCount_finish = raven_remote_proxy_GetNotificationCount_finish;
}


static void _dbus_raven_remote_ToggleNotificationsView (RavenRemote* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	raven_remote_ToggleNotificationsView (self, (GAsyncReadyCallback) _dbus_raven_remote_ToggleNotificationsView_ready, invocation);
}


static void _dbus_raven_remote_ToggleNotificationsView_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	raven_remote_ToggleNotificationsView_finish ((RavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_raven_remote_GetNotificationCount (RavenRemote* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	raven_remote_GetNotificationCount (self, (GAsyncReadyCallback) _dbus_raven_remote_GetNotificationCount_ready, invocation);
}


static void _dbus_raven_remote_GetNotificationCount_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint result;
	invocation = _user_data_;
	result = raven_remote_GetNotificationCount_finish ((RavenRemote*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void raven_remote_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ToggleNotificationsView") == 0) {
		_dbus_raven_remote_ToggleNotificationsView (object, parameters, invocation);
	} else if (strcmp (method_name, "GetNotificationCount") == 0) {
		_dbus_raven_remote_GetNotificationCount (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* raven_remote_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean raven_remote_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_raven_remote_notifications_changed (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.budgie.Raven", "NotificationsChanged", _arguments, NULL);
}


static void _dbus_raven_remote_unread_notifications (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.budgie.Raven", "UnreadNotifications", _arguments, NULL);
}


static void _dbus_raven_remote_read_notifications (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.budgie.Raven", "ReadNotifications", _arguments, NULL);
}


guint raven_remote_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_raven_remote_dbus_interface_info), &_raven_remote_dbus_interface_vtable, data, _raven_remote_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "notifications-changed", (GCallback) _dbus_raven_remote_notifications_changed, data);
	g_signal_connect (object, "unread-notifications", (GCallback) _dbus_raven_remote_unread_notifications, data);
	g_signal_connect (object, "read-notifications", (GCallback) _dbus_raven_remote_read_notifications, data);
	return result;
}


static void _raven_remote_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_remote_notifications_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_remote_unread_notifications, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_raven_remote_read_notifications, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _notifications_applet_on_notifications_changed_raven_remote_notifications_changed (RavenRemote* _sender, gpointer self) {
	notifications_applet_on_notifications_changed ((NotificationsApplet*) self);
}


static void _notifications_applet_on_notifications_unread_raven_remote_unread_notifications (RavenRemote* _sender, gpointer self) {
	notifications_applet_on_notifications_unread ((NotificationsApplet*) self);
}


static void _notifications_applet_on_notifications_read_raven_remote_read_notifications (RavenRemote* _sender, gpointer self) {
	notifications_applet_on_notifications_read ((NotificationsApplet*) self);
}


static void _notifications_applet_on_get_count_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	notifications_applet_on_get_count ((NotificationsApplet*) self, source_object, res);
	g_object_unref (self);
}


static void notifications_applet_on_raven_get (NotificationsApplet* self, GObject* o, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		RavenRemote* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		RavenRemote* _tmp2_ = NULL;
		RavenRemote* _tmp3_ = NULL;
		RavenRemote* _tmp4_ = NULL;
		RavenRemote* _tmp5_ = NULL;
		RavenRemote* _tmp6_ = NULL;
		RavenRemote* _tmp7_ = NULL;
		RavenRemote* _tmp8_ = NULL;
		_tmp1_ = res;
		_tmp2_ = g_async_result_get_source_object (_tmp1_);
		_tmp3_ = g_async_initable_new_finish (_tmp2_, _tmp1_, &_inner_error_);
		g_object_unref (_tmp2_);
		_tmp0_ = (RavenRemote*) _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->raven_proxy);
		self->priv->raven_proxy = _tmp4_;
		_tmp5_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp5_, "notifications-changed", (GCallback) _notifications_applet_on_notifications_changed_raven_remote_notifications_changed, self, 0);
		_tmp6_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp6_, "unread-notifications", (GCallback) _notifications_applet_on_notifications_unread_raven_remote_unread_notifications, self, 0);
		_tmp7_ = self->priv->raven_proxy;
		g_signal_connect_object (_tmp7_, "read-notifications", (GCallback) _notifications_applet_on_notifications_read_raven_remote_read_notifications, self, 0);
		_tmp8_ = self->priv->raven_proxy;
		raven_remote_GetNotificationCount (_tmp8_, _notifications_applet_on_get_count_gasync_ready_callback, g_object_ref (self));
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("NotificationsApplet.vala:49: Failed to gain Raven proxy: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void notifications_applet_on_notifications_read (NotificationsApplet* self) {
	GtkImage* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "alert");
}


static void notifications_applet_on_notifications_unread (NotificationsApplet* self) {
	GtkImage* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_add_class (_tmp1_, "alert");
}


static void notifications_applet_on_get_count (NotificationsApplet* self, GObject* o, GAsyncResult* res) {
	guint count = 0U;
	guint _tmp6_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	count = (guint) 0;
	{
		guint _tmp0_ = 0U;
		RavenRemote* _tmp1_ = NULL;
		GAsyncResult* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		_tmp1_ = self->priv->raven_proxy;
		_tmp2_ = res;
		_tmp3_ = raven_remote_GetNotificationCount_finish (_tmp1_, _tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		count = _tmp0_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("NotificationsApplet.vala:70: Error getting notifications: %s", _tmp5_);
		_g_error_free0 (e);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = count;
	if (_tmp6_ > ((guint) 1)) {
		GtkImage* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp7_ = self->priv->icon;
		_tmp8_ = _ ("%u unread notifications");
		_tmp9_ = count;
		_tmp10_ = g_strdup_printf (_tmp8_, _tmp9_);
		_tmp11_ = _tmp10_;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _tmp11_);
		_g_free0 (_tmp11_);
	} else {
		guint _tmp12_ = 0U;
		_tmp12_ = count;
		if (_tmp12_ == ((guint) 1)) {
			GtkImage* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			_tmp13_ = self->priv->icon;
			_tmp14_ = _ ("1 unread notification");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp13_, _tmp14_);
		} else {
			GtkImage* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			_tmp15_ = self->priv->icon;
			_tmp16_ = _ ("No unread notifications");
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _tmp16_);
		}
	}
}


static void notifications_applet_on_notifications_changed (NotificationsApplet* self) {
	RavenRemote* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->raven_proxy;
	raven_remote_GetNotificationCount (_tmp0_, _notifications_applet_on_get_count_gasync_ready_callback, g_object_ref (self));
}


static gboolean notifications_applet_on_button_release (NotificationsApplet* self, GdkEventButton* button) {
	gboolean result = FALSE;
	RavenRemote* _tmp0_ = NULL;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->raven_proxy;
	if (_tmp0_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp1_ = button;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	{
		RavenRemote* _tmp3_ = NULL;
		_tmp3_ = self->priv->raven_proxy;
		raven_remote_ToggleNotificationsView (_tmp3_, NULL, NULL);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_message ("NotificationsApplet.vala:100: Failed to toggle Raven: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = GDK_EVENT_STOP;
	return result;
}


static void _notifications_applet_on_raven_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	notifications_applet_on_raven_get ((NotificationsApplet*) self, source_object, res);
	g_object_unref (self);
}


static gboolean _notifications_applet_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = notifications_applet_on_button_release ((NotificationsApplet*) self, event);
	return result;
}


NotificationsApplet* notifications_applet_construct (GType object_type) {
	NotificationsApplet * self = NULL;
	GtkEventBox* _tmp0_ = NULL;
	GtkEventBox* _tmp1_ = NULL;
	GtkImage* _tmp2_ = NULL;
	GtkEventBox* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkEventBox* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = (NotificationsApplet*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp0_;
	_tmp1_ = self->priv->widget;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("notification-alert-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp2_;
	_tmp3_ = self->priv->widget;
	_tmp4_ = self->priv->icon;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->icon;
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = self->priv->icon;
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	g_async_initable_new_async (TYPE_RAVEN_REMOTE_PROXY, 0, NULL, _notifications_applet_on_raven_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", RAVEN_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", RAVEN_DBUS_OBJECT_PATH, "g-interface-name", "com.solus_project.budgie.Raven", "g-interface-info", g_type_get_qdata (TYPE_RAVEN_REMOTE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
	_tmp7_ = self->priv->widget;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "button-release-event", (GCallback) _notifications_applet_on_button_release_gtk_widget_button_release_event, self, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}


NotificationsApplet* notifications_applet_new (void) {
	return notifications_applet_construct (TYPE_NOTIFICATIONS_APPLET);
}


static void notifications_applet_class_init (NotificationsAppletClass * klass) {
	notifications_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NotificationsAppletPrivate));
	G_OBJECT_CLASS (klass)->finalize = notifications_applet_finalize;
}


static void notifications_applet_instance_init (NotificationsApplet * self) {
	self->priv = NOTIFICATIONS_APPLET_GET_PRIVATE (self);
	self->priv->raven_proxy = NULL;
}


static void notifications_applet_finalize (GObject* obj) {
	NotificationsApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFICATIONS_APPLET, NotificationsApplet);
	_g_object_unref0 (self->priv->widget);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->priv->raven_proxy);
	G_OBJECT_CLASS (notifications_applet_parent_class)->finalize (obj);
}


GType notifications_applet_get_type (void) {
	return notifications_applet_type_id;
}


GType notifications_applet_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (NotificationsAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notifications_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotificationsApplet), 0, (GInstanceInitFunc) notifications_applet_instance_init, NULL };
	notifications_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "NotificationsApplet", &g_define_type_info, 0);
	return notifications_applet_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void peas_register_types (GTypeModule* module) {
	PeasObjectModule* objmodule = NULL;
	GTypeModule* _tmp0_ = NULL;
	PeasObjectModule* _tmp1_ = NULL;
	g_return_if_fail (module != NULL);
	notifications_plugin_register_type (module);
	notifications_applet_register_type (module);
	raven_remote_register_type (module);
	raven_remote_proxy_register_dynamic_type (module);
	_tmp0_ = module;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, peas_object_module_get_type ()) ? ((PeasObjectModule*) _tmp0_) : NULL);
	objmodule = _tmp1_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_NOTIFICATIONS_PLUGIN);
	_g_object_unref0 (objmodule);
}



