/* toplevel.c generated by valac 0.32.1, the Vala compiler
 * generated from toplevel.vala, do not modify */

/*
 * This file is part of budgie-desktop.
 *
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <plugin.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define BUDGIE_TYPE_TOPLEVEL (budgie_toplevel_get_type ())
#define BUDGIE_TOPLEVEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_TOPLEVEL, BudgieToplevel))
#define BUDGIE_TOPLEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_TOPLEVEL, BudgieToplevelClass))
#define BUDGIE_IS_TOPLEVEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_TOPLEVEL))
#define BUDGIE_IS_TOPLEVEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_TOPLEVEL))
#define BUDGIE_TOPLEVEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_TOPLEVEL, BudgieToplevelClass))

typedef struct _BudgieToplevel BudgieToplevel;
typedef struct _BudgieToplevelClass BudgieToplevelClass;
typedef struct _BudgieToplevelPrivate BudgieToplevelPrivate;

#define BUDGIE_TYPE_PANEL_POSITION (budgie_panel_position_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_APPLET_PACK_TYPE (budgie_applet_pack_type_get_type ())

#define BUDGIE_TYPE_APPLET_ALIGNMENT (budgie_applet_alignment_get_type ())

struct _BudgieToplevel {
	GtkWindow parent_instance;
	BudgieToplevelPrivate * priv;
};

struct _BudgieToplevelClass {
	GtkWindowClass parent_class;
	void (*reset_shadow) (BudgieToplevel* self);
	GList* (*get_applets) (BudgieToplevel* self);
	gboolean (*can_move_applet_left) (BudgieToplevel* self, BudgieAppletInfo* info);
	gboolean (*can_move_applet_right) (BudgieToplevel* self, BudgieAppletInfo* info);
	void (*move_applet_left) (BudgieToplevel* self, BudgieAppletInfo* info);
	void (*move_applet_right) (BudgieToplevel* self, BudgieAppletInfo* info);
	void (*add_new_applet) (BudgieToplevel* self, const gchar* id);
	void (*remove_applet) (BudgieToplevel* self, BudgieAppletInfo* info);
};

typedef enum  {
	BUDGIE_PANEL_POSITION_NONE = 1 << 0,
	BUDGIE_PANEL_POSITION_BOTTOM = 1 << 1,
	BUDGIE_PANEL_POSITION_TOP = 1 << 2,
	BUDGIE_PANEL_POSITION_LEFT = 1 << 3,
	BUDGIE_PANEL_POSITION_RIGHT = 1 << 4
} BudgiePanelPosition;

struct _BudgieToplevelPrivate {
	gint _shadow_width;
	gint _shadow_depth;
	gint _intended_size;
	gboolean _shadow_visible;
	gboolean _theme_regions;
	gchar* _uuid;
	BudgiePanelPosition _position;
};

typedef enum  {
	BUDGIE_APPLET_PACK_TYPE_START = 1 << 0,
	BUDGIE_APPLET_PACK_TYPE_END = 1 << 2
} BudgieAppletPackType;

typedef enum  {
	BUDGIE_APPLET_ALIGNMENT_START = 1 << 0,
	BUDGIE_APPLET_ALIGNMENT_CENTER = 1 << 1,
	BUDGIE_APPLET_ALIGNMENT_END = 1 << 2
} BudgieAppletAlignment;


static gpointer budgie_toplevel_parent_class = NULL;

GType budgie_toplevel_get_type (void) G_GNUC_CONST;
GType budgie_panel_position_get_type (void) G_GNUC_CONST;
#define BUDGIE_TOPLEVEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_TOPLEVEL, BudgieToplevelPrivate))
enum  {
	BUDGIE_TOPLEVEL_DUMMY_PROPERTY,
	BUDGIE_TOPLEVEL_SHADOW_WIDTH,
	BUDGIE_TOPLEVEL_SHADOW_DEPTH,
	BUDGIE_TOPLEVEL_INTENDED_SIZE,
	BUDGIE_TOPLEVEL_SHADOW_VISIBLE,
	BUDGIE_TOPLEVEL_THEME_REGIONS,
	BUDGIE_TOPLEVEL_UUID,
	BUDGIE_TOPLEVEL_POSITION
};
void budgie_toplevel_reset_shadow (BudgieToplevel* self);
static void budgie_toplevel_real_reset_shadow (BudgieToplevel* self);
GList* budgie_toplevel_get_applets (BudgieToplevel* self);
static GList* budgie_toplevel_real_get_applets (BudgieToplevel* self);
gboolean budgie_toplevel_can_move_applet_left (BudgieToplevel* self, BudgieAppletInfo* info);
static gboolean budgie_toplevel_real_can_move_applet_left (BudgieToplevel* self, BudgieAppletInfo* info);
gboolean budgie_toplevel_can_move_applet_right (BudgieToplevel* self, BudgieAppletInfo* info);
static gboolean budgie_toplevel_real_can_move_applet_right (BudgieToplevel* self, BudgieAppletInfo* info);
void budgie_toplevel_move_applet_left (BudgieToplevel* self, BudgieAppletInfo* info);
static void budgie_toplevel_real_move_applet_left (BudgieToplevel* self, BudgieAppletInfo* info);
void budgie_toplevel_move_applet_right (BudgieToplevel* self, BudgieAppletInfo* info);
static void budgie_toplevel_real_move_applet_right (BudgieToplevel* self, BudgieAppletInfo* info);
void budgie_toplevel_add_new_applet (BudgieToplevel* self, const gchar* id);
static void budgie_toplevel_real_add_new_applet (BudgieToplevel* self, const gchar* id);
void budgie_toplevel_remove_applet (BudgieToplevel* self, BudgieAppletInfo* info);
static void budgie_toplevel_real_remove_applet (BudgieToplevel* self, BudgieAppletInfo* info);
BudgieToplevel* budgie_toplevel_construct (GType object_type);
gint budgie_toplevel_get_shadow_width (BudgieToplevel* self);
void budgie_toplevel_set_shadow_width (BudgieToplevel* self, gint value);
gint budgie_toplevel_get_shadow_depth (BudgieToplevel* self);
void budgie_toplevel_set_shadow_depth (BudgieToplevel* self, gint value);
gint budgie_toplevel_get_intended_size (BudgieToplevel* self);
void budgie_toplevel_set_intended_size (BudgieToplevel* self, gint value);
gboolean budgie_toplevel_get_shadow_visible (BudgieToplevel* self);
void budgie_toplevel_set_shadow_visible (BudgieToplevel* self, gboolean value);
gboolean budgie_toplevel_get_theme_regions (BudgieToplevel* self);
void budgie_toplevel_set_theme_regions (BudgieToplevel* self, gboolean value);
const gchar* budgie_toplevel_get_uuid (BudgieToplevel* self);
void budgie_toplevel_set_uuid (BudgieToplevel* self, const gchar* value);
BudgiePanelPosition budgie_toplevel_get_position (BudgieToplevel* self);
void budgie_toplevel_set_position (BudgieToplevel* self, BudgiePanelPosition value);
static void budgie_toplevel_finalize (GObject* obj);
static void _vala_budgie_toplevel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_toplevel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
void budgie_set_struts (GtkWindow* window, BudgiePanelPosition position, glong panel_size);
GType budgie_applet_pack_type_get_type (void) G_GNUC_CONST;
GType budgie_applet_alignment_get_type (void) G_GNUC_CONST;
gchar* budgie_position_class_name (BudgiePanelPosition position);


static void budgie_toplevel_real_reset_shadow (BudgieToplevel* self) {
}


void budgie_toplevel_reset_shadow (BudgieToplevel* self) {
	g_return_if_fail (self != NULL);
	BUDGIE_TOPLEVEL_GET_CLASS (self)->reset_shadow (self);
}


static GList* budgie_toplevel_real_get_applets (BudgieToplevel* self) {
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_get_applets'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GList* budgie_toplevel_get_applets (BudgieToplevel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return BUDGIE_TOPLEVEL_GET_CLASS (self)->get_applets (self);
}


static gboolean budgie_toplevel_real_can_move_applet_left (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_can_move_applet_left'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean budgie_toplevel_can_move_applet_left (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_return_val_if_fail (self != NULL, FALSE);
	return BUDGIE_TOPLEVEL_GET_CLASS (self)->can_move_applet_left (self, info);
}


static gboolean budgie_toplevel_real_can_move_applet_right (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_can_move_applet_right'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean budgie_toplevel_can_move_applet_right (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_return_val_if_fail (self != NULL, FALSE);
	return BUDGIE_TOPLEVEL_GET_CLASS (self)->can_move_applet_right (self, info);
}


static void budgie_toplevel_real_move_applet_left (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_move_applet_left'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void budgie_toplevel_move_applet_left (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_return_if_fail (self != NULL);
	BUDGIE_TOPLEVEL_GET_CLASS (self)->move_applet_left (self, info);
}


static void budgie_toplevel_real_move_applet_right (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_move_applet_right'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void budgie_toplevel_move_applet_right (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_return_if_fail (self != NULL);
	BUDGIE_TOPLEVEL_GET_CLASS (self)->move_applet_right (self, info);
}


static void budgie_toplevel_real_add_new_applet (BudgieToplevel* self, const gchar* id) {
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_add_new_applet'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void budgie_toplevel_add_new_applet (BudgieToplevel* self, const gchar* id) {
	g_return_if_fail (self != NULL);
	BUDGIE_TOPLEVEL_GET_CLASS (self)->add_new_applet (self, id);
}


static void budgie_toplevel_real_remove_applet (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_critical ("Type `%s' does not implement abstract method `budgie_toplevel_remove_applet'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void budgie_toplevel_remove_applet (BudgieToplevel* self, BudgieAppletInfo* info) {
	g_return_if_fail (self != NULL);
	BUDGIE_TOPLEVEL_GET_CLASS (self)->remove_applet (self, info);
}


BudgieToplevel* budgie_toplevel_construct (GType object_type) {
	BudgieToplevel * self = NULL;
	self = (BudgieToplevel*) g_object_new (object_type, NULL);
	return self;
}


gint budgie_toplevel_get_shadow_width (BudgieToplevel* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_shadow_width;
	result = _tmp0_;
	return result;
}


void budgie_toplevel_set_shadow_width (BudgieToplevel* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_shadow_width = _tmp0_;
	g_object_notify ((GObject *) self, "shadow-width");
}


gint budgie_toplevel_get_shadow_depth (BudgieToplevel* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_shadow_depth;
	result = _tmp0_;
	return result;
}


void budgie_toplevel_set_shadow_depth (BudgieToplevel* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_shadow_depth = _tmp0_;
	g_object_notify ((GObject *) self, "shadow-depth");
}


gint budgie_toplevel_get_intended_size (BudgieToplevel* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_intended_size;
	result = _tmp0_;
	return result;
}


void budgie_toplevel_set_intended_size (BudgieToplevel* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_intended_size = _tmp0_;
	g_object_notify ((GObject *) self, "intended-size");
}


gboolean budgie_toplevel_get_shadow_visible (BudgieToplevel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_shadow_visible;
	result = _tmp0_;
	return result;
}


void budgie_toplevel_set_shadow_visible (BudgieToplevel* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_shadow_visible = _tmp0_;
	g_object_notify ((GObject *) self, "shadow-visible");
}


gboolean budgie_toplevel_get_theme_regions (BudgieToplevel* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_theme_regions;
	result = _tmp0_;
	return result;
}


void budgie_toplevel_set_theme_regions (BudgieToplevel* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_theme_regions = _tmp0_;
	g_object_notify ((GObject *) self, "theme-regions");
}


const gchar* budgie_toplevel_get_uuid (BudgieToplevel* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}


void budgie_toplevel_set_uuid (BudgieToplevel* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uuid);
	self->priv->_uuid = _tmp1_;
	g_object_notify ((GObject *) self, "uuid");
}


BudgiePanelPosition budgie_toplevel_get_position (BudgieToplevel* self) {
	BudgiePanelPosition result;
	BudgiePanelPosition _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_position;
	result = _tmp0_;
	return result;
}


void budgie_toplevel_set_position (BudgieToplevel* self, BudgiePanelPosition value) {
	BudgiePanelPosition _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_position = _tmp0_;
	g_object_notify ((GObject *) self, "position");
}


static void budgie_toplevel_class_init (BudgieToplevelClass * klass) {
	budgie_toplevel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieToplevelPrivate));
	((BudgieToplevelClass *) klass)->reset_shadow = budgie_toplevel_real_reset_shadow;
	((BudgieToplevelClass *) klass)->get_applets = budgie_toplevel_real_get_applets;
	((BudgieToplevelClass *) klass)->can_move_applet_left = budgie_toplevel_real_can_move_applet_left;
	((BudgieToplevelClass *) klass)->can_move_applet_right = budgie_toplevel_real_can_move_applet_right;
	((BudgieToplevelClass *) klass)->move_applet_left = budgie_toplevel_real_move_applet_left;
	((BudgieToplevelClass *) klass)->move_applet_right = budgie_toplevel_real_move_applet_right;
	((BudgieToplevelClass *) klass)->add_new_applet = budgie_toplevel_real_add_new_applet;
	((BudgieToplevelClass *) klass)->remove_applet = budgie_toplevel_real_remove_applet;
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_toplevel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_toplevel_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_toplevel_finalize;
	/**
	     * Length of our shadow component, to enable Raven blending
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_SHADOW_WIDTH, g_param_spec_int ("shadow-width", "shadow-width", "shadow-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Depth of our shadow component, to enable Raven blending
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_SHADOW_DEPTH, g_param_spec_int ("shadow-depth", "shadow-depth", "shadow-depth", G_MININT, G_MAXINT, 5, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Our required size (height or width dependening on orientation
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_INTENDED_SIZE, g_param_spec_int ("intended-size", "intended-size", "intended-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_SHADOW_VISIBLE, g_param_spec_boolean ("shadow-visible", "shadow-visible", "shadow-visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_THEME_REGIONS, g_param_spec_boolean ("theme-regions", "theme-regions", "theme-regions", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Unique identifier for this panel
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_UUID, g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_TOPLEVEL_POSITION, g_param_spec_flags ("position", "position", "position", BUDGIE_TYPE_PANEL_POSITION, BUDGIE_PANEL_POSITION_BOTTOM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("applet_added", BUDGIE_TYPE_TOPLEVEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, budgie_applet_info_get_type ());
	g_signal_new ("applet_removed", BUDGIE_TYPE_TOPLEVEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("applets_changed", BUDGIE_TYPE_TOPLEVEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void budgie_toplevel_instance_init (BudgieToplevel * self) {
	self->priv = BUDGIE_TOPLEVEL_GET_PRIVATE (self);
	self->priv->_shadow_depth = 5;
	self->priv->_position = BUDGIE_PANEL_POSITION_BOTTOM;
}


static void budgie_toplevel_finalize (GObject* obj) {
	BudgieToplevel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel);
	_g_free0 (self->priv->_uuid);
	G_OBJECT_CLASS (budgie_toplevel_parent_class)->finalize (obj);
}


GType budgie_toplevel_get_type (void) {
	static volatile gsize budgie_toplevel_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_toplevel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieToplevelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_toplevel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieToplevel), 0, (GInstanceInitFunc) budgie_toplevel_instance_init, NULL };
		GType budgie_toplevel_type_id;
		budgie_toplevel_type_id = g_type_register_static (gtk_window_get_type (), "BudgieToplevel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&budgie_toplevel_type_id__volatile, budgie_toplevel_type_id);
	}
	return budgie_toplevel_type_id__volatile;
}


static void _vala_budgie_toplevel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieToplevel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel);
	switch (property_id) {
		case BUDGIE_TOPLEVEL_SHADOW_WIDTH:
		g_value_set_int (value, budgie_toplevel_get_shadow_width (self));
		break;
		case BUDGIE_TOPLEVEL_SHADOW_DEPTH:
		g_value_set_int (value, budgie_toplevel_get_shadow_depth (self));
		break;
		case BUDGIE_TOPLEVEL_INTENDED_SIZE:
		g_value_set_int (value, budgie_toplevel_get_intended_size (self));
		break;
		case BUDGIE_TOPLEVEL_SHADOW_VISIBLE:
		g_value_set_boolean (value, budgie_toplevel_get_shadow_visible (self));
		break;
		case BUDGIE_TOPLEVEL_THEME_REGIONS:
		g_value_set_boolean (value, budgie_toplevel_get_theme_regions (self));
		break;
		case BUDGIE_TOPLEVEL_UUID:
		g_value_set_string (value, budgie_toplevel_get_uuid (self));
		break;
		case BUDGIE_TOPLEVEL_POSITION:
		g_value_set_flags (value, budgie_toplevel_get_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_toplevel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieToplevel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_TOPLEVEL, BudgieToplevel);
	switch (property_id) {
		case BUDGIE_TOPLEVEL_SHADOW_WIDTH:
		budgie_toplevel_set_shadow_width (self, g_value_get_int (value));
		break;
		case BUDGIE_TOPLEVEL_SHADOW_DEPTH:
		budgie_toplevel_set_shadow_depth (self, g_value_get_int (value));
		break;
		case BUDGIE_TOPLEVEL_INTENDED_SIZE:
		budgie_toplevel_set_intended_size (self, g_value_get_int (value));
		break;
		case BUDGIE_TOPLEVEL_SHADOW_VISIBLE:
		budgie_toplevel_set_shadow_visible (self, g_value_get_boolean (value));
		break;
		case BUDGIE_TOPLEVEL_THEME_REGIONS:
		budgie_toplevel_set_theme_regions (self, g_value_get_boolean (value));
		break;
		case BUDGIE_TOPLEVEL_UUID:
		budgie_toplevel_set_uuid (self, g_value_get_string (value));
		break;
		case BUDGIE_TOPLEVEL_POSITION:
		budgie_toplevel_set_position (self, g_value_get_flags (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void budgie_set_struts (GtkWindow* window, BudgiePanelPosition position, glong panel_size) {
	GdkAtom atom = 0U;
	GdkRectangle primary_monitor_rect = {0};
	glong struts[12] = {0};
	GdkScreen* screen = NULL;
	GtkWindow* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GdkScreen* _tmp3_ = NULL;
	gint mon = 0;
	GdkScreen* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GdkScreen* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GdkRectangle _tmp8_ = {0};
	GtkWindow* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	BudgiePanelPosition _tmp11_ = 0;
	GdkAtom _tmp52_ = 0U;
	GtkWindow* _tmp53_ = NULL;
	GdkWindow* _tmp54_ = NULL;
	GdkAtom _tmp55_ = 0U;
	GdkAtom _tmp56_ = 0U;
	_tmp0_ = window;
	_tmp1_ = gtk_window_get_screen (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	screen = _tmp3_;
	_tmp4_ = screen;
	_tmp5_ = gdk_screen_get_primary_monitor (_tmp4_);
	mon = _tmp5_;
	_tmp6_ = screen;
	_tmp7_ = mon;
	gdk_screen_get_monitor_geometry (_tmp6_, _tmp7_, &_tmp8_);
	primary_monitor_rect = _tmp8_;
	_tmp9_ = window;
	_tmp10_ = gtk_widget_get_realized ((GtkWidget*) _tmp9_);
	if (!_tmp10_) {
		_g_object_unref0 (screen);
		return;
	}
	_tmp11_ = position;
	switch (_tmp11_) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			GdkRectangle _tmp12_ = {0};
			gint _tmp13_ = 0;
			glong _tmp14_ = 0L;
			GdkRectangle _tmp15_ = {0};
			gint _tmp16_ = 0;
			GdkRectangle _tmp17_ = {0};
			gint _tmp18_ = 0;
			GdkRectangle _tmp19_ = {0};
			gint _tmp20_ = 0;
			glong _tmp21_[12] = {0};
			_tmp12_ = primary_monitor_rect;
			_tmp13_ = _tmp12_.y;
			_tmp14_ = panel_size;
			_tmp15_ = primary_monitor_rect;
			_tmp16_ = _tmp15_.x;
			_tmp17_ = primary_monitor_rect;
			_tmp18_ = _tmp17_.x;
			_tmp19_ = primary_monitor_rect;
			_tmp20_ = _tmp19_.width;
			_tmp21_[0] = (glong) 0;
			_tmp21_[1] = (glong) 0;
			_tmp21_[2] = _tmp13_ + _tmp14_;
			_tmp21_[3] = (glong) 0;
			_tmp21_[4] = (glong) 0;
			_tmp21_[5] = (glong) 0;
			_tmp21_[6] = (glong) 0;
			_tmp21_[7] = (glong) 0;
			_tmp21_[8] = (glong) _tmp16_;
			_tmp21_[9] = (glong) ((_tmp18_ + _tmp20_) - 1);
			_tmp21_[10] = (glong) 0;
			_tmp21_[11] = (glong) 0;
			memcpy (struts, _tmp21_, 12 * sizeof (glong));
			break;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			glong _tmp22_ = 0L;
			GdkRectangle _tmp23_ = {0};
			gint _tmp24_ = 0;
			GdkRectangle _tmp25_ = {0};
			gint _tmp26_ = 0;
			GdkRectangle _tmp27_ = {0};
			gint _tmp28_ = 0;
			glong _tmp29_[12] = {0};
			_tmp22_ = panel_size;
			_tmp23_ = primary_monitor_rect;
			_tmp24_ = _tmp23_.y;
			_tmp25_ = primary_monitor_rect;
			_tmp26_ = _tmp25_.y;
			_tmp27_ = primary_monitor_rect;
			_tmp28_ = _tmp27_.height;
			_tmp29_[0] = _tmp22_;
			_tmp29_[1] = (glong) 0;
			_tmp29_[2] = (glong) 0;
			_tmp29_[3] = (glong) 0;
			_tmp29_[4] = (glong) _tmp24_;
			_tmp29_[5] = (glong) (_tmp26_ + _tmp28_);
			_tmp29_[6] = (glong) 0;
			_tmp29_[7] = (glong) 0;
			_tmp29_[8] = (glong) 0;
			_tmp29_[9] = (glong) 0;
			_tmp29_[10] = (glong) 0;
			_tmp29_[11] = (glong) 0;
			memcpy (struts, _tmp29_, 12 * sizeof (glong));
			break;
		}
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			glong _tmp30_ = 0L;
			GdkRectangle _tmp31_ = {0};
			gint _tmp32_ = 0;
			GdkRectangle _tmp33_ = {0};
			gint _tmp34_ = 0;
			GdkRectangle _tmp35_ = {0};
			gint _tmp36_ = 0;
			glong _tmp37_[12] = {0};
			_tmp30_ = panel_size;
			_tmp31_ = primary_monitor_rect;
			_tmp32_ = _tmp31_.y;
			_tmp33_ = primary_monitor_rect;
			_tmp34_ = _tmp33_.y;
			_tmp35_ = primary_monitor_rect;
			_tmp36_ = _tmp35_.height;
			_tmp37_[0] = (glong) 0;
			_tmp37_[1] = _tmp30_;
			_tmp37_[2] = (glong) 0;
			_tmp37_[3] = (glong) 0;
			_tmp37_[4] = (glong) 0;
			_tmp37_[5] = (glong) 0;
			_tmp37_[6] = (glong) _tmp32_;
			_tmp37_[7] = (glong) (_tmp34_ + _tmp36_);
			_tmp37_[8] = (glong) 0;
			_tmp37_[9] = (glong) 0;
			_tmp37_[10] = (glong) 0;
			_tmp37_[11] = (glong) 0;
			memcpy (struts, _tmp37_, 12 * sizeof (glong));
			break;
		}
		default:
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			GdkScreen* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			GdkRectangle _tmp40_ = {0};
			gint _tmp41_ = 0;
			GdkRectangle _tmp42_ = {0};
			gint _tmp43_ = 0;
			glong _tmp44_ = 0L;
			GdkRectangle _tmp45_ = {0};
			gint _tmp46_ = 0;
			GdkRectangle _tmp47_ = {0};
			gint _tmp48_ = 0;
			GdkRectangle _tmp49_ = {0};
			gint _tmp50_ = 0;
			glong _tmp51_[12] = {0};
			_tmp38_ = screen;
			_tmp39_ = gdk_screen_get_height (_tmp38_);
			_tmp40_ = primary_monitor_rect;
			_tmp41_ = _tmp40_.height;
			_tmp42_ = primary_monitor_rect;
			_tmp43_ = _tmp42_.y;
			_tmp44_ = panel_size;
			_tmp45_ = primary_monitor_rect;
			_tmp46_ = _tmp45_.x;
			_tmp47_ = primary_monitor_rect;
			_tmp48_ = _tmp47_.x;
			_tmp49_ = primary_monitor_rect;
			_tmp50_ = _tmp49_.width;
			_tmp51_[0] = (glong) 0;
			_tmp51_[1] = (glong) 0;
			_tmp51_[2] = (glong) 0;
			_tmp51_[3] = ((_tmp39_ - _tmp41_) - _tmp43_) + _tmp44_;
			_tmp51_[4] = (glong) 0;
			_tmp51_[5] = (glong) 0;
			_tmp51_[6] = (glong) 0;
			_tmp51_[7] = (glong) 0;
			_tmp51_[8] = (glong) 0;
			_tmp51_[9] = (glong) 0;
			_tmp51_[10] = (glong) _tmp46_;
			_tmp51_[11] = (glong) ((_tmp48_ + _tmp50_) - 1);
			memcpy (struts, _tmp51_, 12 * sizeof (glong));
			break;
		}
	}
	_tmp52_ = gdk_atom_intern ("_NET_WM_STRUT_PARTIAL", FALSE);
	atom = _tmp52_;
	_tmp53_ = window;
	_tmp54_ = gtk_widget_get_window ((GtkWidget*) _tmp53_);
	_tmp55_ = atom;
	_tmp56_ = gdk_atom_intern ("CARDINAL", FALSE);
	gdk_property_change (_tmp54_, _tmp55_, _tmp56_, 32, GDK_PROP_MODE_REPLACE, (const guchar*) ((guint8*) struts), 12);
	_g_object_unref0 (screen);
}


GType budgie_panel_position_get_type (void) {
	static volatile gsize budgie_panel_position_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_panel_position_type_id__volatile)) {
		static const GFlagsValue values[] = {{BUDGIE_PANEL_POSITION_NONE, "BUDGIE_PANEL_POSITION_NONE", "none"}, {BUDGIE_PANEL_POSITION_BOTTOM, "BUDGIE_PANEL_POSITION_BOTTOM", "bottom"}, {BUDGIE_PANEL_POSITION_TOP, "BUDGIE_PANEL_POSITION_TOP", "top"}, {BUDGIE_PANEL_POSITION_LEFT, "BUDGIE_PANEL_POSITION_LEFT", "left"}, {BUDGIE_PANEL_POSITION_RIGHT, "BUDGIE_PANEL_POSITION_RIGHT", "right"}, {0, NULL, NULL}};
		GType budgie_panel_position_type_id;
		budgie_panel_position_type_id = g_flags_register_static ("BudgiePanelPosition", values);
		g_once_init_leave (&budgie_panel_position_type_id__volatile, budgie_panel_position_type_id);
	}
	return budgie_panel_position_type_id__volatile;
}


GType budgie_applet_pack_type_get_type (void) {
	static volatile gsize budgie_applet_pack_type_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_applet_pack_type_type_id__volatile)) {
		static const GFlagsValue values[] = {{BUDGIE_APPLET_PACK_TYPE_START, "BUDGIE_APPLET_PACK_TYPE_START", "start"}, {BUDGIE_APPLET_PACK_TYPE_END, "BUDGIE_APPLET_PACK_TYPE_END", "end"}, {0, NULL, NULL}};
		GType budgie_applet_pack_type_type_id;
		budgie_applet_pack_type_type_id = g_flags_register_static ("BudgieAppletPackType", values);
		g_once_init_leave (&budgie_applet_pack_type_type_id__volatile, budgie_applet_pack_type_type_id);
	}
	return budgie_applet_pack_type_type_id__volatile;
}


GType budgie_applet_alignment_get_type (void) {
	static volatile gsize budgie_applet_alignment_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_applet_alignment_type_id__volatile)) {
		static const GFlagsValue values[] = {{BUDGIE_APPLET_ALIGNMENT_START, "BUDGIE_APPLET_ALIGNMENT_START", "start"}, {BUDGIE_APPLET_ALIGNMENT_CENTER, "BUDGIE_APPLET_ALIGNMENT_CENTER", "center"}, {BUDGIE_APPLET_ALIGNMENT_END, "BUDGIE_APPLET_ALIGNMENT_END", "end"}, {0, NULL, NULL}};
		GType budgie_applet_alignment_type_id;
		budgie_applet_alignment_type_id = g_flags_register_static ("BudgieAppletAlignment", values);
		g_once_init_leave (&budgie_applet_alignment_type_id__volatile, budgie_applet_alignment_type_id);
	}
	return budgie_applet_alignment_type_id__volatile;
}


gchar* budgie_position_class_name (BudgiePanelPosition position) {
	gchar* result = NULL;
	BudgiePanelPosition _tmp0_ = 0;
	_tmp0_ = position;
	switch (_tmp0_) {
		case BUDGIE_PANEL_POSITION_TOP:
		{
			gchar* _tmp1_ = NULL;
			_tmp1_ = g_strdup ("top");
			result = _tmp1_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_BOTTOM:
		{
			gchar* _tmp2_ = NULL;
			_tmp2_ = g_strdup ("bottom");
			result = _tmp2_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_LEFT:
		{
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("left");
			result = _tmp3_;
			return result;
		}
		case BUDGIE_PANEL_POSITION_RIGHT:
		{
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("right");
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_ = NULL;
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		}
	}
}



