/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef _Tar_h_
#define _Tar_h_

/*------- include files:
-------------------------------------------------------------------*/
#include<qwidget.h>
#include<qstring.h>
#include<vector>

/*------- forward declaration:
-------------------------------------------------------------------*/
class QProcess;

/*------- class declaration:
-------------------------------------------------------------------*/
class Tar : public QObject
{
	Q_OBJECT
// ******* types *******
public:
	typedef enum {
		TAR = 0,
		GZIP,
	} COMPRESS_MODE;
private:
	typedef enum {
		NONE = 0,
		CREATE,
		UPDATE,
		REMOVE,
		EXTRACT
	} CMD;

public:
	Tar( QWidget* const parent, const QString& dstPath, const COMPRESS_MODE cm = TAR );
	
// ******* members *******
private:
	static const QString GZIP_EXT;
	static const QString TAR_EXT;
		
	COMPRESS_MODE        _cm;
	QString              _tarPath;
	QString              _zipPath;
	QString              _workDir;
	QProcess*            _process;
	bool                 _ok;
	std::vector<QString> _v;
	CMD                  _cmd;
	int                  _idx;
	
// ******* methods *******
public:
	bool create                 ( const QString& workDir, const std::vector<QString>& v );
	
private:
	void process                ();
	void removeExt              ( QString& fpath, const QString& ext );
	void end                    ();
private slots:
	void readFromStdout         ();
	void readFromStderr         ();
	void processExited          ();
signals:
	void message                ( const QString& msg );
	void error                  ( const QString& msg );
	void finish                 ();
};

#endif // _Tar_h_
