
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#include "brighton.h"
#include "brightonMini.h"
#include "bristolhelp.h"

extern brightonApp miniApp;
extern brightonApp prophetApp;
extern brightonApp hammondApp;
extern brightonApp junoApp;
extern brightonApp dxApp;
extern brightonApp explorerApp;
extern brightonApp mixApp;
extern brightonApp hammondB3App;
extern brightonApp voxApp;
extern brightonApp rhodesApp;
extern brightonApp pro10App;

char *bristolhome = NULL;

guimain global;

brightonApp *synthesisers[16];

/*
 * Need to make this multithreaded?
 */
int
main(int argc, char **argv)
{
	int argCount = 1;

	signal(SIGINT, cleanupBristol);

	global.home = getenv("BRISTOL");

	global.synths = (guiSynth *) brightonmalloc(sizeof(guiSynth));

	global.voices = 16;
	global.synths->voices = 16;
	global.port = -1;

	synthesisers[BRISTOL_MINI] = &miniApp;
	synthesisers[BRISTOL_PROPHET] = &prophetApp;
	synthesisers[BRISTOL_HAMMOND] = &hammondApp;
	synthesisers[BRISTOL_JUNO] = &junoApp;
	synthesisers[BRISTOL_DX] = &dxApp;
	synthesisers[BRISTOL_EXPLORER] = &explorerApp;
	synthesisers[BRISTOL_HAMMONDB3] = &hammondB3App;
	synthesisers[BRISTOL_VOX] = &voxApp;
	synthesisers[BRISTOL_RHODES] = &rhodesApp;
	synthesisers[BRISTOL_PROPHET10] = &pro10App;
	synthesisers[BRISTOL_MIXER] = &mixApp;

	/*
	 * close our standard input, create a pipe which will never be used.
	 */
	while (argc > argCount)
	{
		if ((strcmp(argv[argCount], "--help") == 0)
			|| (strcmp(argv[argCount], "-help") == 0)
			|| (strcmp(argv[argCount], "-h") == 0)
			|| (strcmp(argv[argCount], "--h") == 0))
		{
			printf("%s", helptext);
			exit(0);
		}

		if (strcmp(argv[argCount], "-libtest") == 0)
			global.libtest = 1;

		if ((strcmp(argv[argCount], "-voices") == 0) && (argCount < argc))
		{
			if (argCount < argc)
				global.synths->voices = atoi(argv[argCount + 1]);
			argCount++;
		}

		if ((strcmp(argv[argCount], "-channel") == 0) && (argCount < argc))
		{
			if (argCount < argc)
				global.synths->midichannel = atoi(argv[argCount + 1]) - 1;
			argCount++;
		}

		if (strcmp(argv[argCount], "-engine") == 0)
			global.flags |= BRIGHTON_NOENGINE;

		if (strcmp(argv[argCount], "-port") == 0)
		{
			if (argCount < argc)
				global.port = atoi(argv[++argCount]);
		}

		/*
		 * And finally all the different synths
		 */
		if (strcmp(argv[argCount], "-mini") == 0)
			global.synths->synthtype = BRISTOL_MINI;

		if (strcmp(argv[argCount], "-hammond") == 0)
			global.synths->synthtype = BRISTOL_HAMMOND;

		if (strcmp(argv[argCount], "-prophet") == 0)
			global.synths->synthtype = BRISTOL_PROPHET;

		if (strcmp(argv[argCount], "-pro5") == 0)
			global.synths->synthtype = BRISTOL_PROPHET;

		if (strcmp(argv[argCount], "-pro10") == 0)
			global.synths->synthtype = BRISTOL_PROPHET10;

		if (strcmp(argv[argCount], "-dx") == 0)
			global.synths->synthtype = BRISTOL_DX;

		if (strcmp(argv[argCount], "-juno") == 0)
			global.synths->synthtype = BRISTOL_JUNO;

		if (strcmp(argv[argCount], "-sampler") == 0)
			global.synths->synthtype = BRISTOL_SAMPLER;

		if (strcmp(argv[argCount], "-bristol") == 0)
			global.synths->synthtype = BRISTOL_BRISTOL;

		if (strcmp(argv[argCount], "-voyager") == 0)
			global.synths->synthtype = BRISTOL_EXPLORER;

		if (strcmp(argv[argCount], "-explorer") == 0)
			global.synths->synthtype = BRISTOL_EXPLORER;

		if (strcmp(argv[argCount], "-mixer") == 0)
			global.synths->synthtype = BRISTOL_MIXER;

		if (strcmp(argv[argCount], "-rhodes") == 0)
			global.synths->synthtype = BRISTOL_RHODES;

		if (strcmp(argv[argCount], "-vox") == 0)
			global.synths->synthtype = BRISTOL_VOX;

		if (strcmp(argv[argCount], "-ddd") == 0)
			global.synths->synthtype = BRISTOL_DDD;

		if (strcmp(argv[argCount], "-pro52") == 0)
			global.synths->synthtype = BRISTOL_PRO52;

		if (strcmp(argv[argCount], "-b3") == 0)
			global.synths->synthtype = BRISTOL_HAMMONDB3;

		argCount++;
	}

	if (synthesisers[global.synths->synthtype] == 0)
		exit(0);

	global.synths->resources = synthesisers[global.synths->synthtype];
	/*
	 * connid is actually set by the configuration routines, but we use it 
	 * here anyway.
	 */
	global.synths->connid =
		(int) brightonInterface(synthesisers[global.synths->synthtype]);

	/*
	 * connid is actually set by the configuration routines, but we use it 
	 * here anyway.
	global.flags |= BRIGHTON_NOENGINE;
	global.synths->next = (guiSynth *) brightonmalloc(sizeof(guiSynth));
	global.synths->next->last = global.synths;
	global.synths->next->voices = 16;
	global.synths->next->midichannel = 2;
	global.synths->next->resources = synthesisers[BRISTOL_JUNO];
	global.synths->next->synthtype = BRISTOL_JUNO;
	global.synths->next->connid = (int)
		brightonInterface(synthesisers[BRISTOL_JUNO]);
printf("	PAIR IS %x %x, %x %x\n", global.synths, global.synths->next,
global.synths->connid, global.synths->next->connid);
	 */

	/*
	 * Finally go and let the event manager handle our interface.
	 */
	brightonEventMgr();
}


cleanout(void *id)
{
	if (id)
		brightonRemoveInterface(id);
	cleanupBristol();
	exit(0);
}


clearout(int result)
{
	exit(result);
}

