
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "brightonX11internals.h"
#include "icon_bitmap.xbm"

char *args[2] = {"bristol gui", (char *) 0};

bdisplay *
BOpenWindow(brightonDisplay *display, brightonWindow *bwin, char *programme)
{
	bdisplay *bd = (bdisplay *) display->display;

	bwin->win = (void *) XCreateSimpleWindow(bd->display,
		RootWindow(bd->display,
		bd->screen_num),
		bd->x, bd->y,
		bwin->width, bwin->height, bd->border,
		BlackPixel(bd->display, bd->screen_num),
		WhitePixel(bd->display, bd->screen_num));

	bd->icon_pixmap = XCreateBitmapFromData(bd->display, (Window) bwin->win,
		icon_bitmap_bits, icon_bitmap_width, icon_bitmap_height);

	bd->size_hints.flags = PPosition|PSize|PMinSize;
	bd->size_hints.min_width = 150;
	bd->size_hints.min_height = 100;

	bd->icon_name = programme;
	bwin->window_name = programme;

	if (XStringListToTextProperty(&bd->icon_name, 1, &bd->iconName) == 0)
	{
		printf("%s: allocation error for icon failed\n", programme);
		display->bwin = 0;
		brightonfree(bwin);
		return(0);
	}
	if (XStringListToTextProperty(&bwin->window_name, 1, &bd->windowName)
		== 0)
	{
		printf("%s: allocation error for icon failed\n", programme);
		display->bwin = 0;
		brightonfree(bwin);
		return(0);
	}

	bd->wm_hints.initial_state = NormalState;
	bd->wm_hints.input = True;
	bd->wm_hints.icon_pixmap = bd->icon_pixmap;
	bd->wm_hints.flags = StateHint|IconPixmapHint|InputHint;

	bd->class_hints.res_name = programme;
	bd->class_hints.res_class = "BasicWin";

	XSetWMProperties(bd->display, (Window) bwin->win,
		&bd->windowName, &bd->iconName, args, 1,
		&bd->size_hints, &bd->wm_hints, &bd->class_hints);

	XSelectInput(bd->display, (Window) bwin->win,
		KeyPressMask|KeyReleaseMask|ButtonPressMask|ButtonReleaseMask|
		EnterWindowMask|LeaveWindowMask
//		|PointerMotionMask|PointerMotionHintMask
		|Button1MotionMask|Button2MotionMask|
		Button3MotionMask|Button4MotionMask|Button5MotionMask|
		ButtonMotionMask|KeymapStateMask|ExposureMask|
		VisibilityChangeMask|StructureNotifyMask|
		SubstructureNotifyMask|SubstructureRedirectMask|FocusChangeMask|
		PropertyChangeMask|ColormapChangeMask|OwnerGrabButtonMask);

	XMapWindow(bd->display, (Window) bwin->win);

	/* Incorrect location? Should maybe be in win structure? */

	bwin->gc = DefaultGC(bd->display, bd->screen_num);

	return(bwin->win);
}

int
BCloseWindow(brightonDisplay *display, brightonWindow *bwin)
{
	bdisplay *bd = display->display;

	XDestroyWindow(bd->display, (Window) bwin->win);

	return(0);
}

int BGetGeometry(brightonDisplay *display, brightonWindow *bwin)
{
	bdisplay *bd = display->display;

	if (XGetGeometry(bd->display, RootWindow(bd->display, bd->screen_num),
		&bd->root, &bd->x, &bd->y, &bd->width, &bd->height,
		&bd->border, &bd->depth) < 0)
		printf("cannot get root window geometry\n");

	/*
	 * I would prefer for these to come from the bitmap itself.
	 */
	bwin->width = bd->width;
	bwin->height = bd->height;
	bwin->depth = bd->depth;
}

BFlush(brightonDisplay *display)
{
	bdisplay *bd = (bdisplay *) display->display;

	XFlush(bd->display);
}

