#ifndef _ORNAMENT_H_
#define _ORNAMENT_H_

#include "atom.h"
#include "position.h"

/**
 * This abstract class serves as a template for anything that may be associated with a note, like bows and lyrics. So far the following ornaments are defined:
 * <pre>
 * Bow         - a bow is parameterized by its direction (UP, DOWN) and its length
 * Expression  - an expression is parameterized by its character (an int) and its displacement from the note
 * Lyrics      - lyrics contain each a syllable associated with the note
 * Riemann     - can be used to store information about harmony and function
 * </pre>
 **/
class Ornament : public Atoma
{
 private:

 public:
  /**
   * Default Constructor
   **/
  Ornament();

  /**
   * Copy Constructor
   **/
  Ornament(const Ornament&);

  
  /**
   * Implementation of the print method
  **/
  virtual ostream & print(int,ostream&) const = 0;

  /**
   * Implementation of the flush method
  **/
  virtual void flush(const char*) const = 0;

  /**
   * Implementation of the copy method
  **/
  virtual Element * copy() const = 0;

  /**
   * Always returns false, since ornaments never are events
   **/
  virtual bool isEvent() const { return false; }
};

#endif
