#ifndef _MOVEPART_CPP_
#define _MOVEPART_CPP_

#include <iostream.h>

#include "movePart.h"
#include "element.h"
#include "compound.h"

#include "part.h"
#include "track.h"
#include "song.h"
extern Song * sonG;

MovePart::MovePart(Position p, Part * pt, Track * src, Track * tgt)
  : _part(pt), _src(src), _tgt(tgt), _old(pt->start()), _new(p) {
  _type = MOVEPART;
  _description = "move part";
  _to_be_undone = true;
  if (_part) {
    if (_src!=_tgt) {
      _src->remove(_part);
      _tgt->add(_part);
      _part->setTrack(_tgt);
    }
    _part->setStart(_new);
  }
}

MovePart::MovePart(const MovePart& el) : Operation(el) {
  _type = MOVEPART;
  _part = el._part;
  _old = el._old;
  _new = el._new;
}

MovePart::~MovePart() {
}

void MovePart::undo() {
  if (_part) {
    if (_src!=_tgt) {
      _tgt->remove(_part);
      _src->add(_part);
      _part->setTrack(_src);
    }
    _part->setStart(_old);
  }
}

void MovePart::redo() {
  if (_part) {
    if (_src!=_tgt) {
      _src->remove(_part);
      _tgt->add(_part);
      _part->setTrack(_tgt);
    }
    _part->setStart(_new);
  }
}



// ---------------
// virtuals:
//

ostream & MovePart::print(int dep, ostream & s) const {
  s << spc(dep) << "<MOVEPART part=\"" << _part << "\" old=\"" << _old << "\" new=\"" << _new << "\" />" << endl;
  return s;
}

void MovePart::flush(const char * c) const {
  cout << c << "MOVEPART" << endl;
}

Element * MovePart::copy() const {
  return new MovePart(*this);
}




#endif
