#ifndef _ADDON_CPP_
#define _ADDON_CPP_

#include <iostream.h>

#include "addon.h"
#include "element.h"

extern Table * selectioN;

void foo(Element*) {}

Addon::Addon(char * des, Element* tgt, bool undoable, int con) : _target(tgt), _context(con) {
  _type = ADDON;
  _description = des; // was "addon"
  _to_be_undone = undoable;
}

Addon::~Addon() {}

void Addon::run() {
  int type = _target==0 ? -1 : _target->isA();
  if ((type==SCORETRACK)||(type==DRUMTRACK)||(type==MASTERTRACK)||(type==AUDIOTRACK)||(type==COMMENTTRACK)) type = TRACK;
  switch (type) {
  case -1: if (_context&TREAT_SELECTION) selection(selectioN); break;
  case PART: if (_context&TREAT_PART) part((Part*)_target); break;
  case TRACK: if (_context&TREAT_TRACK) track((Track*)_target); break;
  case SONG: if (_context&TREAT_SONG) song((Song*)_target); break;
  default: if (_context&TREAT_GLOBAL) global(); break;
  }
}

int Addon::context() { return _context; }

bool Addon::context(int con) { return _context&con; }

void Addon::selection(Table * selection) { cout << "selection context not implemented" << endl; foo((Element*) selection); }

void Addon::part(Part * part) { cout << "part context not implemented" << endl; foo((Element*) part); }

void Addon::track(Track * track) { cout << "track context not implemented" << endl; foo((Element*) track); }

void Addon::song(Song * song) { cout << "song context not implemented" << endl; foo((Element*) song); }

void Addon::global() { cout << "global context not implemented" << endl; }

void Addon::undo() {}

void Addon::redo() {}

ostream & Addon::print(int dep, ostream & s) const {
  s << spc(dep) << "<ADDON NAME=\"" << _description << "\" />" << endl;
  return s;
}

void Addon::flush(const char * c) const {
  cout << c << "ADDON " << _description << endl;
}

Element * Addon::copy() const {
  return 0;
}

#endif
