#ifndef _SCOREBREAK_CPP_
#define _SCOREBREAK_CPP_

#include <iostream.h>

#include "scoreBreak.h"
#include "prScorePainter.h"
#include "prScoreEditor.h"
#include "prFactory.h"

extern PrFactory * factory;


/*ScoreBreak::ScoreBreak(Position pos, int len) : ScoreElement(pos,len) {

}*/

ScoreBreak::ScoreBreak() {
}

ScoreBreak::~ScoreBreak() {
  // TODO!!!
}

void ScoreBreak::add(Note * note, Position pos, long dur, int dis, bool _no_overlap) {
  setStart(pos);
  setDuration(dur);
  setDisplay(dis);
}


bool ScoreBreak::isBreak() const { return true; }

bool ScoreBreak::isChord() const { return false; }

bool ScoreBreak::hasNoFlags() const { return true; }



ostream & ScoreBreak::print(int dep, ostream & s) const {
  s << spc(dep) << "<SCOREBREAK start=\"" << start() << "\" duration=\"" << duration() << "\" display=\"" << display() << "\" / >" << endl;
  // s << spc(dep) << "</SCOREBREAK>" << endl;
  return s;
}

void ScoreBreak::flush(const char * c) const {
  cout << c << "SCOREBREAK" << endl;
}

Element * ScoreBreak::copy() const {
  return new ScoreBreak();
}


void ScoreBreak::paint(PrScoreEditor * ed, int x, int y, int) {
  factory->getScorePainter()->paintBreak(this, ed, x, y);
}

void ScoreBreak::print(PrScoreEditor * ed, int x, int y) {
  factory->getScorePrinter()->paintBreak(this, ed, x, y);
}


#endif

