#!/bin/bash
#
# splash.sh - This shell script triggers bootsplash actions during
# system boot/shutdown. It can be run by the init scripts repeatedly
# specifying the currently executed system script.
# 
# This script is used to play animations/sounds/show text/move the
# progress bar, etc.
# 
# We call this function from /etc/rc.status:rc_splash() 
#
# This program is free software; you may redistribute it under 
# the terms of the GNU General Public License. This program has 
# absolutely no warranty.
#
# written 2002-2003 Stefan Reinauer, <stepan@suse.de>
# Debianized 2004 by Sascha Schroeder, <schroeder.sascha@web.de>
# with modifications from Matthew A. Nicholson, <debian@matt-land.com>
# adapted 2006 by Pablo Chinea <khertz@gmail.com>
#
# this script expects the following environment variable for an operable
# progress bar:
#
#  progress = percent of the progress (this value is negative if the system
#             is shutting down).
#
# To play animations, it's advised that you have an animations.cfg in your
# theme's config directory specifying the initscript name for an event and
# the command to be executed:
#
#   fsck start:bootanim start bounce.mng
#   master:bootanim stop
#
# See http://www.bootsplash.org/ for more information.
#

_procsplash="`cat /proc/splash 2>/dev/null`"

THEME="No bootsplash theme selected"
test -f /etc/default/bootsplash && . /etc/default/bootsplash
test ! -d "/etc/bootsplash/themes/$THEME" && exit 0

# parse animations.cfg. This part should not be handled by the
# splash binary.

if [ -f /etc/bootsplash/themes/$THEME/config/animations.cfg ]; then
	COMMAND="`cat /etc/bootsplash/themes/$THEME/config/animations.cfg | grep "^$1" | sed -e 's/^.*\://g;'`"
	eval $COMMAND
fi

# assertions
test -r /proc/splash || exit 0
test -z "`echo $_procsplash | grep on`" && exit 0

# We chose verbose in grub
test "`cat /proc/cmdline | grep \"splash=silent\"`" == "" && exit 0 

# acquire data
# 
_shutdown="no"
_silent="no"
test "`cat /proc/splash | grep silent`" && _silent="yes"
test "$runlevel" == "0" -o "$runlevel" == "6" && _shutdown="yes"
test -z "$progress" && progress=0
test $progress -lt 0 && progress="$(( $progress * -1 ))"


function box() { true; } # ignore box descriptions in the config file

test -f "/etc/bootsplash/themes/$THEME/config/bootsplash-`fbresolution`.cfg" && \
	. /etc/bootsplash/themes/$THEME/config/bootsplash-`fbresolution`.cfg

#
# Print text string. (Booting/Shutting down the system. Press
# F2 for verbose mode)
#

if [ "$1" == "mountkernfs.sh start" -o "$1" == "bootsplash stop" ]; then
	if [ x$_shutdown == xyes ]; then
		_msg=$MSG_SHUTDOWN; # may be defined in /etc/default/bootsplash
		[ -z "$_msg" ] && _msg="Shutting down the system... Press F2 for verbose mode"
	else
		_msg=$MSG_BOOT; # may be defined in /etc/default/bootsplash
		[ -z "$_msg" ] && _msg="Booting the system... Press F2 for verbose mode"
	fi

	if [ "$text_x" != "" -a "$text_y" != "" \
		-a "$text_color" != "" -a "$text_size" != "" -a "$_silent" == "yes" ]; 
	then
		case "$USE_STATIC_FBT" in
			[Yy]*)
				fbtruetype="fbtruetype.static"
				;;
			*)
				fbtruetype="fbtruetype"
				;;
		esac
		$fbtruetype -x $text_x -y $text_y -t $text_color -s $text_size "$_msg"
	fi
fi

#
# Now paint the progressbar. This is done via the proc 
# interface of the bootsplash.
#

echo "show $(( 65534 * ( $progress ) / 100 ))" > /proc/splash
