#ifndef _DBOOTSTRAP_H_
#define _DBOOTSTRAP_H_

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <time.h>
#include <utime.h>
#include <syslog.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <unistd.h>
#include <ctype.h>
#include "../libfdisk/fdisk.h"
#include "boxes.h"

#define USER_SETTINGS_DIR  "/root"
#define USER_SETTINGS_FILE "/root/dbootstrap_settings"

/* Some useful definitions swiped from busybox. */
#define FALSE   ((int) 1)
#define TRUE    ((int) 0)
#define BUF_SIZE        8192

#define KERNEL_FLAG ".disk/kernel_installable"
#define BASE_FLAG ".disk/base_installable"

#define KERNEL_VERSION(a,b) (((a) << 16) + ((b) << 8))

/* temporary config file for keyboard settings */
#define KEYBD_SETTINGS_FILE "/tmp/keybd_settings"

#define ARCHIVE_LOCATION "dists/woody/main/disks-%s/current"
/* See: "main.c:setup_image_names()" */
#define BASEDEBS "basedebs.tar"
#define DEBIAN_ARCHIVE_PREFIX "dists/woody/main/binary-"
#define ADDONS  "addons.tgz"
#define KERDISKFILE "rescue.bin"
#define DRVTGZFILE "drivers.tgz"

/* see netconfig.c */
#define NC_HOSTNAME_FILE   "/etc/hostname"

#if defined(_TESTING_) || defined (_BOXTESTING_) || defined (_STESTING_) || defined(_EXETESTING_)
#	define TRMFILE "test.trm"
#else
#	define TRMFILE "/etc/messages.trm"
#endif
#ifdef USE_LANGUAGE_CHOOSER
#	define TRMBACKUP "/etc/messages.en"
#else
#	define TRMBACKUP "./po/C.trm"
#endif

#ifdef _TESTING_
#	define _(String) String
#else
#	include <libintl.h>
#	define _(String) gettext(String)
#endif

#ifdef UTF8
#define  CLEAR "[H[2J"
#else
#define  CLEAR "[H[J"
#endif

#define SYSLOG_IDENT "dbootstrap"
#define INFOMSG(format...)				\
do {							\
	openlog(SYSLOG_IDENT, LOG_PID, LOG_USER);	\
	syslog(LOG_INFO, format);			\
	closelog();					\
} while (0)
#define ERRMSG(format...)				\
do {							\
	openlog(SYSLOG_IDENT, LOG_PID, LOG_USER);	\
	syslog(LOG_ERR, format);			\
	closelog();					\
} while (0)
#ifdef _TESTING_
# define DEBUGMSG(format...)				\
	syslog(LOG_DEBUG, format);
#else
# define DEBUGMSG(format...)				\
	if ( bootargs.isdebug ) {			\
	  openlog(SYSLOG_IDENT, LOG_PID, LOG_USER);	\
 	  syslog(LOG_DEBUG, format);			\
	  closelog();					\
	}
#endif

#define NAME_ISDIR(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	 S_ISDIR((statbuf)->st_mode))

#define NAME_ISREG(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	 S_ISREG((statbuf)->st_mode))

#define NAME_ISLNK(name,statbuf)		\
	((! lstat(name,statbuf)) &&		\
	 S_ISLNK((statbuf)->st_mode))

#define NAME_ISEXE(name,statbuf)		\
	((! stat(name,statbuf))     &&		\
	S_ISREG((statbuf)->st_mode) &&		\
	(S_IXUSR & (statbuf)->st_mode))

#define NAME_ISCHR(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	S_ISCHR((statbuf)->st_mode))

#define NAME_ISBLK(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	S_ISBLK((statbuf)->st_mode))

#define NAME_ISDEV(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	(S_ISCHR((statbuf)->st_mode) ||		\
	 S_ISBLK((statbuf)->st_mode)))

#define NAME_ISFIFO(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	S_ISFIFO((statbuf)->st_mode))

#define NAME_ISSOCK(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	S_ISSOCK((statbuf)->st_mode))

#define NAME_ISNODE(name,statbuf)		\
	((! stat(name,statbuf)) &&		\
	(S_ISCHR((statbuf)->st_mode)  ||	\
	 S_ISBLK((statbuf)->st_mode)  ||	\
	 S_ISFIFO((statbuf)->st_mode) ||	\
	 S_ISSOCK((statbuf)->st_mode))

#define is_xfs (!access("/sbin/mkfs.xfs", X_OK) && !is_filesystem_supported("xfs"))
#define is_ext3 (!is_filesystem_supported("ext3"))
#define is_reiserfs (!access("/sbin/mkreiserfs", X_OK) && !is_filesystem_supported("reiserfs"))

extern int unmount_dir(char * dir);

struct BootArgs {
  char *root;
  char *lang;
  char *kbd;
  char *mouse; 
  char *disksize;
  char *flavor;
  char *console;
  int cdrom;
  int ismono;
  int isdebug;
  int isverbose;
  int isquiet;
} bootargs;

enum extract_type {
    kernel, debootstrap, problem_report,
#if #cpu(alpha)
    milo, apb
#endif
} disqtype;

/* added for the modules preload */
#define MOD_SAVE_DIR "/tmp/mod-save-dir"
#define MOD_SAVE_FILE "/tmp/mod-save-dir/save.txt"

/* We should plan to do away with this static buffer and use asprintf()/free() throughought the code. */
#define PRTBUFSIZE 3364		/* (ceil(log2(80*43)))^2 */
char prtbuf[PRTBUFSIZE];
char *InstallationRootDevice,*Archive_Dir; 
struct fdisk_partition *Boot;
struct fdisk_partition *Root;
int noSwap, notCreatedBootFloppy, notInstalledLILO;
extern char *kernel_cd, *base_cd;
extern int wants_cd, probe_mode;

extern const char * fs_type_tab[];

struct fdisk_partition *
    select_not_mounted(const char *message, const char *title, int ntypes, ...);
struct fdisk_partition *
    select_mounted(const char *message, const char *title);

/* Predicates */
int supported_filesystem(const char* fsname);
int have_unused_partitions (void);
int has_cdrom (void);
extern void debcdrom_failure (void);

/* Utilities */
int choose_medium(void);
int mount_and_check_floppy (char *device, const char *type, const char *text);
int getFloppies(const char *message, const char *device, const char *filename, char **basenames, const char *series);
const char* target_path(const char* s);
char* get_device(const char* diskimage); /* extract_kernel.c */
void release_device(const char* device); /* extract_kernel.c */
int unmount_dir(char* mount_directory); /* partition_config.c */

/* Semi internal use only */
int install_floppy (char *device, const char *type, const char *text); /* extract_kernel.c */
int install_from_file (const char *filename, const char *descr); /* extract_kernel.c */
int extract_from_file (const char *fil, const char *descr); /* extract_base.c */

int configure_keyboard_m (void);

/* Main menu callouts */
int main_menu (void);
int release_notes(const char *);
int partition_disk (void);
int init_swap (void);
int activate_swap (void);
int no_swap (void);
int init_linux (void);
int mount_any (void);
int unmount_any (void);
int configure_keyboard (char* kbd);
int extract_kernel_and_modules (void);
int configure_drivers (void);
int configure_hostname (void);
int configure_network (void);
int configure_pcmcia (void);
int debootstrap_extract_base (void);
int make_bootable (void);
int make_boot_floppy (void);
int configure_base (void);
int view_partitions (void);
int interactive_shell (void);
int reboot_system (void);
int halt_system (void);
int chroot_start (void);
int load_modules_after_boot();
int load_modules_after_boot_ac();
int add_modules_from_floppy(void);
int edit_append_line();
int generate_problem_report();
int attach_disk(void);

/**  ToDo: Make these into a shared object library  **/
/* PETA: functionns from old busybox */
char * block_device(char *name);

/* Code swiped from busybox, and now out of sync. */
extern int isDirectory(const char *name);
extern int fullWrite(int fd, const char *buf, int len);
extern int copyFile(const char *srcName, const char *destName, int setModes,
		    int followLinks);
/* This has bugs fixed in the busybox version... */
extern int recursiveAction(const char *fileName, int recurse, int followLinks, int depthFirst,
	  int (*fileAction) (const char *fileName, struct stat* statbuf),
	  int (*dirAction) (const char *fileName, struct stat* statbuf));
extern int del_loop(const char *device);
extern int set_loop(const char *device, const char *file, int offset, int *loopro);
extern char *find_unused_loop_device (void);
extern void get_kver(void);
extern void find_debian_cdrom(char **foo, char **bar);
extern void slurp_language_pack (void);

extern char *concat_paths(const char *path1, const char *path2);

extern char *kver;
extern char *append_opts;
extern char kernel_image_path[PATH_MAX + 1];
extern char drivers_path[PATH_MAX + 1];
extern int serialConsole;
extern char *Arch2;

extern void install_segv_handler(void);

#if #cpu(powerpc)
extern char *Arch3;
extern char *Arch4;
#endif

#ifdef USE_LANGUAGE_CHOOSER
#include "langs/langs.h"

extern const struct language_item *lang;
#endif

#if #cpu (m68k)

# define SERIAL_CONSOLE		/* serial console recognized */
# define DO_EJECT		/* auto eject floppy drives */
# define SCSI_FLOPPY
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */
void find_scsi_floppy (void);

#elif #cpu (sparc)

# define SERIAL_CONSOLE		/* serial console recognized */
# define DO_EJECT		/* auto eject floppy drives */
# define NFSROOT		/* network boot */

#elif #cpu (i386)

# define PCMCIA			/* pcmcia configuration supported */
# define SERIAL_CONSOLE		/* serial console recognized */
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */

#elif #cpu (ia64)

# define SERIAL_CONSOLE		/* serial console recognized */
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */

#elif #cpu (powerpc)

# define PCMCIA			/* pcmcia configuration supported */
# define SERIAL_CONSOLE		/* serial console recognized */
# define DO_EJECT		/* auto eject floppy drives */
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */

#elif #cpu (alpha)

# define SERIAL_CONSOLE		/* serial console recognized */
# define NFSROOT		/* network boot */
# define LOCALTIME		/* ask for GMT or localtime clock setup */

extern int srm_boot; /* flag - did we boot from SRM or MILO? */
extern char milo_binary_path[PATH_MAX+1];

#elif #cpu (arm)

# define SERIAL_CONSOLE		/* serial console recognized */
# define NFSROOT		/* network boot */

#elif #cpu (mips)
 
# define SERIAL_CONSOLE         /* serial console recognized */
# define NFSROOT                /* network boot */
# define LOCALTIME              /* ask for GMT or localtime clock setup */

#elif #cpu (mipsel)
 
# define SERIAL_CONSOLE         /* serial console recognized */
# define NFSROOT                /* network boot */
# define LOCALTIME              /* ask for GMT or localtime clock setup */

#elif #cpu (hppa)

# define SERIAL_CONSOLE         /* serial console recognized */
# define NFSROOT		/* network boot */

#elif #cpu (s390)


#endif

#ifdef DO_EJECT
void eject_floppy(const char *device);
int do_eject (void);
#else
# define eject_floppy(device)	/* nada */
#endif
#endif
