#!/usr/bin/perl -w

$c = "C";

opendir(DIR, $c) ||
    die "cd to scripts/rescue/messages before running this\n";

while (defined($_ = readdir DIR)) {
    if (-f "$c/$_") { ($sig{$_}, $n{$_}) = &sig("$c/$_"); }
}

closedir DIR;

opendir(LANG, ".") || die;
while (defined($l = readdir LANG)) {
    if (-d $l && $l ne "CVS" && $l ne $c && $l !~ /^\.\.?$/) {
	foreach (sort keys %sig) {
	    ($x, $n) = &sig("$l/$_");
	    if (!defined $x) {
		print "$l/$_: MISSING\n";
	    }
	    else {
		if ($x ne $sig{$_}) {
		    print "$l/$_: $x != $sig{$_}\n";
		}
		if ($n != 24 && $n{$_} == 24) {
		    print "$l/$_: does not have 24 lines\n";
		}
	    }
	}
    }
}
close LANG;

exit;

sub sig {
    local $_;
    local $r = "";
    local $n = 0;
    open(F, "<$_[0]") || return undef;
    while (<F>) {
	foreach $x (split(/(\x0f..)/, $_)) {
	    $r .= $1 if $x =~ /^\x0f(..)$/;
	}
	++$n;
    }
    close F;
    ($r, $n);
}
