//
//  Copyright (c) 2000-2002
//  Joerg Walter, Mathias Koch
//
//  Permission to use, copy, modify, distribute and sell this software
//  and its documentation for any purpose is hereby granted without fee,
//  provided that the above copyright notice appear in all copies and
//  that both that copyright notice and this permission notice appear
//  in supporting documentation.  The authors make no representations
//  about the suitability of this software for any purpose.
//  It is provided "as is" without express or implied warranty.
//
//  The authors gratefully acknowledge the support of
//  GeNeSys mbH & Co. KG in producing this work.
//

#ifndef TEST3_H
#define TEST3_H

#include <iostream>

#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/vector_proxy.hpp>
#include <boost/numeric/ublas/vector_sparse.hpp>
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/matrix_proxy.hpp>
#include <boost/numeric/ublas/matrix_sparse.hpp>
#ifdef USE_GENERALIZED_VECTOR_OF_VECTOR
#include <boost/numeric/ublas/vector_of_vector.hpp>
#endif
#include <boost/numeric/ublas/io.hpp>

namespace ublas = boost::numeric::ublas;

template<class V>
void initialize_vector (V &v) {
    int size = v.size ();
    for (int i = 0; i < size; i += 2)
        v [i] = i + 1.f;
}

template<class M>
void initialize_matrix (M &m) {
    int size1 = m.size1 ();
    int size2 = m.size2 ();
    for (int i = 0; i < size1; i += 2)
        for (int j = 0; j < size2; j += 2)
            m (i, j) = i * size1 + j + 1.f;
}

void test_vector ();
void test_matrix_vector ();
void test_matrix ();

// Disable some tests for truly broken compilers
    // MSVC Version 6.0 & 7.0 have problems compiling with std::complex
#if defined(BOOST_MSVC) && (BOOST_MSVC <= 1300)
#undef USE_STD_COMPLEX
#endif

    // Intel for Windows fails to link when a std::complex is returned!
#if defined(BOOST_INTEL_CXX_VERSION) && (BOOST_INTEL_CXX_VERSION <= 800) && defined(__ICL)
#undef USE_STD_COMPLEX
#endif

#endif
