/***************************************************************************
                       dlgexcept.cpp  -  description
                             -------------------
    begin                : Sat Feb 08 2003
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#include "dlgexcept.h"

#include <QLabel>
#include <QString>
#include <QPixmap>
#include <QMessageBox>

/***************************************************************************
 *                                                                         *
 *   DlgExcept::DlgExcept()                                                *
 *                                                                         *
 *   Parameters:                                                           *
 *      const BkException &e                                               *
 *      QWidget *parent                                                    *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class constructor                                                  *
 *                                                                         *
 ***************************************************************************/

DlgExcept::DlgExcept(const BkException &e, QWidget *parent) :
	QDialog(parent)
{
	setupUi(this);

	labelMsg->setWordWrap( true );
	labelMsg->setText(e.msg());

	QString detailmsg;
	detailmsg.sprintf("The error occured on line %d of ", e.line());
	detailmsg += e.file();
	labelDetails->setText(detailmsg);
	labelDetails->hide();

	pixmapIcon->setPixmap(QMessageBox::standardIcon(QMessageBox::Critical));
}

/***************************************************************************
 *                                                                         *
 *   DlgExcept::on_buttonDetails_clicked()                                 *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Called when the user clicks on the Details button.                 *
 *                                                                         *
 ***************************************************************************/

void DlgExcept::on_buttonDetails_clicked(void)
{
	buttonDetails->hide();
	labelDetails->show();
}
