/***************************************************************************
                          bkutil.h  -  description
                             -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   The BkUtil class acts as a container of sorts for various functions   *
 *   operating on the browsers and the master bookmark tree.               *
 *                                                                         *
 ***************************************************************************/

#ifndef BKUTIL_H
#define BKUTIL_H

#include "bridgecfg.h"
#include "bkexcept.h"

class BkUtil
{
public:
	BkUtil(BridgeCfg & cfg);
	~BkUtil();

	void readBookmarksFromBrowsers(void) throw(BkException);
	void readBookmarkTree(void) throw(BkException)
			{ m_cfg.readBookmarksXbel(&m_root); }
	void saveBookmarksToBrowsers(void) const throw(BkException);

	BkFolder *root(void) { return m_root; }

	void setBrowserAsSource(BkFolder &folder, BRWSNUM browserOrd);

private:
	BridgeCfg & m_cfg;
public:
	BkFolder    *m_root;
};

#endif  // end of BKUTIL_H
