/***************************************************************************
                   iexplore.h  -  IExplore Class Definition
                             -------------------
    begin                : Sun Sep 15 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kenschenke at yahoo dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   In addition, as a special exception, Ken Schenke gives permission to  *
 *   link the code of this program with the Qt non-commercial edition (or  *
 *   with modified versions of the Qt non-commercial edition that use the  *
 *   same license as the Qt non-commercial edition, and distribute linked  *
 *   combinations including the two.  You must obey the GNU General Public *
 *   License in all respects for all of the code used other than the Qt    *
 *   Non-Commercial edition.  If you modify this file, you may extend this *
 *   exception to your version of the file, but you are not obligated to   *
 *   do so.  If you do not wish to do so, delete this exception statement  *
 *   from your version.                                                    *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   The IExplore class contains all Microsoft Internet Explorer specific  *
 *   code.                                                                 *
 *                                                                         *
 ***************************************************************************/

#ifndef IEXPLORE_H
#define IEXPLORE_H

#include "browserbk.h"

#include <qdir.h>

class IExplore : public BrowserBk
{
public:
	IExplore() { m_Root = NULL; }
	virtual ~IExplore() { delete m_Root; }

	virtual bool    AreBookmarksValid(const QString &bookmarks);
	virtual bool    BrowseForBookmarks(const BridgeCfg &cfg, QString &bookmarks, QWidget *parent=0);
#ifdef _WIN32
	virtual bool	DetectBrowser(const BridgeCfg &cfg, QStringList &paths);
#endif
	virtual void	readBookmarks(const QString &path, BRWSNUM browserOrd)
						throw(BkException);
	static	void	saveBookmarks(const QString &path, BkFolder &root, BRWSNUM browserOrd)
						throw(BkException)
						{ saveBookmarksX(path, root, browserOrd); }
	static BrowserBk *classFactory(void);

protected:
	virtual BkFolder & root(void) { return *m_Root; }

private:
	bool			checkFolderForUrlFiles(const QString &folder, bool recurse=false);
	void			readFolder(const QString &path, BkFolder &folder, BRWSNUM browserOrd)
						throw(BkException);
	void			readUrlFile(QFileInfo *fi, BkBookmark &bk) throw(BkException);
	static  void	saveBookmarksX(const QString &path, BkFolder &folder, BRWSNUM browserOrd)
						throw(BkException);

	BkFolder	*m_Root;
};

#endif  // end of IEXPLORE_H
